/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataLogger;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONObject;
import java.util.ArrayList;

public class YOldDataStream
extends YDataStream {
    private YDataLogger _dataLogger;
    private int _timeStamp;
    private int _interval;

    public YOldDataStream(YDataLogger parent, int run, int stamp, long utc, int itv) {
        super(parent);
        this._dataLogger = parent;
        this._runNo = run;
        this._timeStamp = stamp;
        this._utcStamp = utc;
        this._interval = itv;
        this._samplesPerHour = 3600 / this._interval;
        this._isClosed = true;
        this._minVal = -1.79769313486231E308;
        this._avgVal = -1.79769313486231E308;
        this._maxVal = -1.79769313486231E308;
    }

    @Override
    public int loadStream() throws YAPI_Exception {
        int[] colofs;
        double[] colscl;
        YJSONArray coldiv = null;
        int[] coltyp = null;
        YJSONObject jsonObj = null;
        try {
            int i;
            String json_str = this._dataLogger.getData(this._runNo, this._timeStamp);
            jsonObj = new YJSONObject(json_str);
            jsonObj.parse();
            if (jsonObj.has("time")) {
                this._timeStamp = jsonObj.getInt("time");
            }
            if (jsonObj.has("UTC")) {
                this._utcStamp = jsonObj.getLong("UTC");
            }
            if (jsonObj.has("interval")) {
                this._interval = jsonObj.getInt("interval");
            }
            if (jsonObj.has("nRows")) {
                this._nRows = jsonObj.getInt("nRows");
            }
            if (jsonObj.has("keys")) {
                YJSONArray jsonKeys = jsonObj.getYJSONArray("keys");
                if (this._nCols == 0) {
                    this._nCols = jsonKeys.length();
                } else if (this._nCols != jsonKeys.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                this._columnNames = new ArrayList(this._nCols);
                for (i = 0; i < jsonKeys.length(); ++i) {
                    this._columnNames.add(jsonKeys.getString(i));
                }
            }
            if (jsonObj.has("div")) {
                coldiv = jsonObj.getYJSONArray("div");
                if (this._nCols == 0) {
                    this._nCols = coldiv.length();
                } else if (this._nCols != coldiv.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
            }
            if (jsonObj.has("type")) {
                YJSONArray types = jsonObj.getYJSONArray("type");
                if (this._nCols == 0) {
                    this._nCols = types.length();
                } else if (this._nCols != types.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                coltyp = new int[this._nCols];
                for (int c = 0; c < this._nCols; ++c) {
                    coltyp[c] = types.getInt(c);
                }
            }
            if (jsonObj.has("scal")) {
                YJSONArray json_colscl = jsonObj.getYJSONArray("scal");
                if (this._nCols == 0) {
                    this._nCols = json_colscl.length();
                } else if (this._nCols != json_colscl.length()) {
                    this._nCols = 0;
                    throw new YAPI_Exception(-8, "DataStream corrupted");
                }
                colscl = new double[json_colscl.length()];
                colofs = new int[json_colscl.length()];
                for (i = 0; i < json_colscl.length(); ++i) {
                    double dval = json_colscl.getDouble(i);
                    colscl[i] = dval / 65536.0;
                    assert (coltyp != null);
                    colofs[i] = coltyp[i] != 0 ? -32767 : 0;
                }
            } else {
                assert (coldiv != null);
                colscl = new double[coldiv.length()];
                colofs = new int[coldiv.length()];
                for (int i2 = 0; i2 < coldiv.length(); ++i2) {
                    colscl[i2] = 1.0 / coldiv.getDouble(i2);
                    assert (coltyp != null);
                    colofs[i2] = coltyp[i2] != 0 ? -32767 : 0;
                }
            }
        }
        catch (Exception ex) {
            throw new YAPI_Exception(-8, "json parse error");
        }
        if (jsonObj != null && jsonObj.has("data")) {
            if (this._nCols == 0 || coldiv == null || coltyp == null) {
                throw new YAPI_Exception(-8, "DataStream corrupted");
            }
            ArrayList<Integer> udata = null;
            String data = jsonObj.getString("data");
            udata = YAPIContext._decodeWords(data);
            if (udata == null) {
                YJSONArray jsonData = jsonObj.getYJSONArray("data");
                udata = new ArrayList();
                for (int i = 0; i < jsonData.length(); ++i) {
                    udata.add(jsonData.getInt(i));
                }
            }
            this._values = new ArrayList();
            ArrayList<Double> dat = new ArrayList<Double>();
            int c = 0;
            for (int val_i : udata) {
                double val_d = coltyp[c] < 2 ? (double)(val_i + colofs[c]) * colscl[c] : YAPIContext._decimalToDouble(val_i - Short.MAX_VALUE);
                dat.add(val_d);
                if (++c != this._nCols) continue;
                this._values.add(dat);
                dat = new ArrayList();
                c = 0;
            }
        }
        return 0;
    }

    @Override
    public int get_startTime() {
        return this._timeStamp;
    }

    public int getStartTime() {
        return this._timeStamp;
    }

    @Override
    public double get_dataSamplesInterval() {
        return this._interval;
    }

    public double getDataSamplesInterval() {
        return this._interval;
    }
}

