/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;

public class YAccelerometer
extends YSensor {
    public static final int BANDWIDTH_INVALID = Integer.MIN_VALUE;
    public static final double XVALUE_INVALID = -1.79769313486231E308;
    public static final double YVALUE_INVALID = -1.79769313486231E308;
    public static final double ZVALUE_INVALID = -1.79769313486231E308;
    public static final int GRAVITYCANCELLATION_OFF = 0;
    public static final int GRAVITYCANCELLATION_ON = 1;
    public static final int GRAVITYCANCELLATION_INVALID = -1;
    protected int _bandwidth = Integer.MIN_VALUE;
    protected double _xValue = -1.79769313486231E308;
    protected double _yValue = -1.79769313486231E308;
    protected double _zValue = -1.79769313486231E308;
    protected int _gravityCancellation = -1;
    protected UpdateCallback _valueCallbackAccelerometer = null;
    protected TimedReportCallback _timedReportCallbackAccelerometer = null;

    protected YAccelerometer(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "Accelerometer";
    }

    protected YAccelerometer(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("bandwidth")) {
            this._bandwidth = json_val.getInt("bandwidth");
        }
        if (json_val.has("xValue")) {
            this._xValue = (double)Math.round(json_val.getDouble("xValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("yValue")) {
            this._yValue = (double)Math.round(json_val.getDouble("yValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("zValue")) {
            this._zValue = (double)Math.round(json_val.getDouble("zValue") * 1000.0 / 65536.0) / 1000.0;
        }
        if (json_val.has("gravityCancellation")) {
            this._gravityCancellation = json_val.getInt("gravityCancellation") > 0 ? 1 : 0;
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_bandwidth() throws YAPI_Exception {
        int res;
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return Integer.MIN_VALUE;
            }
            res = this._bandwidth;
        }
        return res;
    }

    public int getBandwidth() throws YAPI_Exception {
        return this.get_bandwidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_bandwidth(int newval) throws YAPI_Exception {
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            String rest_val = Integer.toString(newval);
            this._setAttr("bandwidth", rest_val);
        }
        return 0;
    }

    public int setBandwidth(int newval) throws YAPI_Exception {
        return this.set_bandwidth(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_xValue() throws YAPI_Exception {
        double res;
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._xValue;
        }
        return res;
    }

    public double getXValue() throws YAPI_Exception {
        return this.get_xValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_yValue() throws YAPI_Exception {
        double res;
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._yValue;
        }
        return res;
    }

    public double getYValue() throws YAPI_Exception {
        return this.get_yValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_zValue() throws YAPI_Exception {
        double res;
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._zValue;
        }
        return res;
    }

    public double getZValue() throws YAPI_Exception {
        return this.get_zValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_gravityCancellation() throws YAPI_Exception {
        int res;
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._gravityCancellation;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_gravityCancellation(int newval) throws YAPI_Exception {
        YAccelerometer yAccelerometer = this;
        synchronized (yAccelerometer) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("gravityCancellation", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YAccelerometer FindAccelerometer(String func) {
        Class<YAPI> clazz = YAPI.class;
        synchronized (YAPI.class) {
            YAccelerometer obj = (YAccelerometer)YFunction._FindFromCache("Accelerometer", func);
            if (obj == null) {
                obj = new YAccelerometer(func);
                YFunction._AddToCache("Accelerometer", func, obj);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YAccelerometer FindAccelerometerInContext(YAPIContext yctx, String func) {
        YAccelerometer obj;
        YAPIContext yAPIContext = yctx;
        synchronized (yAPIContext) {
            obj = (YAccelerometer)YFunction._FindFromCacheInContext(yctx, "Accelerometer", func);
            if (obj == null) {
                obj = new YAccelerometer(yctx, func);
                YFunction._AddToCache("Accelerometer", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackAccelerometer = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackAccelerometer != null) {
            this._valueCallbackAccelerometer.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        YAccelerometer sensor = this;
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(sensor, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(sensor, false);
        }
        this._timedReportCallbackAccelerometer = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackAccelerometer != null) {
            this._timedReportCallbackAccelerometer.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public YAccelerometer nextAccelerometer() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YAccelerometer.FindAccelerometerInContext(this._yapi, next_hwid);
    }

    public static YAccelerometer FirstAccelerometer() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Accelerometer");
        if (next_hwid == null) {
            return null;
        }
        return YAccelerometer.FindAccelerometerInContext(yctx, next_hwid);
    }

    public static YAccelerometer FirstAccelerometerInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Accelerometer");
        if (next_hwid == null) {
            return null;
        }
        return YAccelerometer.FindAccelerometerInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YAccelerometer var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YAccelerometer var1, String var2);
    }
}

