/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YUSBHub;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class YAPI {
    public static int DefaultCacheValidity = 5;
    public static final String INVALID_STRING = "!INVALID!";
    public static final double INVALID_DOUBLE = -1.79769313486231E308;
    public static final int INVALID_INT = Integer.MIN_VALUE;
    public static final long INVALID_LONG = -9223372036854775807L;
    public static final int INVALID_UINT = -1;
    public static final String YOCTO_API_VERSION_STR = "1.10";
    public static final String YOCTO_API_BUILD_STR = "29543";
    public static final int YOCTO_API_VERSION_BCD = 272;
    public static final int YOCTO_VENDORID = 9440;
    public static final int YOCTO_DEVID_FACTORYBOOT = 1;
    public static final int YOCTO_DEVID_BOOTLOADER = 2;
    public static final int HASH_BUF_SIZE = 28;
    public static final int SUCCESS = 0;
    public static final int NOT_INITIALIZED = -1;
    public static final int INVALID_ARGUMENT = -2;
    public static final int NOT_SUPPORTED = -3;
    public static final int DEVICE_NOT_FOUND = -4;
    public static final int VERSION_MISMATCH = -5;
    public static final int DEVICE_BUSY = -6;
    public static final int TIMEOUT = -7;
    public static final int IO_ERROR = -8;
    public static final int NO_MORE_DATA = -9;
    public static final int EXHAUSTED = -10;
    public static final int DOUBLE_ACCES = -11;
    public static final int UNAUTHORIZED = -12;
    public static final int RTC_NOT_READY = -13;
    public static final int FILE_NOT_FOUND = -14;
    static final String DefaultEncoding = "ISO-8859-1";
    static final int YOCTO_CALIB_TYPE_OFS = 30;
    public static final int YOCTO_MANUFACTURER_LEN = 20;
    public static final int YOCTO_SERIAL_LEN = 20;
    public static final int YOCTO_BASE_SERIAL_LEN = 8;
    public static final int YOCTO_PRODUCTNAME_LEN = 28;
    public static final int YOCTO_FIRMWARE_LEN = 22;
    public static final int YOCTO_LOGICAL_LEN = 20;
    public static final int YOCTO_FUNCTION_LEN = 20;
    static final int YOCTO_PUBVAL_SIZE = 6;
    static final int YOCTO_PUBVAL_LEN = 16;
    static final int YOCTO_PASS_LEN = 20;
    static final int YOCTO_REALM_LEN = 20;
    public static final int DETECT_NONE = 0;
    public static final int DETECT_USB = 1;
    public static final int DETECT_NET = 2;
    public static final int RESEND_MISSING_PKT = 4;
    public static final int DETECT_ALL = 3;
    static final HashMap<String, YPEntry.BaseClass> _BaseType = new HashMap();
    private static HashMap<Long, YAPIContext> _MultipleYAPI;
    private static YAPIContext _SingleYAPI;

    public static synchronized void SetThreadSpecificMode() throws YAPI_Exception {
        if (_SingleYAPI != null) {
            throw new YAPI_Exception(-2, "SetSingleThreadMode must be called before start using the Yoctopuce API");
        }
        _MultipleYAPI = new HashMap();
    }

    static synchronized YAPIContext GetYCtx(boolean instanciateNew) {
        if (_MultipleYAPI != null) {
            YAPIContext context = _MultipleYAPI.get(Thread.currentThread().getId());
            if (context == null && instanciateNew) {
                context = new YAPIContext();
                _MultipleYAPI.put(Thread.currentThread().getId(), context);
            }
            return context;
        }
        if (_SingleYAPI == null && instanciateNew) {
            _SingleYAPI = new YAPIContext();
        }
        return _SingleYAPI;
    }

    public static void SetUSBPacketAckMs(int pktAckDelay) {
        YAPIContext yctx = YAPI.GetYCtx(true);
        yctx.SetUSBPacketAckMs(pktAckDelay);
    }

    public static String GetAPIVersion() {
        return "1.10.29543" + YUSBHub.getAPIVersion();
    }

    public static int InitAPI(int mode) throws YAPI_Exception {
        YAPIContext yctx = YAPI.GetYCtx(true);
        return yctx.InitAPI(mode);
    }

    public static void FreeAPI() {
        if (_MultipleYAPI != null) {
            YAPIContext yctx = _MultipleYAPI.get(Thread.currentThread().getId());
            if (yctx != null) {
                yctx.FreeAPI();
            }
            _MultipleYAPI.remove(Thread.currentThread().getId());
        } else {
            YAPIContext yctx = _SingleYAPI;
            if (yctx != null) {
                yctx.FreeAPI();
            }
            _SingleYAPI = null;
        }
    }

    public static int RegisterHub(String url) throws YAPI_Exception {
        return YAPI.GetYCtx(true).RegisterHub(url);
    }

    public static int RegisterHub(String url, InputStream request, OutputStream response) throws YAPI_Exception {
        return YAPI.GetYCtx(true).RegisterHub(url, request, response);
    }

    public static int PreregisterHubWebSocketCallback(Object session) throws YAPI_Exception {
        return YAPI.GetYCtx(true).PreregisterHubWebSocketCallback(session, null, null);
    }

    public static int PreregisterHubWebSocketCallback(Object session, String user, String pass) throws YAPI_Exception {
        return YAPI.GetYCtx(true).PreregisterHubWebSocketCallback(session, user, pass);
    }

    public static void UnregisterHubWebSocketCallback(Object session) {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            return;
        }
        yCtx.UnregisterHubWebSocketCallback(session);
    }

    public static void EnableUSBHost(Object osContext) throws YAPI_Exception {
        YAPI.GetYCtx(true).EnableUSBHost(osContext);
    }

    public static int PreregisterHub(String url) throws YAPI_Exception {
        return YAPI.GetYCtx(true).PreregisterHub(url);
    }

    public static void UnregisterHub(String url) {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            return;
        }
        yCtx.UnregisterHub(url);
    }

    public static int TestHub(String url, int mstimeout) throws YAPI_Exception {
        return YAPI.GetYCtx(true).TestHub(url, mstimeout);
    }

    public static int UpdateDeviceList() throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.UpdateDeviceList();
    }

    public static int HandleEvents() throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.HandleEvents();
    }

    public static int Sleep(long ms_duration) throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.Sleep(ms_duration);
    }

    public static int TriggerHubDiscovery() throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.TriggerHubDiscovery();
    }

    public static long GetTickCount() {
        return System.currentTimeMillis();
    }

    public static boolean CheckLogicalName(String name) {
        return name != null && (name.equals("") || name.length() <= 19 && name.matches("^[A-Za-z0-9_-]*$"));
    }

    public static void RegisterDeviceArrivalCallback(DeviceArrivalCallback arrivalCallback) {
        YAPI.GetYCtx(true).RegisterDeviceArrivalCallback(arrivalCallback);
    }

    public static void RegisterDeviceChangeCallback(DeviceChangeCallback changeCallback) {
        YAPI.GetYCtx(true).RegisterDeviceChangeCallback(changeCallback);
    }

    public static void RegisterDeviceRemovalCallback(DeviceRemovalCallback removalCallback) {
        YAPI.GetYCtx(true).RegisterDeviceRemovalCallback(removalCallback);
    }

    public static void RegisterHubDiscoveryCallback(HubDiscoveryCallback hubDiscoveryCallback) {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            return;
        }
        yCtx.RegisterHubDiscoveryCallback(hubDiscoveryCallback);
    }

    public static void RegisterLogFunction(LogCallback logfun) {
        YAPI.GetYCtx(true).RegisterLogFunction(logfun);
    }

    static {
        _BaseType.put("Function", YPEntry.BaseClass.Function);
        _BaseType.put("Sensor", YPEntry.BaseClass.Sensor);
        _MultipleYAPI = null;
        _SingleYAPI = null;
    }

    public static interface HubDiscoveryCallback {
        public void yHubDiscoveryCallback(String var1, String var2);
    }

    public static interface CalibrationHandlerCallback {
        public double yCalibrationHandler(double var1, int var3, ArrayList<Integer> var4, ArrayList<Double> var5, ArrayList<Double> var6);
    }

    public static interface LogCallback {
        public void yLog(String var1);
    }

    public static interface DeviceChangeCallback {
        public void yDeviceChange(YModule var1);
    }

    public static interface DeviceRemovalCallback {
        public void yDeviceRemoval(YModule var1);
    }

    public static interface DeviceArrivalCallback {
        public void yDeviceArrival(YModule var1);
    }
}

