/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.NotificationHandler;
import com.yoctopuce.YoctoAPI.WSRequest;
import com.yoctopuce.YoctoAPI.WSStream;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public class WSNotificationHandler
extends NotificationHandler
implements MessageHandler {
    private static final int NB_TCP_CHANNEL = 4;
    private static final int HUB_TCP_CHANNEL = 0;
    private static final int DEVICE_TCP_CHANNEL = 0;
    private static final int WS_REQUEST_MAX_DURATION = 50000;
    private static final int DEFAULT_TCP_ROUND_TRIP_TIME = 30;
    private static final int DEFAULT_TCP_MAX_WINDOW_SIZE = 262144;
    private final ExecutorService _executorService;
    private final boolean _isHttpCallback;
    private MessageDigest _sha1 = null;
    private MessageDigest _md5 = null;
    private Session _session;
    private final BlockingQueue<WSRequest> _pendingRequests = new LinkedBlockingQueue<WSRequest>();
    private final ArrayList<ArrayList<WSRequest>> _workingRequests;
    private final Object _stateLock = new Object();
    private volatile boolean _firstNotif;
    private volatile boolean _muststop;
    private long _connectionTime = 0L;
    private ConnectionState _connectionState = ConnectionState.CONNECTING;
    private int _remoteVersion = 0;
    private String _remoteSerial;
    private long _remoteNouce;
    private int _nounce;
    private volatile int _session_errno;
    private volatile String _session_error;
    private boolean _rwAccess = false;
    private long _tcpRoundTripTime = 30L;
    private int _tcpMaxWindowSize = 262144;
    private final int[] _lastUploadAckBytes = new int[4];
    private final long[] _lastUploadAckTime = new long[4];
    private final int[] _lastUploadRateBytes = new int[4];
    private final long[] _lastUploadRateTime = new long[4];
    private int _uploadRate = 0;
    private byte _nextAsyncId = (byte)48;
    private long _next_transmit_tm = 0L;
    private final Object _sendLock = new Object();
    private final StringBuilder _notificationsFifo = new StringBuilder();

    WSNotificationHandler(YHTTPHub hub, Object session) {
        super(hub);
        this._session = (Session)session;
        boolean bl = this._isHttpCallback = session != null;
        if (this._isHttpCallback) {
            MessageHandler.Whole<ByteBuffer> messageHandler = new MessageHandler.Whole<ByteBuffer>(){

                public void onMessage(ByteBuffer byteBuffer) {
                    WSNotificationHandler.this.parseBinaryMessage(byteBuffer);
                }
            };
            this._session.addMessageHandler((MessageHandler)messageHandler);
        }
        this._workingRequests = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            this._workingRequests.add(i, new ArrayList());
        }
        this._executorService = Executors.newFixedThreadPool(1);
        this._muststop = false;
        try {
            this._sha1 = MessageDigest.getInstance("SHA-1");
            this._md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._firstNotif = true;
        if (this._isHttpCallback) {
            this.runOnSession();
        } else {
            URI uri;
            WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
            String url = "ws://" + this._hub._http_params.getUrl(false, false) + "/not.byn";
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return;
            }
            while (!Thread.currentThread().isInterrupted() && !this._muststop) {
                if (this._error_delay > 0) {
                    try {
                        Thread.sleep(this._error_delay);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                Object e = this._stateLock;
                synchronized (e) {
                    this._connectionState = ConnectionState.CONNECTING;
                }
                try {
                    this._session = webSocketContainer.connectToServer((Object)this, uri);
                    this.runOnSession();
                }
                catch (IOException | DeploymentException e2) {
                    e2.printStackTrace();
                }
                this._firstNotif = true;
                ++this._notifRetryCount;
                this._hub._devListValidity = 500L;
                this._error_delay = 100 << (this._notifRetryCount > 4 ? 4 : this._notifRetryCount);
            }
        }
        try {
            this._session.close();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        Object object = this._stateLock;
        synchronized (object) {
            this._connectionState = ConnectionState.DEAD;
            if (this._session_errno == 0) {
                this._session_errno = -8;
                this._session_error = "WS Session is closed";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnSession() {
        if (!this._session.isOpen()) {
            this.WSLOG("WebSocket is not open");
            return;
        }
        String errmsg = "WebSocket session is closed";
        RemoteEndpoint.Basic basicRemote = this._session.getBasicRemote();
        try {
            long timeout = System.currentTimeMillis() + 10000L;
            Object object = this._stateLock;
            synchronized (object) {
                while (this._connectionState == ConnectionState.CONNECTING && !this._muststop) {
                    this._stateLock.wait(1000L);
                    if (timeout >= System.currentTimeMillis()) continue;
                    this.WSLOG("YoctoHub did not send any data for 10 secs");
                    this._connectionState = ConnectionState.DISCONNECTED;
                    this._stateLock.notifyAll();
                    return;
                }
            }
            while (!Thread.currentThread().isInterrupted() && !this._muststop && this._session.isOpen()) {
                long now = YAPI.GetTickCount();
                long wait = this._next_transmit_tm >= now ? this._next_transmit_tm - now : 1000L;
                WSRequest request = this._pendingRequests.poll(wait, TimeUnit.MILLISECONDS);
                if (request != null) {
                    if (request.getState().equals((Object)WSRequest.State.ERROR)) break;
                    ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
                    synchronized (arrayList) {
                        request.reportStartOfProcess();
                        this._workingRequests.get(request.getChannel()).add(request);
                    }
                }
                this.processRequests(basicRemote);
            }
        }
        catch (Exception ex) {
            errmsg = ex.getLocalizedMessage();
        }
        try {
            WSRequest wsRequest = this._pendingRequests.poll(10L, TimeUnit.MILLISECONDS);
            while (wsRequest != null) {
                wsRequest.setError(-8, errmsg);
                wsRequest = this._pendingRequests.poll(10L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object object = this._workingRequests;
        synchronized (object) {
            for (int i = 0; i < 4; ++i) {
                for (WSRequest request : this._workingRequests.get(i)) {
                    request.setError(-8, errmsg);
                }
                this._workingRequests.get(i).clear();
            }
        }
        object = this._stateLock;
        synchronized (object) {
            this._connectionState = ConnectionState.DISCONNECTED;
            this._stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSRequest sendRequest(String req_first_line, byte[] req_head_and_body, int tcpchanel, boolean async, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception, InterruptedException {
        WSRequest request;
        byte[] full_request;
        byte[] req_first_lineBytes;
        if (req_head_and_body == null) {
            req_first_line = req_first_line + "\r\n\r\n";
            full_request = req_first_lineBytes = req_first_line.getBytes();
        } else {
            req_first_line = req_first_line + "\r\n";
            req_first_lineBytes = req_first_line.getBytes();
            full_request = new byte[req_first_lineBytes.length + req_head_and_body.length];
            System.arraycopy(req_first_lineBytes, 0, full_request, 0, req_first_lineBytes.length);
            System.arraycopy(req_head_and_body, 0, full_request, req_first_lineBytes.length, req_head_and_body.length);
        }
        long timeout = System.currentTimeMillis() + 50000L;
        Object object = this._stateLock;
        synchronized (object) {
            while (this._connectionState != ConnectionState.CONNECTED && this._connectionState != ConnectionState.DEAD) {
                this._stateLock.wait(1000L);
                if (timeout >= System.currentTimeMillis()) continue;
                if (this._connectionState != ConnectionState.CONNECTED && this._connectionState != ConnectionState.CONNECTING) {
                    throw new YAPI_Exception(-8, "IO error with hub");
                }
                throw new YAPI_Exception(-7, "Last request did not finished correctly");
            }
            if (this._connectionState == ConnectionState.DEAD) {
                throw new YAPI_Exception(this._session_errno, this._session_error);
            }
            if (async) {
                byte by = this._nextAsyncId;
                this._nextAsyncId = (byte)(by + 1);
                request = new WSRequest(tcpchanel, by, full_request);
                if (this._nextAsyncId >= 127) {
                    this._nextAsyncId = (byte)48;
                }
            } else {
                request = new WSRequest(tcpchanel, full_request, progress, context);
            }
        }
        this._pendingRequests.put(request);
        return request;
    }

    private byte[] getRequestResponse(WSRequest wsRequest, int mstimeout) throws YAPI_Exception, InterruptedException {
        int hpos;
        WSRequest.State state = wsRequest.waitProcessingEnd(mstimeout);
        if (!state.equals((Object)WSRequest.State.CLOSED)) {
            wsRequest.checkError();
            wsRequest.log("Timeout");
            throw new YAPI_Exception(-7, "request did not finished correctly");
        }
        byte[] full_result = wsRequest.getResponseBytes();
        int okpos = YAPIContext._find_in_bytes(full_result, "OK".getBytes());
        if (okpos != 0) {
            okpos = YAPIContext._find_in_bytes(full_result, "HTTP/1.1 ".getBytes());
            int endl = YAPIContext._find_in_bytes(full_result, "\r\n".getBytes());
            if (okpos == 0 && endl > 8) {
                String line = new String(full_result, 9, endl - 9);
                String[] parts = line.trim().split(" ");
                if (parts[0].equals("401")) {
                    throw new YAPI_Exception(-12, "Authentication required");
                }
                throw new YAPI_Exception(line.trim());
            }
        }
        if ((hpos = YAPIContext._find_in_bytes(full_result, "\r\n\r\n".getBytes())) >= 0) {
            return Arrays.copyOfRange(full_result, hpos + 4, full_result.length);
        }
        return full_result;
    }

    @Override
    String getThreadLabel() {
        String label = "WS Notification handler session ";
        if (this._session != null) {
            label = label + "(session " + this._session.getId() + ")";
        }
        return label;
    }

    @Override
    public byte[] hubRequestSync(String req_first_line, byte[] req_head_and_body, int mstimeout) throws YAPI_Exception, InterruptedException {
        if (mstimeout == 0) {
            mstimeout = 86400000;
        }
        WSRequest wsRequest = this.sendRequest(req_first_line, req_head_and_body, 0, false, null, null);
        return this.getRequestResponse(wsRequest, mstimeout);
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body, int mstimeout, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception, InterruptedException {
        if (mstimeout == 0) {
            mstimeout = 86400000;
        }
        WSRequest wsRequest = this.sendRequest(req_first_line, req_head_and_body, 0, false, progress, context);
        return this.getRequestResponse(wsRequest, mstimeout);
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, final YGenericHub.RequestAsyncResult asyncResult, final Object asyncContext) throws YAPI_Exception, InterruptedException {
        final WSRequest wsRequest = this.sendRequest(req_first_line, req_head_and_body, 0, true, null, null);
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                byte[] response = null;
                int error_code = 0;
                String errmsg = null;
                try {
                    response = WSNotificationHandler.this.getRequestResponse(wsRequest, 20000);
                }
                catch (YAPI_Exception e) {
                    error_code = e.errorType;
                    errmsg = e.getLocalizedMessage();
                }
                catch (InterruptedException e) {
                    error_code = -8;
                    errmsg = e.getLocalizedMessage();
                }
                if (asyncResult != null) {
                    asyncResult.RequestAsyncDone(asyncContext, response, error_code, errmsg);
                }
            }
        });
    }

    @Override
    boolean waitAndFreeAsyncTasks(long timeout) throws InterruptedException {
        this._executorService.shutdown();
        boolean allTerminated = this._executorService.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        this._muststop = true;
        try {
            this._session.close();
        }
        catch (IOException | IllegalStateException e) {
            this.WSLOG("error on ws close : " + e.getMessage());
            e.printStackTrace();
        }
        return !allTerminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._connectionState == ConnectionState.CONNECTED || this._connectionState == ConnectionState.AUTHENTICATING || this._connectionState == ConnectionState.CONNECTING;
        }
    }

    @Override
    public boolean hasRwAccess() {
        return this._rwAccess;
    }

    @OnOpen
    public void onOpen(Session session) {
        this._session = session;
    }

    @OnMessage
    public void onMessage(ByteBuffer raw_data, Session session) {
        if (this._session != session) {
            return;
        }
        this.parseBinaryMessage(raw_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBinaryMessage(ByteBuffer raw_data) {
        raw_data.order(ByteOrder.LITTLE_ENDIAN);
        byte first_byte = raw_data.get();
        int tcpChanel = first_byte & 7;
        int ystream = (first_byte & 0xFF) >> 3;
        ArrayList<WSRequest> requestOfTCPChan = this._workingRequests.get(tcpChanel);
        switch (ystream) {
            case 8: {
                if (this._firstNotif) {
                    if (this._hub._http_params.hasAuthParam()) return;
                    Object object = this._stateLock;
                    synchronized (object) {
                        this._connectionState = ConnectionState.CONNECTED;
                        this._stateLock.notifyAll();
                    }
                    this._firstNotif = false;
                }
                byte[] chars = new byte[raw_data.remaining()];
                raw_data.get(chars);
                String tcpNotif = new String(chars, StandardCharsets.ISO_8859_1);
                this.decodeTCPNotif(tcpNotif);
                return;
            }
            case 0: {
                return;
            }
            case 9: {
                WSRequest workingRequest;
                ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
                synchronized (arrayList) {
                    workingRequest = requestOfTCPChan.size() > 0 ? requestOfTCPChan.get(0) : null;
                }
                if (workingRequest == null) return;
                if (raw_data.remaining() < 1) return;
                WSStream stream = new WSStream(ystream, tcpChanel, raw_data.remaining() - 1, raw_data);
                byte asyncId = raw_data.get();
                if (workingRequest.getAsyncId() != asyncId) {
                    this._hub._yctx._Log("WS: Incorrect async-close signature on tcpChan " + tcpChanel);
                    return;
                }
                workingRequest.addStream(stream);
                workingRequest.setState(WSRequest.State.CLOSED);
                ArrayList<ArrayList<WSRequest>> arrayList2 = this._workingRequests;
                synchronized (arrayList2) {
                    requestOfTCPChan.remove(workingRequest);
                    return;
                }
            }
            case 1: 
            case 2: {
                WSRequest workingRequest;
                ArrayList<ArrayList<WSRequest>> asyncId = this._workingRequests;
                synchronized (asyncId) {
                    workingRequest = requestOfTCPChan.size() > 0 ? requestOfTCPChan.get(0) : null;
                }
                if (workingRequest == null) return;
                WSStream stream = new WSStream(ystream, tcpChanel, raw_data.remaining(), raw_data);
                workingRequest.addStream(stream);
                if (ystream != 2) return;
                WSStream outstream = new WSStream(2, tcpChanel, 0, null);
                try {
                    RemoteEndpoint.Basic basicRemote = this._session.getBasicRemote();
                    Object object = this._sendLock;
                    synchronized (object) {
                        basicRemote.sendBinary(outstream.getContent(), true);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                workingRequest.setState(WSRequest.State.CLOSED);
                ArrayList<ArrayList<WSRequest>> e = this._workingRequests;
                synchronized (e) {
                    requestOfTCPChan.remove(workingRequest);
                    return;
                }
            }
            case 5: {
                int metatype = raw_data.get() & 0xFF;
                switch (metatype) {
                    case 4: {
                        int len;
                        int version = raw_data.get() & 0xFF;
                        if (version < 1) return;
                        if (raw_data.limit() < 28) {
                            return;
                        }
                        this._remoteVersion = version;
                        short maxtcpws = raw_data.getShort();
                        if (maxtcpws > 0) {
                            this._tcpMaxWindowSize = maxtcpws;
                        }
                        long nounce = raw_data.getInt();
                        nounce &= 0xFFFFFFFFFFFFFFFFL;
                        byte[] serial_char = new byte[raw_data.remaining()];
                        raw_data.get(serial_char);
                        for (len = 8; len < serial_char.length && serial_char[len] != 0; ++len) {
                        }
                        this._remoteSerial = new String(serial_char, 0, len, StandardCharsets.ISO_8859_1);
                        this._remoteNouce = nounce;
                        this._connectionTime = YAPI.GetTickCount();
                        Random randomGenerator = new Random();
                        this._nounce = randomGenerator.nextInt();
                        Object object = this._stateLock;
                        synchronized (object) {
                            this._connectionState = ConnectionState.AUTHENTICATING;
                            this._stateLock.notifyAll();
                        }
                        this.sendAuthenticationMeta();
                        return;
                    }
                    case 5: {
                        Object object = this._stateLock;
                        synchronized (object) {
                            if (this._connectionState != ConnectionState.AUTHENTICATING) {
                                return;
                            }
                        }
                        int version = raw_data.get() & 0xFF;
                        if (version < 1) return;
                        if (raw_data.limit() < 28) {
                            return;
                        }
                        this._tcpRoundTripTime = YAPI.GetTickCount() - this._connectionTime + 1L;
                        long uploadRate = (long)(this._tcpMaxWindowSize * 1000) / this._tcpRoundTripTime;
                        this._hub._yctx._Log(String.format("WS:RTT=%dms, WS=%d, uploadRate=%f KB/s\n", this._tcpRoundTripTime, this._tcpMaxWindowSize, (double)uploadRate / 1000.0));
                        int flags = raw_data.getShort() & 0xFFFF;
                        raw_data.getInt();
                        if ((flags & 2) != 0) {
                            this._rwAccess = true;
                        }
                        if ((flags & 1) != 0) {
                            byte[] remote_sha1 = new byte[20];
                            raw_data.get(remote_sha1);
                            byte[] sha1 = this.computeAUTH(this._hub._http_params.getUser(), this._hub._http_params.getPass(), this._remoteSerial, this._nounce);
                            if (Arrays.equals(sha1, remote_sha1)) {
                                Object object2 = this._stateLock;
                                synchronized (object2) {
                                    this._connectionState = ConnectionState.CONNECTED;
                                    this._stateLock.notifyAll();
                                    return;
                                }
                            }
                            this.errorOnSession(-12, String.format("Authentication as %s failed", this._hub._http_params.getUser()));
                            return;
                        }
                        if (!this._hub._http_params.hasAuthParam()) {
                            Object remote_sha1 = this._stateLock;
                            synchronized (remote_sha1) {
                                this._connectionState = ConnectionState.CONNECTED;
                                this._stateLock.notifyAll();
                                return;
                            }
                        }
                        if (this._hub._http_params.getUser().equals("admin") && !this._rwAccess) {
                            this.errorOnSession(-12, String.format("Authentication as %s failed", this._hub._http_params.getUser()));
                            return;
                        }
                        this.errorOnSession(-12, String.format("Authentication error : hub has no password for %s", this._hub._http_params.getUser()));
                        return;
                    }
                    case 6: {
                        raw_data.get();
                        int html_error = raw_data.getShort() & 0xFFFF;
                        if (html_error == 401) {
                            this.errorOnSession(-12, "Authentication failed");
                            return;
                        }
                        this.errorOnSession(-8, String.format("Remote hub closed connection with error %d", html_error));
                        return;
                    }
                    case 7: {
                        WSRequest workingRequest;
                        byte tcpchan = raw_data.get();
                        ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
                        synchronized (arrayList) {
                            ArrayList<WSRequest> uploadChandRequests = this._workingRequests.get(tcpchan);
                            workingRequest = uploadChandRequests.size() > 0 ? uploadChandRequests.get(0) : null;
                        }
                        if (workingRequest == null) return;
                        int b0 = raw_data.get() & 0xFF;
                        int b1 = raw_data.get() & 0xFF;
                        int b2 = raw_data.get() & 0xFF;
                        int b3 = raw_data.get() & 0xFF;
                        int ackBytes = b0 + (b1 << 8) + (b2 << 16) + (b3 << 24);
                        long ackTime = YAPI.GetTickCount();
                        if (this._lastUploadAckTime[tcpchan] != 0L && ackBytes > this._lastUploadAckBytes[tcpchan]) {
                            this._lastUploadAckBytes[tcpchan] = ackBytes;
                            this._lastUploadAckTime[tcpchan] = ackTime;
                            int deltaBytes = ackBytes - this._lastUploadRateBytes[tcpchan];
                            long deltaTime = ackTime - this._lastUploadRateTime[tcpchan];
                            if (deltaTime < 500L) {
                                return;
                            }
                            if (deltaTime < 1000L && deltaBytes < 65536) {
                                return;
                            }
                            this._lastUploadRateBytes[tcpchan] = ackBytes;
                            this._lastUploadRateTime[tcpchan] = ackTime;
                            workingRequest.reportProgress(ackBytes);
                            double newRate = (double)deltaBytes * 1000.0 / (double)deltaTime;
                            this._uploadRate = (int)(0.8 * (double)this._uploadRate + 0.3 * newRate);
                            this._hub._yctx._Log(String.format("Upload rate: %.2f KB/s (based on %.2f KB in %fs)\n", newRate / 1000.0, (double)deltaBytes / 1000.0, (double)deltaTime / 1000.0));
                            return;
                        }
                        this._hub._yctx._Log("First Ack received\n");
                        this._lastUploadAckBytes[tcpchan] = ackBytes;
                        this._lastUploadAckTime[tcpchan] = ackTime;
                        this._lastUploadRateBytes[tcpchan] = ackBytes;
                        this._lastUploadRateTime[tcpchan] = ackTime;
                        workingRequest.reportProgress(ackBytes);
                        return;
                    }
                }
                this.WSLOG(String.format("unhandled Meta pkt %d", ystream));
                return;
            }
        }
        this._hub._yctx._Log(String.format("Invalid WS stream type (%d)\n", ystream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequests(RemoteEndpoint.Basic remote) throws IOException {
        if (this._next_transmit_tm != 0L && this._next_transmit_tm > YAPI.GetTickCount()) {
            return;
        }
        for (int tcpchan = 0; tcpchan < 4; ++tcpchan) {
            WSRequest req;
            ArrayList<WSRequest> requestOfTCPChan = this._workingRequests.get(tcpchan);
            long chan0 = System.currentTimeMillis();
            int reqIndex = 0;
            ArrayList<ArrayList<WSRequest>> arrayList = this._workingRequests;
            synchronized (arrayList) {
                req = requestOfTCPChan.size() > reqIndex ? requestOfTCPChan.get(reqIndex) : null;
            }
            while (req != null) {
                ByteBuffer requestBytes = req.getRequestBytes();
                int throttle_start = requestBytes.position();
                int throttle_end = requestBytes.limit();
                if (throttle_end > 2108 && this._remoteVersion >= 2 && tcpchan == 0) {
                    if (requestBytes.position() == 0) {
                        throttle_end = 2108;
                        this._lastUploadAckBytes[tcpchan] = 0;
                        this._lastUploadAckTime[tcpchan] = 0L;
                        this._uploadRate = (int)((long)(this._tcpMaxWindowSize * 1000) / this._tcpRoundTripTime);
                    } else if (this._lastUploadAckTime[tcpchan] == 0L) {
                        throttle_end = 0;
                    } else {
                        long timeOnTheAir;
                        int uploadRate = this._uploadRate;
                        int bytesOnTheAir = requestBytes.position() - this._lastUploadAckBytes[tcpchan];
                        int toBeSent = (int)((long)(2 * uploadRate + 1024 - bytesOnTheAir) + (long)uploadRate * (timeOnTheAir = YAPI.GetTickCount() - this._lastUploadAckTime[tcpchan]) / 1000L);
                        if (toBeSent + bytesOnTheAir > 262144) {
                            toBeSent = 262144 - bytesOnTheAir;
                        }
                        this.WSLOG(String.format("throttling: %d bytes/s (%d + %d = %d)", this._uploadRate, toBeSent, bytesOnTheAir, bytesOnTheAir + toBeSent));
                        if (toBeSent < 64) {
                            long waitTime = 1000 * (128 - toBeSent) / this._uploadRate;
                            if (waitTime < 2L) {
                                waitTime = 2L;
                            }
                            this._next_transmit_tm = YAPI.GetTickCount() + waitTime;
                            this.WSLOG(String.format("WS: %d sent %dms ago, waiting %dms...", bytesOnTheAir, timeOnTheAir, waitTime));
                            throttle_end = 0;
                        }
                        if (throttle_end > requestBytes.position() + toBeSent) {
                            if (toBeSent > 124) {
                                toBeSent = toBeSent / 124 * 124;
                            }
                            throttle_end = requestBytes.position() + toBeSent;
                        }
                    }
                }
                while (requestBytes.position() < throttle_end) {
                    WSStream wsstream;
                    Object object;
                    int datalen = throttle_end - requestBytes.position();
                    if (datalen > WSStream.MAX_DATA_LEN) {
                        datalen = WSStream.MAX_DATA_LEN;
                    }
                    if (req.isAsync() && requestBytes.position() + datalen == requestBytes.limit()) {
                        if (datalen == WSStream.MAX_DATA_LEN) {
                            WSStream wsstream2 = new WSStream(1, tcpchan, datalen, requestBytes);
                            object = this._sendLock;
                            synchronized (object) {
                                remote.sendBinary(wsstream2.getContent(), true);
                            }
                            req.reportDataSent();
                            datalen = 0;
                        }
                        wsstream = new WSStream(9, tcpchan, datalen, requestBytes, req.getAsyncId());
                        object = this._sendLock;
                        synchronized (object) {
                            remote.sendBinary(wsstream.getContent(), true);
                        }
                        req.reportDataSent();
                        continue;
                    }
                    wsstream = new WSStream(1, tcpchan, datalen, requestBytes);
                    object = this._sendLock;
                    synchronized (object) {
                        remote.sendBinary(wsstream.getContent(), true);
                    }
                    req.reportDataSent();
                }
                if (requestBytes.position() < requestBytes.limit()) {
                    int sent = requestBytes.position() - throttle_start;
                    if (sent > 0 && this._uploadRate > 0) {
                        long waitTime = 1000 * sent / this._uploadRate;
                        if (waitTime < 2L) {
                            waitTime = 2L;
                        }
                        this._next_transmit_tm = YAPI.GetTickCount() + waitTime;
                        this.WSLOG(String.format("Sent %dbytes, waiting %dms...", sent, waitTime));
                    } else {
                        this._next_transmit_tm = YAPI.GetTickCount() + 100L;
                    }
                }
                ArrayList<ArrayList<WSRequest>> arrayList2 = this._workingRequests;
                synchronized (arrayList2) {
                    req = requestOfTCPChan.size() > ++reqIndex ? requestOfTCPChan.get(reqIndex) : null;
                }
            }
        }
    }

    private void WSLOG(String s) {
        this._hub._yctx._Log(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAuthenticationMeta() {
        ByteBuffer auth = ByteBuffer.allocate(28);
        auth.order(ByteOrder.LITTLE_ENDIAN);
        auth.put((byte)5);
        if (this._hub._http_params.hasAuthParam()) {
            auth.put((byte)2);
            auth.putShort((short)1);
            auth.putInt(this._nounce);
            byte[] sha1 = this.computeAUTH(this._hub._http_params.getUser(), this._hub._http_params.getPass(), this._remoteSerial, this._remoteNouce);
            auth.put(sha1);
        } else {
            auth.put((byte)2);
            auth.putInt(0);
            for (int i = 0; i < 5; ++i) {
                auth.putInt(0);
            }
        }
        auth.rewind();
        WSStream stream = new WSStream(5, 0, 28, auth);
        RemoteEndpoint.Basic remote = this._session.getBasicRemote();
        try {
            Object object = this._sendLock;
            synchronized (object) {
                remote.sendBinary(stream.getContent(), true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] computeAUTH(String user, String pass, String serial, long noune) {
        String ha1_str = user + ":" + serial + ":" + pass;
        this._md5.reset();
        this._md5.update(ha1_str.getBytes());
        byte[] digest = this._md5.digest();
        String ha1 = YAPIContext._bytesToHexStr(digest, 0, digest.length).toLowerCase();
        String sha1_raw = ha1 + String.format("%02x%02x%02x%02x", noune & 0xFFL, noune >> 8 & 0xFFL, noune >> 16 & 0xFFL, noune >> 24 & 0xFFL);
        this._sha1.reset();
        this._sha1.update(sha1_raw.getBytes());
        return this._sha1.digest();
    }

    private void decodeTCPNotif(String tcpNofif) {
        int pos;
        this._notificationsFifo.append(tcpNofif);
        while ((pos = this._notificationsFifo.indexOf("\n")) >= 0) {
            String line;
            if (pos > 0 && (line = this._notificationsFifo.substring(0, pos + 1)).indexOf(27) == -1) {
                this.handleNetNotification(line);
            }
            this._notificationsFifo.delete(0, pos + 1);
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.errorOnSession(-8, closeReason.getReasonPhrase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOnSession(int errno, String closeReason) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._connectionState == ConnectionState.DEAD) {
                return;
            }
            this._connectionState = ConnectionState.DEAD;
            if (errno != 0) {
                this._session_errno = errno;
                this._session_error = closeReason;
            }
            this._stateLock.notifyAll();
        }
        try {
            this._session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WSRequest fakeRequest = new WSRequest(-8, closeReason);
        try {
            this._pendingRequests.put(fakeRequest);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static enum ConnectionState {
        DEAD,
        DISCONNECTED,
        CONNECTING,
        AUTHENTICATING,
        CONNECTED;

    }
}

