/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import java.util.Locale;

public class YMultiAxisController
extends YFunction {
    public static final int NAXIS_INVALID = -1;
    public static final int GLOBALSTATE_ABSENT = 0;
    public static final int GLOBALSTATE_ALERT = 1;
    public static final int GLOBALSTATE_HI_Z = 2;
    public static final int GLOBALSTATE_STOP = 3;
    public static final int GLOBALSTATE_RUN = 4;
    public static final int GLOBALSTATE_BATCH = 5;
    public static final int GLOBALSTATE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _nAxis = -1;
    protected int _globalState = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackMultiAxisController = null;

    protected YMultiAxisController(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "MultiAxisController";
    }

    protected YMultiAxisController(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("nAxis")) {
            this._nAxis = json_val.getInt("nAxis");
        }
        if (json_val.has("globalState")) {
            this._globalState = json_val.getInt("globalState");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_nAxis() throws YAPI_Exception {
        int res;
        YMultiAxisController yMultiAxisController = this;
        synchronized (yMultiAxisController) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._nAxis;
        }
        return res;
    }

    public int getNAxis() throws YAPI_Exception {
        return this.get_nAxis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_nAxis(int newval) throws YAPI_Exception {
        YMultiAxisController yMultiAxisController = this;
        synchronized (yMultiAxisController) {
            String rest_val = Integer.toString(newval);
            this._setAttr("nAxis", rest_val);
        }
        return 0;
    }

    public int setNAxis(int newval) throws YAPI_Exception {
        return this.set_nAxis(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_globalState() throws YAPI_Exception {
        int res;
        YMultiAxisController yMultiAxisController = this;
        synchronized (yMultiAxisController) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._globalState;
        }
        return res;
    }

    public int getGlobalState() throws YAPI_Exception {
        return this.get_globalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YMultiAxisController yMultiAxisController = this;
        synchronized (yMultiAxisController) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return COMMAND_INVALID;
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YMultiAxisController yMultiAxisController = this;
        synchronized (yMultiAxisController) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMultiAxisController FindMultiAxisController(String func) {
        Class<YAPI> clazz = YAPI.class;
        synchronized (YAPI.class) {
            YMultiAxisController obj = (YMultiAxisController)YFunction._FindFromCache("MultiAxisController", func);
            if (obj == null) {
                obj = new YMultiAxisController(func);
                YFunction._AddToCache("MultiAxisController", func, obj);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMultiAxisController FindMultiAxisControllerInContext(YAPIContext yctx, String func) {
        YMultiAxisController obj;
        YAPIContext yAPIContext = yctx;
        synchronized (yAPIContext) {
            obj = (YMultiAxisController)YFunction._FindFromCacheInContext(yctx, "MultiAxisController", func);
            if (obj == null) {
                obj = new YMultiAxisController(yctx, func);
                YFunction._AddToCache("MultiAxisController", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackMultiAxisController = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackMultiAxisController != null) {
            this._valueCallbackMultiAxisController.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int sendCommand(String command) throws YAPI_Exception {
        String url = String.format(Locale.US, "cmd.txt?X=%s", command);
        byte[] retBin = this._download(url);
        int res = retBin[0] & 0xFF;
        if (res == 49) {
            if (res != 48) {
                throw new YAPI_Exception(-6, "Motor command pipeline is full, try again later");
            }
        } else if (res != 48) {
            throw new YAPI_Exception(-8, "Motor command failed permanently");
        }
        return 0;
    }

    public int reset() throws YAPI_Exception {
        return this.sendCommand("Z");
    }

    public int findHomePosition(ArrayList<Double> speed) throws YAPI_Exception {
        int ndim = speed.size();
        String cmd = String.format(Locale.US, "H%d", (int)((double)Math.round(1000 * speed.get(0).intValue())));
        for (int i = 1; i < ndim; ++i) {
            cmd = String.format(Locale.US, "%s,%d", cmd, (int)((double)Math.round(1000 * speed.get(i).intValue())));
        }
        return this.sendCommand(cmd);
    }

    public int moveTo(ArrayList<Double> absPos) throws YAPI_Exception {
        int ndim = absPos.size();
        String cmd = String.format(Locale.US, "M%d", (int)((double)Math.round(16 * absPos.get(0).intValue())));
        for (int i = 1; i < ndim; ++i) {
            cmd = String.format(Locale.US, "%s,%d", cmd, (int)((double)Math.round(16 * absPos.get(i).intValue())));
        }
        return this.sendCommand(cmd);
    }

    public int moveRel(ArrayList<Double> relPos) throws YAPI_Exception {
        int ndim = relPos.size();
        String cmd = String.format(Locale.US, "m%d", (int)((double)Math.round(16 * relPos.get(0).intValue())));
        for (int i = 1; i < ndim; ++i) {
            cmd = String.format(Locale.US, "%s,%d", cmd, (int)((double)Math.round(16 * relPos.get(i).intValue())));
        }
        return this.sendCommand(cmd);
    }

    public int pause(int waitMs) throws YAPI_Exception {
        return this.sendCommand(String.format(Locale.US, "_%d", waitMs));
    }

    public int emergencyStop() throws YAPI_Exception {
        return this.sendCommand("!");
    }

    public int abortAndBrake() throws YAPI_Exception {
        return this.sendCommand("B");
    }

    public int abortAndHiZ() throws YAPI_Exception {
        return this.sendCommand("z");
    }

    public YMultiAxisController nextMultiAxisController() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YMultiAxisController.FindMultiAxisControllerInContext(this._yapi, next_hwid);
    }

    public static YMultiAxisController FirstMultiAxisController() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("MultiAxisController");
        if (next_hwid == null) {
            return null;
        }
        return YMultiAxisController.FindMultiAxisControllerInContext(yctx, next_hwid);
    }

    public static YMultiAxisController FirstMultiAxisControllerInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("MultiAxisController");
        if (next_hwid == null) {
            return null;
        }
        return YMultiAxisController.FindMultiAxisControllerInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YMultiAxisController var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YMultiAxisController var1, String var2);
    }
}

