/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareUpdate;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONContent;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class YModule
extends YFunction {
    public static final String PRODUCTNAME_INVALID = "!INVALID!";
    public static final String SERIALNUMBER_INVALID = "!INVALID!";
    public static final int PRODUCTID_INVALID = -1;
    public static final int PRODUCTRELEASE_INVALID = -1;
    public static final String FIRMWARERELEASE_INVALID = "!INVALID!";
    public static final int PERSISTENTSETTINGS_LOADED = 0;
    public static final int PERSISTENTSETTINGS_SAVED = 1;
    public static final int PERSISTENTSETTINGS_MODIFIED = 2;
    public static final int PERSISTENTSETTINGS_INVALID = -1;
    public static final int LUMINOSITY_INVALID = -1;
    public static final int BEACON_OFF = 0;
    public static final int BEACON_ON = 1;
    public static final int BEACON_INVALID = -1;
    public static final long UPTIME_INVALID = -9223372036854775807L;
    public static final int USBCURRENT_INVALID = -1;
    public static final int REBOOTCOUNTDOWN_INVALID = Integer.MIN_VALUE;
    public static final int USERVAR_INVALID = Integer.MIN_VALUE;
    protected String _productName = "!INVALID!";
    protected String _serialNumber = "!INVALID!";
    protected int _productId = -1;
    protected int _productRelease = -1;
    protected String _firmwareRelease = "!INVALID!";
    protected int _persistentSettings = -1;
    protected int _luminosity = -1;
    protected int _beacon = -1;
    protected long _upTime = -9223372036854775807L;
    protected int _usbCurrent = -1;
    protected int _rebootCountdown = Integer.MIN_VALUE;
    protected int _userVar = Integer.MIN_VALUE;
    protected UpdateCallback _valueCallbackModule = null;
    protected LogCallback _logCallback = null;

    protected YDevice _getDev() throws YAPI_Exception {
        YDevice dev;
        String devid = this._func;
        int dotidx = devid.indexOf(46);
        if (dotidx >= 0) {
            devid = devid.substring(0, dotidx);
        }
        if ((dev = this._yapi._yHash.getDevice(devid)) == null) {
            throw new YAPI_Exception(-4, "Device [" + devid + "] is not online");
        }
        return dev;
    }

    protected YModule(YAPIContext yctx, String func) {
        super(yctx, func);
        this._className = "Module";
    }

    protected YModule(String func) {
        this(YAPI.GetYCtx(false), func);
    }

    public int functionCount() throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getFunctions().size();
    }

    public String functionId(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        Collection<YPEntry> functions = dev.getFunctions();
        int i = 0;
        for (YPEntry yp : functions) {
            if (i++ != functionIndex) continue;
            return yp.getFuncId();
        }
        this._throw(-2, String.format(Locale.US, "Invalid function index (%d/%d)", functionIndex, functions.size()));
        return "";
    }

    public String functionType(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getClassname();
    }

    public String functionBaseType(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getBaseType();
    }

    public String functionName(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getLogicalName();
    }

    public String functionValue(int functionIndex) throws YAPI_Exception {
        YDevice dev = this._getDev();
        return dev.getYPEntry(functionIndex).getAdvertisedValue();
    }

    public void registerLogCallback(LogCallback callback) {
        this._logCallback = callback;
        YDevice ydev = this._yapi._yHash.getDevice(this._serialNumber);
        if (ydev != null) {
            ydev.registerLogCallback(callback);
        }
    }

    LogCallback get_logCallback() {
        return this._logCallback;
    }

    private byte[] _flattenJsonStruct(byte[] actualSettings) throws YAPI_Exception {
        YJSONObject json = null;
        YJSONArray out = new YJSONArray();
        try {
            json = new YJSONObject(new String(actualSettings, this._yapi._deviceCharset));
            json.parse();
        }
        catch (Exception ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        Set<String> functionList = json.getKeys();
        for (String fun_key : functionList) {
            YJSONObject functionJson;
            if (fun_key.equals("services") || (functionJson = json.getYJSONObject(fun_key)) == null) continue;
            Set<String> attr_keys = functionJson.getKeys();
            for (String attr_key : attr_keys) {
                YJSONContent value = functionJson.get(attr_key);
                if (value == null || value.getJSONType() == YJSONContent.YJSONType.OBJECT) continue;
                String flat_attr = fun_key + "/" + attr_key + "=" + value.toString();
                out.put(flat_attr);
            }
        }
        return out.toJSON().getBytes();
    }

    public ArrayList<String> get_subDevices() throws YAPI_Exception {
        YDevice dev = this._getDev();
        YGenericHub hub = dev.getHub();
        return hub.get_subDeviceOf(this._serialNumber);
    }

    public String get_parentHub() throws YAPI_Exception {
        YDevice dev = this._getDev();
        YGenericHub hub = dev.getHub();
        String hubSerial = hub.getSerialNumber();
        if (hubSerial.equals(this._serialNumber)) {
            return "";
        }
        return hubSerial;
    }

    public String get_url() throws YAPI_Exception {
        YDevice dev = this._getDev();
        YGenericHub hub = dev.getHub();
        return hub.get_urlOf(this._serialNumber);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("productName")) {
            this._productName = json_val.getString("productName");
        }
        if (json_val.has("serialNumber")) {
            this._serialNumber = json_val.getString("serialNumber");
        }
        if (json_val.has("productId")) {
            this._productId = json_val.getInt("productId");
        }
        if (json_val.has("productRelease")) {
            this._productRelease = json_val.getInt("productRelease");
        }
        if (json_val.has("firmwareRelease")) {
            this._firmwareRelease = json_val.getString("firmwareRelease");
        }
        if (json_val.has("persistentSettings")) {
            this._persistentSettings = json_val.getInt("persistentSettings");
        }
        if (json_val.has("luminosity")) {
            this._luminosity = json_val.getInt("luminosity");
        }
        if (json_val.has("beacon")) {
            int n = this._beacon = json_val.getInt("beacon") > 0 ? 1 : 0;
        }
        if (json_val.has("upTime")) {
            this._upTime = json_val.getLong("upTime");
        }
        if (json_val.has("usbCurrent")) {
            this._usbCurrent = json_val.getInt("usbCurrent");
        }
        if (json_val.has("rebootCountdown")) {
            this._rebootCountdown = json_val.getInt("rebootCountdown");
        }
        if (json_val.has("userVar")) {
            this._userVar = json_val.getInt("userVar");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_productName() throws YAPI_Exception {
        String res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration == 0L && this.load(YAPI.DefaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._productName;
        }
        return res;
    }

    public String getProductName() throws YAPI_Exception {
        return this.get_productName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_serialNumber() throws YAPI_Exception {
        String res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration == 0L && this.load(YAPI.DefaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._serialNumber;
        }
        return res;
    }

    public String getSerialNumber() throws YAPI_Exception {
        return this.get_serialNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_productId() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration == 0L && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._productId;
        }
        return res;
    }

    public int getProductId() throws YAPI_Exception {
        return this.get_productId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_productRelease() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._productRelease;
        }
        return res;
    }

    public int getProductRelease() throws YAPI_Exception {
        return this.get_productRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_firmwareRelease() throws YAPI_Exception {
        String res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._firmwareRelease;
        }
        return res;
    }

    public String getFirmwareRelease() throws YAPI_Exception {
        return this.get_firmwareRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_persistentSettings() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._persistentSettings;
        }
        return res;
    }

    public int getPersistentSettings() throws YAPI_Exception {
        return this.get_persistentSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_persistentSettings(int newval) throws YAPI_Exception {
        YModule yModule = this;
        synchronized (yModule) {
            String rest_val = Integer.toString(newval);
            this._setAttr("persistentSettings", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_luminosity() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._luminosity;
        }
        return res;
    }

    public int getLuminosity() throws YAPI_Exception {
        return this.get_luminosity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_luminosity(int newval) throws YAPI_Exception {
        YModule yModule = this;
        synchronized (yModule) {
            String rest_val = Integer.toString(newval);
            this._setAttr("luminosity", rest_val);
        }
        return 0;
    }

    public int setLuminosity(int newval) throws YAPI_Exception {
        return this.set_luminosity(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_beacon() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._beacon;
        }
        return res;
    }

    public int getBeacon() throws YAPI_Exception {
        return this.get_beacon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_beacon(int newval) throws YAPI_Exception {
        YModule yModule = this;
        synchronized (yModule) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("beacon", rest_val);
        }
        return 0;
    }

    public int setBeacon(int newval) throws YAPI_Exception {
        return this.set_beacon(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get_upTime() throws YAPI_Exception {
        long res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -9223372036854775807L;
            }
            res = this._upTime;
        }
        return res;
    }

    public long getUpTime() throws YAPI_Exception {
        return this.get_upTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_usbCurrent() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._usbCurrent;
        }
        return res;
    }

    public int getUsbCurrent() throws YAPI_Exception {
        return this.get_usbCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_rebootCountdown() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return Integer.MIN_VALUE;
            }
            res = this._rebootCountdown;
        }
        return res;
    }

    public int getRebootCountdown() throws YAPI_Exception {
        return this.get_rebootCountdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_rebootCountdown(int newval) throws YAPI_Exception {
        YModule yModule = this;
        synchronized (yModule) {
            String rest_val = Integer.toString(newval);
            this._setAttr("rebootCountdown", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_userVar() throws YAPI_Exception {
        int res;
        YModule yModule = this;
        synchronized (yModule) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return Integer.MIN_VALUE;
            }
            res = this._userVar;
        }
        return res;
    }

    public int getUserVar() throws YAPI_Exception {
        return this.get_userVar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_userVar(int newval) throws YAPI_Exception {
        YModule yModule = this;
        synchronized (yModule) {
            String rest_val = Integer.toString(newval);
            this._setAttr("userVar", rest_val);
        }
        return 0;
    }

    public int setUserVar(int newval) throws YAPI_Exception {
        return this.set_userVar(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YModule FindModule(String func) {
        Class<YAPI> clazz = YAPI.class;
        synchronized (YAPI.class) {
            YModule obj = (YModule)YFunction._FindFromCache("Module", func);
            if (obj == null) {
                obj = new YModule(func);
                YFunction._AddToCache("Module", func, obj);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YModule FindModuleInContext(YAPIContext yctx, String func) {
        YModule obj;
        YAPIContext yAPIContext = yctx;
        synchronized (yAPIContext) {
            obj = (YModule)YFunction._FindFromCacheInContext(yctx, "Module", func);
            if (obj == null) {
                obj = new YModule(yctx, func);
                YFunction._AddToCache("Module", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackModule = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackModule != null) {
            this._valueCallbackModule.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int saveToFlash() throws YAPI_Exception {
        return this.set_persistentSettings(1);
    }

    public int revertFromFlash() throws YAPI_Exception {
        return this.set_persistentSettings(0);
    }

    public int reboot(int secBeforeReboot) throws YAPI_Exception {
        return this.set_rebootCountdown(secBeforeReboot);
    }

    public int triggerFirmwareUpdate(int secBeforeReboot) throws YAPI_Exception {
        return this.set_rebootCountdown(-secBeforeReboot);
    }

    public String checkFirmware(String path, boolean onlynew) throws YAPI_Exception {
        int release = onlynew ? YAPIContext._atoi(this.get_firmwareRelease()) : 0;
        String serial = this.get_serialNumber();
        String tmp_res = YFirmwareUpdate.CheckFirmware(serial, path, release);
        if (tmp_res.indexOf("error:") == 0) {
            this._throw(-2, tmp_res);
        }
        return tmp_res;
    }

    public YFirmwareUpdate updateFirmwareEx(String path, boolean force) throws YAPI_Exception {
        String serial = this.get_serialNumber();
        byte[] settings = this.get_allSettings();
        if (settings.length == 0) {
            this._throw(-8, "Unable to get device settings");
            settings = "error:Unable to get device settings".getBytes();
        }
        return new YFirmwareUpdate(this._yapi, serial, path, settings, force);
    }

    public YFirmwareUpdate updateFirmware(String path) throws YAPI_Exception {
        return this.updateFirmwareEx(path, false);
    }

    public byte[] get_allSettings() throws YAPI_Exception {
        String item;
        ArrayList<Object> filelist = new ArrayList();
        ArrayList<Object> templist = new ArrayList();
        byte[] settings = this._download("api.json");
        if (settings.length == 0) {
            return settings;
        }
        String ext_settings = ", \"extras\":[";
        templist = this.get_functionIds("Temperature");
        String sep = "";
        for (String string : templist) {
            String url;
            String t_type;
            if (YAPIContext._atoi(this.get_firmwareRelease()) <= 9000 || !(t_type = new String(this._download(url = String.format(Locale.US, "api/%s/sensorType", string)))).equals("RES_NTC")) continue;
            String id = string.substring(11, 11 + string.length() - 11);
            byte[] temp_data_bin = this._download(String.format(Locale.US, "extra.json?page=%s", id));
            if (temp_data_bin.length == 0) {
                return temp_data_bin;
            }
            item = String.format(Locale.US, "%s{\"fid\":\"%s\", \"json\":%s}\n", sep, string, new String(temp_data_bin));
            ext_settings = ext_settings + item;
            sep = ",";
        }
        ext_settings = ext_settings + "],\n\"files\":[";
        if (this.hasFunction("files")) {
            byte[] json = this._download("files.json?a=dir&f=");
            if (json.length == 0) {
                return json;
            }
            filelist = this._json_get_array(json);
            sep = "";
            for (String string : filelist) {
                String name = this._json_get_key(string.getBytes(), "name");
                if (name.length() <= 0 || name.equals("startupConf.json")) continue;
                byte[] file_data_bin = this._download(this._escapeAttr(name));
                String file_data = YAPIContext._bytesToHexStr(file_data_bin, 0, file_data_bin.length);
                item = String.format(Locale.US, "%s{\"name\":\"%s\", \"data\":\"%s\"}\n", sep, name, file_data);
                ext_settings = ext_settings + item;
                sep = ",";
            }
        }
        byte[] res = ("{ \"api\":" + new String(settings) + ext_settings + "]}").getBytes();
        return res;
    }

    public int loadThermistorExtra(String funcId, String jsonExtra) throws YAPI_Exception {
        ArrayList<Object> values = new ArrayList();
        String url = "api/" + funcId + ".json?command=Z";
        this._download(url);
        values = this._json_get_array(jsonExtra.getBytes());
        int ofs = 0;
        int size = values.size();
        while (ofs + 1 < size) {
            String curr = (String)values.get(ofs);
            String currTemp = (String)values.get(ofs + 1);
            url = String.format(Locale.US, "api/%s/.json?command=m%s:%s", funcId, curr, currTemp);
            this._download(url);
            ofs += 2;
        }
        return 0;
    }

    public int set_extraSettings(String jsonExtra) throws YAPI_Exception {
        ArrayList<Object> extras = new ArrayList();
        extras = this._json_get_array(jsonExtra.getBytes());
        for (String string : extras) {
            String functionId = this._get_json_path(string, "fid");
            functionId = this._decode_json_string(functionId);
            String data = this._get_json_path(string, "json");
            if (!this.hasFunction(functionId)) continue;
            this.loadThermistorExtra(functionId, data);
        }
        return 0;
    }

    public int set_allSettingsAndFiles(byte[] settings) throws YAPI_Exception {
        String json = new String(settings);
        String json_api = this._get_json_path(json, "api");
        if (json_api.equals("")) {
            return this.set_allSettings(settings);
        }
        String json_extra = this._get_json_path(json, "extras");
        if (!json_extra.equals("")) {
            this.set_extraSettings(json_extra);
        }
        this.set_allSettings(json_api.getBytes());
        if (this.hasFunction("files")) {
            ArrayList<Object> files = new ArrayList();
            byte[] down = this._download("files.json?a=format");
            String res = this._get_json_path(new String(down), "res");
            if (!(res = this._decode_json_string(res)).equals("ok")) {
                throw new YAPI_Exception(-8, "format failed");
            }
            String json_files = this._get_json_path(json, "files");
            files = this._json_get_array(json_files.getBytes());
            for (String string : files) {
                String name = this._get_json_path(string, "name");
                name = this._decode_json_string(name);
                String data = this._get_json_path(string, "data");
                data = this._decode_json_string(data);
                this._upload(name, YAPIContext._hexStrToBin(data));
            }
        }
        return 0;
    }

    public boolean hasFunction(String funcId) throws YAPI_Exception {
        int count = this.functionCount();
        for (int i = 0; i < count; ++i) {
            String fid = this.functionId(i);
            if (!fid.equals(funcId)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> get_functionIds(String funType) throws YAPI_Exception {
        ArrayList<String> res = new ArrayList<String>();
        int count = this.functionCount();
        for (int i = 0; i < count; ++i) {
            String ftype = this.functionType(i);
            if (ftype.equals(funType)) {
                res.add(this.functionId(i));
                continue;
            }
            ftype = this.functionBaseType(i);
            if (!ftype.equals(funType)) continue;
            res.add(this.functionId(i));
        }
        return res;
    }

    public int calibVersion(String cparams) {
        if (cparams.equals("0,")) {
            return 3;
        }
        if (cparams.indexOf(",") >= 0) {
            if (cparams.indexOf(" ") > 0) {
                return 3;
            }
            return 1;
        }
        if (cparams.equals("") || cparams.equals("0")) {
            return 1;
        }
        if (cparams.length() < 2 || cparams.indexOf(".") >= 0) {
            return 0;
        }
        return 2;
    }

    public int calibScale(String unit_name, String sensorType) {
        if (unit_name.equals("g") || unit_name.equals("gauss") || unit_name.equals("W")) {
            return 1000;
        }
        if (unit_name.equals("C")) {
            if (sensorType.equals("")) {
                return 16;
            }
            if (YAPIContext._atoi(sensorType) < 8) {
                return 16;
            }
            return 100;
        }
        if (unit_name.equals("m") || unit_name.equals("deg")) {
            return 10;
        }
        return 1;
    }

    public int calibOffset(String unit_name) {
        if (unit_name.equals("% RH") || unit_name.equals("mbar") || unit_name.equals("lx")) {
            return 0;
        }
        return Short.MAX_VALUE;
    }

    public String calibConvert(String param, String currentFuncValue, String unit_name, String sensorType) {
        int i;
        ArrayList<Object> words = new ArrayList();
        ArrayList<Object> words_str = new ArrayList();
        ArrayList<Double> calibData = new ArrayList<Double>();
        ArrayList<Object> iCalib = new ArrayList();
        int paramVer = this.calibVersion(param);
        int funVer = this.calibVersion(currentFuncValue);
        int funScale = this.calibScale(unit_name, sensorType);
        int funOffset = this.calibOffset(unit_name);
        int paramScale = funScale;
        int paramOffset = funOffset;
        if (funVer < 3) {
            if (funVer == 2) {
                words = YAPIContext._decodeWords(currentFuncValue);
                if ((Integer)words.get(0) == 1366 && (Integer)words.get(1) == 12500) {
                    funScale = 1;
                    funOffset = 0;
                } else {
                    funScale = (Integer)words.get(1);
                    funOffset = (Integer)words.get(0);
                }
            } else if (funVer == 1 && (currentFuncValue.equals("") || YAPIContext._atoi(currentFuncValue) > 10)) {
                funScale = 0;
            }
        }
        calibData.clear();
        int calibType = 0;
        if (paramVer < 3) {
            double ratio;
            int maxSize;
            if (paramVer == 2) {
                words = YAPIContext._decodeWords(param);
                if ((Integer)words.get(0) == 1366 && (Integer)words.get(1) == 12500) {
                    paramScale = 1;
                    paramOffset = 0;
                } else {
                    paramScale = (Integer)words.get(1);
                    paramOffset = (Integer)words.get(0);
                }
                if (words.size() >= 3 && (Integer)words.get(2) > 0) {
                    maxSize = 3 + 2 * ((Integer)words.get(2) % 10);
                    if (maxSize > words.size()) {
                        maxSize = words.size();
                    }
                    for (i = 3; i < maxSize; ++i) {
                        calibData.add(Double.valueOf(((Integer)words.get(i)).intValue()));
                    }
                }
            } else if (paramVer == 1) {
                words_str = new ArrayList<String>(Arrays.asList(param.split(",")));
                for (String string : words_str) {
                    words.add(YAPIContext._atoi(string));
                }
                if (param.equals("") || (Integer)words.get(0) > 10) {
                    paramScale = 0;
                }
                if (words.size() > 0 && (Integer)words.get(0) > 0) {
                    maxSize = 1 + 2 * ((Integer)words.get(0) % 10);
                    if (maxSize > words.size()) {
                        maxSize = words.size();
                    }
                    for (i = 1; i < maxSize; ++i) {
                        calibData.add(Double.valueOf(((Integer)words.get(i)).intValue()));
                    }
                }
            } else if (paramVer == 0 && (ratio = Double.valueOf(param).doubleValue()) > 0.0) {
                calibData.add(0.0);
                calibData.add(0.0);
                calibData.add(Double.valueOf(Math.round(65535.0 / ratio)));
                calibData.add(65535.0);
            }
            for (i = 0; i < calibData.size(); ++i) {
                if (paramScale > 0) {
                    calibData.set(i, ((Double)calibData.get(i) - (double)paramOffset) / (double)paramScale);
                    continue;
                }
                calibData.set(i, YAPIContext._decimalToDouble((int)Math.round((Double)calibData.get(i))));
            }
        } else {
            iCalib = YAPIContext._decodeFloats(param);
            calibType = (int)Math.round(((Integer)iCalib.get(0)).doubleValue() / 1000.0);
            if (calibType >= 30) {
                calibType -= 30;
            }
            for (i = 1; i < iCalib.size(); ++i) {
                calibData.add(((Integer)iCalib.get(i)).doubleValue() / 1000.0);
            }
        }
        if (funVer >= 3) {
            if (calibData.size() == 0) {
                param = "0,";
            } else {
                param = Integer.toString(30 + calibType);
                for (i = 0; i < calibData.size(); ++i) {
                    param = (i & 1) > 0 ? param + ":" : param + " ";
                    param = param + Integer.toString((int)Math.round((Double)calibData.get(i) * 1000.0 / 1000.0));
                }
                param = param + ",";
            }
        } else if (funVer >= 1) {
            int nPoints = calibData.size() / 2;
            param = Integer.toString(nPoints);
            for (i = 0; i < 2 * nPoints; ++i) {
                double wordVal = funScale == 0 ? (double)YAPIContext._doubleToDecimal((int)Math.round((Double)calibData.get(i))) : (Double)calibData.get(i) * (double)funScale + (double)funOffset;
                param = param + "," + Double.toString(Math.round(wordVal));
            }
        } else if (calibData.size() == 4) {
            param = Double.toString(Math.round(1000.0 * ((Double)calibData.get(3) - (Double)calibData.get(1)) / (Double)calibData.get(2) - (Double)calibData.get(0)));
        }
        return param;
    }

    public int set_allSettings(byte[] settings) throws YAPI_Exception {
        String value;
        String jpath;
        int eqpos;
        int leng;
        String each_str;
        ArrayList<String> restoreLast = new ArrayList<String>();
        ArrayList<Object> old_dslist = new ArrayList();
        ArrayList<String> old_jpath = new ArrayList<String>();
        ArrayList<Integer> old_jpath_len = new ArrayList<Integer>();
        ArrayList<String> old_val_arr = new ArrayList<String>();
        ArrayList<Object> new_dslist = new ArrayList();
        ArrayList<String> new_jpath = new ArrayList<String>();
        ArrayList<Integer> new_jpath_len = new ArrayList<Integer>();
        ArrayList<String> new_val_arr = new ArrayList<String>();
        String tmp = new String(settings);
        if (!(tmp = this._get_json_path(tmp, "api")).equals("")) {
            settings = tmp.getBytes();
        }
        String oldval = "";
        String newval = "";
        byte[] old_json_flat = this._flattenJsonStruct(settings);
        old_dslist = this._json_get_array(old_json_flat);
        for (String string : old_dslist) {
            each_str = this._json_get_string(string.getBytes());
            leng = each_str.length();
            eqpos = each_str.indexOf("=");
            if (eqpos < 0 || leng == 0) {
                this._throw(-2, "Invalid settings");
                return -2;
            }
            jpath = each_str.substring(0, eqpos);
            value = each_str.substring(++eqpos, eqpos + leng - eqpos);
            old_jpath.add(jpath);
            old_jpath_len.add(jpath.length());
            old_val_arr.add(value);
        }
        byte[] actualSettings = this._download("api.json");
        actualSettings = this._flattenJsonStruct(actualSettings);
        new_dslist = this._json_get_array(actualSettings);
        for (String string : new_dslist) {
            each_str = this._json_get_string(string.getBytes());
            leng = each_str.length();
            eqpos = each_str.indexOf("=");
            if (eqpos < 0 || leng == 0) {
                this._throw(-2, "Invalid settings");
                return -2;
            }
            jpath = each_str.substring(0, eqpos);
            value = each_str.substring(++eqpos, eqpos + leng - eqpos);
            new_jpath.add(jpath);
            new_jpath_len.add(jpath.length());
            new_val_arr.add(value);
        }
        int i = 0;
        while (i < new_jpath.size()) {
            int j;
            boolean found;
            String njpath = (String)new_jpath.get(i);
            leng = njpath.length();
            int cpos = njpath.indexOf("/");
            if (cpos < 0 || leng == 0) continue;
            String fun = njpath.substring(0, cpos);
            String attr = njpath.substring(++cpos, cpos + leng - cpos);
            boolean do_update = true;
            if (fun.equals("services")) {
                do_update = false;
            }
            if (do_update && attr.equals("firmwareRelease")) {
                do_update = false;
            }
            if (do_update && attr.equals("usbCurrent")) {
                do_update = false;
            }
            if (do_update && attr.equals("upTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("persistentSettings")) {
                do_update = false;
            }
            if (do_update && attr.equals("adminPassword")) {
                do_update = false;
            }
            if (do_update && attr.equals("userPassword")) {
                do_update = false;
            }
            if (do_update && attr.equals("rebootCountdown")) {
                do_update = false;
            }
            if (do_update && attr.equals("advertisedValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("poeCurrent")) {
                do_update = false;
            }
            if (do_update && attr.equals("readiness")) {
                do_update = false;
            }
            if (do_update && attr.equals("ipAddress")) {
                do_update = false;
            }
            if (do_update && attr.equals("subnetMask")) {
                do_update = false;
            }
            if (do_update && attr.equals("router")) {
                do_update = false;
            }
            if (do_update && attr.equals("linkQuality")) {
                do_update = false;
            }
            if (do_update && attr.equals("ssid")) {
                do_update = false;
            }
            if (do_update && attr.equals("channel")) {
                do_update = false;
            }
            if (do_update && attr.equals("security")) {
                do_update = false;
            }
            if (do_update && attr.equals("message")) {
                do_update = false;
            }
            if (do_update && attr.equals("currentValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("currentRawValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("currentRunIndex")) {
                do_update = false;
            }
            if (do_update && attr.equals("pulseTimer")) {
                do_update = false;
            }
            if (do_update && attr.equals("lastTimePressed")) {
                do_update = false;
            }
            if (do_update && attr.equals("lastTimeReleased")) {
                do_update = false;
            }
            if (do_update && attr.equals("filesCount")) {
                do_update = false;
            }
            if (do_update && attr.equals("freeSpace")) {
                do_update = false;
            }
            if (do_update && attr.equals("timeUTC")) {
                do_update = false;
            }
            if (do_update && attr.equals("rtcTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("unixTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("dateTime")) {
                do_update = false;
            }
            if (do_update && attr.equals("rawValue")) {
                do_update = false;
            }
            if (do_update && attr.equals("lastMsg")) {
                do_update = false;
            }
            if (do_update && attr.equals("delayedPulseTimer")) {
                do_update = false;
            }
            if (do_update && attr.equals("rxCount")) {
                do_update = false;
            }
            if (do_update && attr.equals("txCount")) {
                do_update = false;
            }
            if (do_update && attr.equals("msgCount")) {
                do_update = false;
            }
            if (do_update) {
                do_update = false;
                newval = (String)new_val_arr.get(i);
                found = false;
                for (j = 0; j < old_jpath.size() && !found; ++j) {
                    if (((Integer)new_jpath_len.get(i)).intValue() != ((Integer)old_jpath_len.get(j)).intValue() || !((String)new_jpath.get(i)).equals(old_jpath.get(j))) continue;
                    found = true;
                    oldval = (String)old_val_arr.get(j);
                    if (newval.equals(oldval)) continue;
                    do_update = true;
                }
            }
            if (do_update) {
                String url;
                if (attr.equals("calibrationParam")) {
                    String old_calib = "";
                    String unit_name = "";
                    String sensorType = "";
                    String new_calib = newval;
                    found = false;
                    for (j = 0; j < old_jpath.size() && !found; ++j) {
                        if (((Integer)new_jpath_len.get(i)).intValue() != ((Integer)old_jpath_len.get(j)).intValue() || !((String)new_jpath.get(i)).equals(old_jpath.get(j))) continue;
                        found = true;
                        old_calib = (String)old_val_arr.get(j);
                    }
                    tmp = fun + "/unit";
                    found = false;
                    for (j = 0; j < new_jpath.size() && !found; ++j) {
                        if (!tmp.equals(new_jpath.get(j))) continue;
                        found = true;
                        unit_name = (String)new_val_arr.get(j);
                    }
                    tmp = fun + "/sensorType";
                    found = false;
                    for (j = 0; j < new_jpath.size() && !found; ++j) {
                        if (!tmp.equals(new_jpath.get(j))) continue;
                        found = true;
                        sensorType = (String)new_val_arr.get(j);
                    }
                    newval = this.calibConvert(old_calib, (String)new_val_arr.get(i), unit_name, sensorType);
                    url = "api/" + fun + ".json?" + attr + "=" + this._escapeAttr(newval);
                    this._download(url);
                } else {
                    url = "api/" + fun + ".json?" + attr + "=" + this._escapeAttr(oldval);
                    if (attr.equals("resolution")) {
                        restoreLast.add(url);
                    } else {
                        this._download(url);
                    }
                }
            }
            ++i;
        }
        for (String string : restoreLast) {
            this._download(string);
        }
        this.clearCache();
        return 0;
    }

    public byte[] download(String pathname) throws YAPI_Exception {
        return this._download(pathname);
    }

    public byte[] get_icon2d() throws YAPI_Exception {
        return this._download("icon2d.png");
    }

    public String get_lastLogs() throws YAPI_Exception {
        byte[] content = this._download("logs.txt");
        return new String(content);
    }

    public int log(String text) throws YAPI_Exception {
        return this._upload("logs.txt", text.getBytes());
    }

    public YModule nextModule() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YModule.FindModuleInContext(this._yapi, next_hwid);
    }

    public static YModule FirstModule() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Module");
        if (next_hwid == null) {
            return null;
        }
        return YModule.FindModuleInContext(yctx, next_hwid);
    }

    public static YModule FirstModuleInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Module");
        if (next_hwid == null) {
            return null;
        }
        return YModule.FindModuleInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YModule var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YModule var1, String var2);
    }

    public static interface LogCallback {
        public void logCallback(YModule var1, String var2);
    }
}

