/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YJSONContent;

class YJSONNumber
extends YJSONContent {
    private long _intValue = 0L;
    private double _doubleValue = 0.0;
    private boolean _isFloat = false;

    YJSONNumber(String data, int start, int stop) {
        super(data, start, stop, YJSONContent.YJSONType.NUMBER);
    }

    @Override
    int parse() throws Exception {
        boolean neg = false;
        int cur_pos = YJSONNumber.SkipGarbage(this._data, this._data_start, this._data_boundary);
        if (this._data == null) {
            throw new Exception("no data");
        }
        char sti = this._data.charAt(cur_pos);
        if (sti == '-') {
            neg = true;
            ++cur_pos;
        }
        int start = cur_pos;
        while (cur_pos < this._data_boundary) {
            sti = this._data.charAt(cur_pos);
            if (sti == '.' && !this._isFloat) {
                String int_part = this._data.substring(start, cur_pos);
                this._intValue = Long.valueOf(int_part);
                this._isFloat = true;
            } else if (sti < '0' || sti > '9') {
                String numberpart = this._data.substring(start, cur_pos);
                if (this._isFloat) {
                    this._doubleValue = Double.valueOf(numberpart);
                } else {
                    this._intValue = Long.valueOf(numberpart);
                }
                if (neg) {
                    this._doubleValue = 0.0 - this._doubleValue;
                    this._intValue = 0L - this._intValue;
                }
                return cur_pos - this._data_start;
            }
            ++cur_pos;
        }
        throw new Exception(this.formatError("unexpected end of data", cur_pos));
    }

    @Override
    String toJSON() {
        if (this._isFloat) {
            return Double.toString(this._doubleValue);
        }
        return Long.toString(this._intValue);
    }

    long getLong() {
        if (this._isFloat) {
            return (long)this._doubleValue;
        }
        return this._intValue;
    }

    int getInt() {
        if (this._isFloat) {
            return (int)this._doubleValue;
        }
        return (int)this._intValue;
    }

    double getDouble() {
        if (this._isFloat) {
            return this._doubleValue;
        }
        return this._intValue;
    }

    public String toString() {
        if (this._isFloat) {
            return Double.toString(this._doubleValue);
        }
        return Long.toString(this._intValue);
    }
}

