/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;

class YDevice {
    private YGenericHub _hub;
    private final WPEntry _wpRec;
    private final HashMap<Integer, YPEntry> _ypRecs;
    private long _cache_expiration;
    private YJSONObject _cache_json;
    private double _deviceTime;
    private YPEntry _moduleYPEntry;
    private YModule.LogCallback _logCallback = null;
    private int _logpos = 0;
    private boolean _logIsPulling = false;
    private YGenericHub.RequestAsyncResult _logCallbackHandler = new YGenericHub.RequestAsyncResult(){

        @Override
        public void RequestAsyncDone(Object context, byte[] result, int error, String errmsg) {
            String[] lines;
            if (result == null) {
                YDevice.this._logIsPulling = false;
                return;
            }
            if (YDevice.this._logCallback == null) {
                YDevice.this._logIsPulling = false;
                return;
            }
            String resultStr = new String(result);
            int pos = resultStr.lastIndexOf("@");
            if (pos < 0) {
                YDevice.this._logIsPulling = false;
                return;
            }
            String logs = resultStr.substring(0, pos);
            String posStr = resultStr.substring(pos + 1);
            YDevice.this._logpos = Integer.valueOf(posStr);
            YModule module = YModule.FindModuleInContext(((YDevice)YDevice.this)._hub._yctx, YDevice.this.getSerialNumber());
            for (String line : lines = logs.split("\n")) {
                YDevice.this._logCallback.logCallback(module, line);
            }
            YDevice.this._logIsPulling = false;
        }
    };

    YDevice(YGenericHub hub, WPEntry wpRec, HashMap<String, ArrayList<YPEntry>> ypRecs) {
        this._hub = hub;
        this._wpRec = wpRec;
        this._cache_expiration = 0L;
        this._cache_json = null;
        this._moduleYPEntry = new YPEntry(wpRec.getSerialNumber(), "module", YPEntry.BaseClass.Function);
        this._moduleYPEntry.setLogicalName(wpRec.getLogicalName());
        this._ypRecs = new HashMap();
        Set<String> keySet = ypRecs.keySet();
        for (String categ : keySet) {
            for (YPEntry rec : ypRecs.get(categ)) {
                if (!rec.getSerial().equals(wpRec.getSerialNumber())) continue;
                int funydx = rec.getIndex();
                this._ypRecs.put(funydx, rec);
            }
        }
    }

    YGenericHub getHub() {
        return this._hub;
    }

    String getNetworkUrl() {
        return this._wpRec.getNetworkUrl();
    }

    String getSerialNumber() {
        return this._wpRec.getSerialNumber();
    }

    String getLogicalName() {
        return this._wpRec.getLogicalName();
    }

    int getBeacon() {
        return this._wpRec.getBeacon();
    }

    synchronized YJSONObject requestAPI() throws YAPI_Exception {
        YJSONObject cache_json;
        long tickCount = YAPI.GetTickCount();
        if (this._cache_expiration > tickCount) {
            return this._cache_json;
        }
        String request = "GET /api.json";
        if (this._cache_json != null) {
            request = request + "?fw=" + this._cache_json.getYJSONObject("module").getString("firmwareRelease");
        }
        String yreq = this.requestHTTPSyncAsString(request, null);
        try {
            cache_json = new YJSONObject(yreq);
            cache_json.parseWithRef(this._cache_json);
        }
        catch (Exception ex) {
            this._cache_json = null;
            throw new YAPI_Exception(-8, "Request failed, could not parse API result for " + this);
        }
        this._cache_expiration = YAPI.GetTickCount() + (long)YAPI.DefaultCacheValidity;
        this._cache_json = cache_json;
        return cache_json;
    }

    synchronized void refresh() throws YAPI_Exception {
        YJSONObject loadval = this.requestAPI();
        Boolean reindex = false;
        try {
            Set<String> keys = loadval.getKeys();
            block2: for (String key : keys) {
                if (key.equals("module")) {
                    YJSONObject module = loadval.getYJSONObject("module");
                    if (!this._wpRec.getLogicalName().equals(module.getString("logicalName"))) {
                        this._wpRec.setLogicalName(module.getString("logicalName"));
                        this._moduleYPEntry.setLogicalName(this._wpRec.getLogicalName());
                        reindex = true;
                    }
                    this._wpRec.setBeacon(module.getInt("beacon"));
                    continue;
                }
                if (key.equals("services")) continue;
                YJSONObject func = loadval.getYJSONObject(key);
                String name = func.has("logicalName") ? func.getString("logicalName") : this._wpRec.getLogicalName();
                if (func.has("advertisedValue")) {
                    String pubval = func.getString("advertisedValue");
                    this._hub._yctx._yHash.setFunctionValue(this._wpRec.getSerialNumber() + "." + key, pubval);
                }
                for (int f = 0; f < this._ypRecs.size(); ++f) {
                    if (!this._ypRecs.get(f).getFuncId().equals(key)) continue;
                    if (this._ypRecs.get(f).getLogicalName().equals(name)) continue block2;
                    this._ypRecs.get(f).setLogicalName(name);
                    reindex = true;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new YAPI_Exception(-8, "Request failed, could not parse API result");
        }
        if (reindex.booleanValue()) {
            this._hub._yctx._yHash.reindexDevice(this);
        }
    }

    synchronized void clearCache() {
        this._cache_expiration = 0L;
    }

    Collection<YPEntry> getFunctions() {
        return this._ypRecs.values();
    }

    YPEntry getYPEntry(int idx) {
        return this._ypRecs.get(idx);
    }

    synchronized byte[] requestHTTPSync(String request, byte[] rest_of_request) throws YAPI_Exception {
        String shortRequest = this.formatRequest(request);
        try {
            return this._hub.devRequestSync(this, shortRequest, rest_of_request, null, null);
        }
        catch (InterruptedException e) {
            throw new YAPI_Exception(-8, "Thread has been interrupted");
        }
    }

    synchronized String requestHTTPSyncAsString(String request, byte[] rest_of_request) throws YAPI_Exception {
        byte[] bytes = this.requestHTTPSync(request, rest_of_request);
        return new String(bytes, this._hub._yctx._deviceCharset);
    }

    synchronized void requestHTTPAsync(String request, byte[] rest_of_request, YGenericHub.RequestAsyncResult asyncResult, Object context) throws YAPI_Exception {
        String shortRequest = this.formatRequest(request);
        try {
            this._hub.devRequestAsync(this, shortRequest, rest_of_request, asyncResult, context);
        }
        catch (InterruptedException e) {
            throw new YAPI_Exception(-8, "Thread has been interrupted");
        }
    }

    private String formatRequest(String request) throws YAPI_Exception {
        String[] words = request.split(" ");
        if (words.length < 2) {
            throw new YAPI_Exception(-2, "Invalid request, not enough words; expected a method name and a URL");
        }
        String relativeUrl = words[1];
        if (relativeUrl.charAt(0) != '/') {
            relativeUrl = "/" + relativeUrl;
        }
        return String.format("%s %s%s", words[0], this._wpRec.getNetworkUrl(), relativeUrl);
    }

    double getDeviceTime() {
        return this._deviceTime;
    }

    void setDeviceTime(Integer[] data) {
        double time = (data[0] & 0xFF) + 256 * (data[1] & 0xFF) + 65536 * (data[2] & 0xFF) + 0x1000000 * (data[3] & 0xFF);
        this._deviceTime = time + (double)(data[4] & 0xFF) / 250.0;
    }

    YPEntry getModuleYPEntry() {
        return this._moduleYPEntry;
    }

    void triggerLogPull() {
        if (this._logCallback == null || this._logIsPulling) {
            return;
        }
        this._logIsPulling = true;
        String request = "GET logs.txt?pos=" + this._logpos;
        try {
            this.requestHTTPAsync(request, null, this._logCallbackHandler, this._logpos);
        }
        catch (YAPI_Exception ex) {
            this._hub._yctx._Log("LOG error:" + ex.getLocalizedMessage());
        }
    }

    void registerLogCallback(YModule.LogCallback callback) {
        this._logCallback = callback;
        this.triggerLogPull();
    }

    static byte[] formatHTTPUpload(String path, byte[] content) {
        String boundary;
        Random randomGenerator = new Random();
        String mp_header = "Content-Disposition: form-data; name=\"" + path + "\"; filename=\"api\"\r\n" + "Content-Type: application/octet-stream\r\n" + "Content-Transfer-Encoding: binary\r\n\r\n";
        while (mp_header.contains(boundary = String.format("Zz%06xzZ", randomGenerator.nextInt(0x1000000))) && YAPIContext._find_in_bytes(content, boundary.getBytes()) >= 0) {
        }
        String header_start = "Content-Type: multipart/form-data; boundary=" + boundary + "\r\n\r\n--" + boundary + "\r\n" + mp_header;
        String header_stop = "\r\n--" + boundary + "--\r\n";
        byte[] head_body = new byte[header_start.length() + content.length + header_stop.length()];
        int pos = 0;
        int len = header_start.length();
        System.arraycopy(header_start.getBytes(), 0, head_body, pos, len);
        pos += len;
        len = content.length;
        System.arraycopy(content, 0, head_body, pos, len);
        pos += len;
        len = header_stop.length();
        System.arraycopy(header_stop.getBytes(), 0, head_body, pos, len);
        System.arraycopy(header_stop.getBytes(), 0, head_body, pos, len);
        return head_body;
    }

    int requestHTTPUpload(String path, byte[] content) throws YAPI_Exception {
        String request = "POST /upload.html";
        byte[] head_body = YDevice.formatHTTPUpload(path, content);
        this.requestHTTPSync(request, head_body);
        return 0;
    }
}

