/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataSet;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONContent;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YOldDataStream;
import java.util.ArrayList;
import java.util.Locale;

public class YDataLogger
extends YFunction {
    public static final int CURRENTRUNINDEX_INVALID = -1;
    public static final long TIMEUTC_INVALID = -9223372036854775807L;
    public static final int RECORDING_OFF = 0;
    public static final int RECORDING_ON = 1;
    public static final int RECORDING_PENDING = 2;
    public static final int RECORDING_INVALID = -1;
    public static final int AUTOSTART_OFF = 0;
    public static final int AUTOSTART_ON = 1;
    public static final int AUTOSTART_INVALID = -1;
    public static final int BEACONDRIVEN_OFF = 0;
    public static final int BEACONDRIVEN_ON = 1;
    public static final int BEACONDRIVEN_INVALID = -1;
    public static final int CLEARHISTORY_FALSE = 0;
    public static final int CLEARHISTORY_TRUE = 1;
    public static final int CLEARHISTORY_INVALID = -1;
    protected int _currentRunIndex = -1;
    protected long _timeUTC = -9223372036854775807L;
    protected int _recording = -1;
    protected int _autoStart = -1;
    protected int _beaconDriven = -1;
    protected int _clearHistory = -1;
    protected UpdateCallback _valueCallbackDataLogger = null;
    protected String _dataLoggerURL;

    public String getData(Integer runIdx, Integer timeIdx) throws YAPI_Exception {
        String result;
        if (this._dataLoggerURL == null) {
            this._dataLoggerURL = "/logger.json";
        }
        String devid = this.module().get_serialNumber();
        String httpreq = "GET " + this._dataLoggerURL;
        if (timeIdx != null) {
            httpreq = httpreq + String.format(Locale.US, "?run=%d&time=%d", runIdx, timeIdx);
        }
        YDevice dev = this._yapi._yHash.getDevice(devid);
        try {
            result = dev.requestHTTPSyncAsString(httpreq, null);
        }
        catch (YAPI_Exception ex) {
            if (!this._dataLoggerURL.equals("/dataLogger.json")) {
                this._dataLoggerURL = "/dataLogger.json";
                return this.getData(runIdx, timeIdx);
            }
            throw ex;
        }
        return result;
    }

    protected YDataLogger(YAPIContext yctx, String func) {
        super(yctx, func);
        this._className = "DataLogger";
    }

    protected YDataLogger(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    public int get_dataStreams(ArrayList<YDataStream> v) throws YAPI_Exception {
        block7: {
            String loadval = this.getData(null, null);
            try {
                YJSONArray jsonAllStreams = new YJSONArray(loadval);
                jsonAllStreams.parse();
                if (jsonAllStreams.length() == 0) {
                    return 0;
                }
                if (jsonAllStreams.get(0).getJSONType() == YJSONContent.YJSONType.ARRAY) {
                    for (int i = 0; i < jsonAllStreams.length(); ++i) {
                        YJSONArray arr = jsonAllStreams.getYJSONArray(i);
                        YOldDataStream stream = new YOldDataStream(this, arr.getInt(0), arr.getInt(1), arr.getLong(2), arr.getInt(3));
                        v.add(stream);
                    }
                    break block7;
                }
                ArrayList<YDataSet> sets = this.parse_dataSets(jsonAllStreams.toJSON().getBytes());
                for (int j = 0; j < sets.size(); ++j) {
                    ArrayList<YDataStream> ds = sets.get(j).get_privateDataStreams();
                    for (int si = 0; si < ds.size(); ++si) {
                        v.add(ds.get(si));
                    }
                }
                return 0;
            }
            catch (Exception ex) {
                throw new YAPI_Exception(-8, ex.getLocalizedMessage());
            }
        }
        return 0;
    }

    public int getDataStreams(ArrayList<YDataStream> v) throws YAPI_Exception {
        return this.get_dataStreams(v);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("currentRunIndex")) {
            this._currentRunIndex = json_val.getInt("currentRunIndex");
        }
        if (json_val.has("timeUTC")) {
            this._timeUTC = json_val.getLong("timeUTC");
        }
        if (json_val.has("recording")) {
            this._recording = json_val.getInt("recording");
        }
        if (json_val.has("autoStart")) {
            int n = this._autoStart = json_val.getInt("autoStart") > 0 ? 1 : 0;
        }
        if (json_val.has("beaconDriven")) {
            int n = this._beaconDriven = json_val.getInt("beaconDriven") > 0 ? 1 : 0;
        }
        if (json_val.has("clearHistory")) {
            this._clearHistory = json_val.getInt("clearHistory") > 0 ? 1 : 0;
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_currentRunIndex() throws YAPI_Exception {
        int res;
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._currentRunIndex;
        }
        return res;
    }

    public int getCurrentRunIndex() throws YAPI_Exception {
        return this.get_currentRunIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get_timeUTC() throws YAPI_Exception {
        long res;
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -9223372036854775807L;
            }
            res = this._timeUTC;
        }
        return res;
    }

    public long getTimeUTC() throws YAPI_Exception {
        return this.get_timeUTC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_timeUTC(long newval) throws YAPI_Exception {
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            String rest_val = Long.toString(newval);
            this._setAttr("timeUTC", rest_val);
        }
        return 0;
    }

    public int setTimeUTC(long newval) throws YAPI_Exception {
        return this.set_timeUTC(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_recording() throws YAPI_Exception {
        int res;
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._recording;
        }
        return res;
    }

    public int getRecording() throws YAPI_Exception {
        return this.get_recording();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_recording(int newval) throws YAPI_Exception {
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            String rest_val = Integer.toString(newval);
            this._setAttr("recording", rest_val);
        }
        return 0;
    }

    public int setRecording(int newval) throws YAPI_Exception {
        return this.set_recording(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_autoStart() throws YAPI_Exception {
        int res;
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._autoStart;
        }
        return res;
    }

    public int getAutoStart() throws YAPI_Exception {
        return this.get_autoStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_autoStart(int newval) throws YAPI_Exception {
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("autoStart", rest_val);
        }
        return 0;
    }

    public int setAutoStart(int newval) throws YAPI_Exception {
        return this.set_autoStart(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_beaconDriven() throws YAPI_Exception {
        int res;
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._beaconDriven;
        }
        return res;
    }

    public int getBeaconDriven() throws YAPI_Exception {
        return this.get_beaconDriven();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_beaconDriven(int newval) throws YAPI_Exception {
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("beaconDriven", rest_val);
        }
        return 0;
    }

    public int setBeaconDriven(int newval) throws YAPI_Exception {
        return this.set_beaconDriven(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_clearHistory() throws YAPI_Exception {
        int res;
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(YAPI.DefaultCacheValidity) != 0) {
                return -1;
            }
            res = this._clearHistory;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_clearHistory(int newval) throws YAPI_Exception {
        YDataLogger yDataLogger = this;
        synchronized (yDataLogger) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("clearHistory", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YDataLogger FindDataLogger(String func) {
        Class<YAPI> clazz = YAPI.class;
        synchronized (YAPI.class) {
            YDataLogger obj = (YDataLogger)YFunction._FindFromCache("DataLogger", func);
            if (obj == null) {
                obj = new YDataLogger(func);
                YFunction._AddToCache("DataLogger", func, obj);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YDataLogger FindDataLoggerInContext(YAPIContext yctx, String func) {
        YDataLogger obj;
        YAPIContext yAPIContext = yctx;
        synchronized (yAPIContext) {
            obj = (YDataLogger)YFunction._FindFromCacheInContext(yctx, "DataLogger", func);
            if (obj == null) {
                obj = new YDataLogger(yctx, func);
                YFunction._AddToCache("DataLogger", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackDataLogger = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackDataLogger != null) {
            this._valueCallbackDataLogger.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int forgetAllDataStreams() throws YAPI_Exception {
        return this.set_clearHistory(1);
    }

    public ArrayList<YDataSet> get_dataSets() throws YAPI_Exception {
        return this.parse_dataSets(this._download("logger.json"));
    }

    public ArrayList<YDataSet> parse_dataSets(byte[] json) throws YAPI_Exception {
        ArrayList<Object> dslist = new ArrayList();
        ArrayList<YDataSet> res = new ArrayList<YDataSet>();
        dslist = this._json_get_array(json);
        res.clear();
        for (String string : dslist) {
            YDataSet dataset = new YDataSet(this);
            dataset._parse(string);
            res.add(dataset);
        }
        return res;
    }

    public YDataLogger nextDataLogger() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLoggerInContext(this._yapi, next_hwid);
    }

    public static YDataLogger FirstDataLogger() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("DataLogger");
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLoggerInContext(yctx, next_hwid);
    }

    public static YDataLogger FirstDataLoggerInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("DataLogger");
        if (next_hwid == null) {
            return null;
        }
        return YDataLogger.FindDataLoggerInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YDataLogger var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YDataLogger var1, String var2);
    }
}

