/*
 * Decompiled with CFR 0.152.
 */
package com.getpebble.android.kit.util;

import android.util.Base64;
import com.getpebble.android.kit.util.PebbleTuple;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PebbleDictionary
implements Iterable<PebbleTuple> {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String LENGTH = "length";
    private static final String VALUE = "value";
    protected final Map<Integer, PebbleTuple> tuples = new HashMap<Integer, PebbleTuple>();

    @Override
    public Iterator<PebbleTuple> iterator() {
        return this.tuples.values().iterator();
    }

    public int size() {
        return this.tuples.size();
    }

    public boolean contains(int key) {
        return this.tuples.containsKey(key);
    }

    public void remove(int key) {
        this.tuples.remove(key);
    }

    public void addBytes(int key, byte[] bytes) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.BYTES, PebbleTuple.Width.NONE, bytes);
        this.addTuple(t);
    }

    public void addString(int key, String value) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.STRING, PebbleTuple.Width.NONE, value);
        this.addTuple(t);
    }

    public void addInt8(int key, byte b) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.INT, PebbleTuple.Width.BYTE, b);
        this.addTuple(t);
    }

    public void addUint8(int key, byte b) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.UINT, PebbleTuple.Width.BYTE, b);
        this.addTuple(t);
    }

    public void addInt16(int key, short s) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.INT, PebbleTuple.Width.SHORT, s);
        this.addTuple(t);
    }

    public void addUint16(int key, short s) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.UINT, PebbleTuple.Width.SHORT, s);
        this.addTuple(t);
    }

    public void addInt32(int key, int i) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.INT, PebbleTuple.Width.WORD, i);
        this.addTuple(t);
    }

    public void addUint32(int key, int i) {
        PebbleTuple t = PebbleTuple.create(key, PebbleTuple.TupleType.UINT, PebbleTuple.Width.WORD, i);
        this.addTuple(t);
    }

    private PebbleTuple getTuple(int key, PebbleTuple.TupleType type) {
        if (!this.tuples.containsKey(key) || this.tuples.get(key) == null) {
            return null;
        }
        PebbleTuple t = this.tuples.get(key);
        if (t.type != type) {
            throw new PebbleDictTypeException(key, type, t.type);
        }
        return t;
    }

    public Long getInteger(int key) {
        PebbleTuple tuple = this.getTuple(key, PebbleTuple.TupleType.INT);
        if (tuple == null) {
            return null;
        }
        return (Long)tuple.value;
    }

    public Long getUnsignedInteger(int key) {
        PebbleTuple tuple = this.getTuple(key, PebbleTuple.TupleType.UINT);
        if (tuple == null) {
            return null;
        }
        return (Long)tuple.value;
    }

    public byte[] getBytes(int key) {
        PebbleTuple tuple = this.getTuple(key, PebbleTuple.TupleType.BYTES);
        if (tuple == null) {
            return null;
        }
        return (byte[])tuple.value;
    }

    public String getString(int key) {
        PebbleTuple tuple = this.getTuple(key, PebbleTuple.TupleType.STRING);
        if (tuple == null) {
            return null;
        }
        return (String)tuple.value;
    }

    protected void addTuple(PebbleTuple tuple) {
        if (this.tuples.size() > 255) {
            throw new TupleOverflowException();
        }
        this.tuples.put(tuple.key, tuple);
    }

    public String toJsonString() {
        try {
            JSONArray array = new JSONArray();
            for (PebbleTuple t : this.tuples.values()) {
                array.put((Object)PebbleDictionary.serializeTuple(t));
            }
            return array.toString();
        }
        catch (JSONException je) {
            je.printStackTrace();
            return null;
        }
    }

    public static PebbleDictionary fromJson(String jsonString) throws JSONException {
        PebbleDictionary d = new PebbleDictionary();
        JSONArray elements = new JSONArray(jsonString);
        int idx = 0;
        while (idx < elements.length()) {
            JSONObject o = elements.getJSONObject(idx);
            int key = o.getInt(KEY);
            PebbleTuple.TupleType type = PebbleTuple.TYPE_NAMES.get(o.getString(TYPE));
            PebbleTuple.Width width = PebbleTuple.WIDTH_MAP.get(o.getInt(LENGTH));
            switch (type) {
                case BYTES: {
                    byte[] bytes = Base64.decode((String)o.getString(VALUE), (int)2);
                    d.addBytes(key, bytes);
                    break;
                }
                case STRING: {
                    d.addString(key, o.getString(VALUE));
                    break;
                }
                case INT: {
                    if (width == PebbleTuple.Width.BYTE) {
                        d.addInt8(key, (byte)o.getInt(VALUE));
                        break;
                    }
                    if (width == PebbleTuple.Width.SHORT) {
                        d.addInt16(key, (short)o.getInt(VALUE));
                        break;
                    }
                    if (width != PebbleTuple.Width.WORD) break;
                    d.addInt32(key, o.getInt(VALUE));
                    break;
                }
                case UINT: {
                    if (width == PebbleTuple.Width.BYTE) {
                        d.addUint8(key, (byte)o.getInt(VALUE));
                        break;
                    }
                    if (width == PebbleTuple.Width.SHORT) {
                        d.addUint16(key, (short)o.getInt(VALUE));
                        break;
                    }
                    if (width != PebbleTuple.Width.WORD) break;
                    d.addUint32(key, o.getInt(VALUE));
                }
            }
            ++idx;
        }
        return d;
    }

    private static JSONObject serializeTuple(PebbleTuple t) throws JSONException {
        JSONObject j = new JSONObject();
        j.put(KEY, t.key);
        j.put(TYPE, (Object)t.type.getName());
        j.put(LENGTH, t.width.value);
        switch (t.type) {
            case BYTES: {
                j.put(VALUE, (Object)Base64.encodeToString((byte[])((byte[])t.value), (int)2));
                break;
            }
            case STRING: 
            case UINT: 
            case INT: {
                j.put(VALUE, t.value);
            }
        }
        return j;
    }

    public static class PebbleDictTypeException
    extends RuntimeException {
        public PebbleDictTypeException(long key, PebbleTuple.TupleType expected, PebbleTuple.TupleType actual) {
            super(String.format("Expected type '%s', but got '%s' for key 0x%08x", expected.name(), actual.name(), key));
        }
    }

    public static class TupleOverflowException
    extends RuntimeException {
        public TupleOverflowException() {
            super("Too many tuples in dict");
        }
    }
}

