/*
 * Decompiled with CFR 0.152.
 */
package com.getpebble.android.kit.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

final class PebbleTuple {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    static final Map<String, TupleType> TYPE_NAMES = new HashMap<String, TupleType>();
    static final Map<Integer, Width> WIDTH_MAP;
    public final int key;
    public final TupleType type;
    public final Width width;
    public final int length;
    public final Object value;

    static {
        Enum[] enumArray = TupleType.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            TupleType t = enumArray[n2];
            TYPE_NAMES.put(t.getName(), t);
            ++n2;
        }
        WIDTH_MAP = new HashMap<Integer, Width>();
        enumArray = Width.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum w = enumArray[n2];
            WIDTH_MAP.put(((Width)w).value, (Width)w);
            ++n2;
        }
    }

    private PebbleTuple(int key, TupleType type, Width width, int length, Object value) {
        this.key = key;
        this.type = type;
        this.width = width;
        this.length = length;
        this.value = value;
    }

    static PebbleTuple create(int key, TupleType type, Width width, int value) {
        return new PebbleTuple(key, type, width, width.value, value);
    }

    static PebbleTuple create(int key, TupleType type, Width width, Object value) {
        int length = Integer.MAX_VALUE;
        if (width != Width.NONE) {
            length = width.value;
        } else if (type == TupleType.BYTES) {
            length = ((byte[])value).length;
        } else if (type == TupleType.STRING) {
            length = ((String)value).getBytes(UTF8).length;
        }
        if (length > 65535) {
            throw new ValueOverflowException();
        }
        return new PebbleTuple(key, type, width, length, value);
    }

    static enum TupleType {
        BYTES(0),
        STRING(1),
        UINT(2),
        INT(3);

        public final byte ord;

        private TupleType(int ord) {
            this.ord = (byte)ord;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }

    public static class ValueOverflowException
    extends RuntimeException {
        public ValueOverflowException() {
            super("Value exceeds tuple capacity");
        }
    }

    static enum Width {
        NONE(0),
        BYTE(1),
        SHORT(2),
        WORD(4);

        public final int value;

        private Width(int width) {
            this.value = width;
        }
    }
}

