#include <iostream>
#include <math.h>
#include <string>       
#include <iostream>     
#include <sstream>  
#include <iomanip>
#include "yocto_api.h"
#include "yocto_anbutton.h"
#include "yocto_motor.h"
#include "yocto_servo.h"
#include "yocto_current.h"
#include "yocto_voltage.h"
#include "yocto_temperature.h"
#include "yocto_display.h"

                                          
#define   MOTORCONTROL_SERIAL  "MOTORCTL-24CD4"
#define   SERVOCONTROL_SERIAL  "SERVORC1-206F2"
#define   DISPLAY_SERIAL       "YD128X64-12EE3"
#define   CX   64
#define   CY   80
#define   R    80
#define MMCORP 0
#define YOCTOLAND 1
#define PI 3.14159265359
#define NETWORKNAME YOCTOLAND


#elif NETWORKNAME YOCTOLAND
#define EMITTERIP    "192.168.1.65"
#define YOCTOCARIP   "192.168.1.62"
#endif


using namespace std;


static YMotor*       carPower;
static YServo*       carDirection;
static YVoltage*     carVoltage;
static YCurrent*     carCurrent;
static YTemperature* carTemperature;
static YAnButton*    power1;
static YAnButton*    resetBtn;
static YDisplay*     display;
static YAnButton*    direction1;
static int  maxamp;
static double     maxt;
static double carLastTemperature;
static double carLastVoltage;
static double carLastCurrent;
static int	motorValue,directionValue;
static bool mustSetPower,mustSetDirection,motorAvailable,servoAvailable,displayAvailable;

u64 lastUpdateDeviceList = 0;
u64 lastrefreshDisplay = 0;
u64 lastrefreshMotor = 0;
u64 lastrefreshDirection = 0;

// no proper double to int round function in C++,  unbelievable !
static int  round(double d) 
{ return (int)(d+0.5);
} 

// no proper int/float/string conversion  feature 
// either, I genuinely  hope they will burn in hell for that

static string  inttostr(int i) 
{ stringstream s;
  s << i;
  return s.str();
}

static string  floattostr(double f) 
{ stringstream s;
  s << std::setprecision(3) << f;
  return s.str();
}

static double strtofloat(string s)
{
   return atof(s.c_str());
}

static int strtoint(string s)
{
   return atoi(s.c_str());
}

static void showCarError(YDisplayLayer  *l3,string errmsg)
{  l3->selectColorPen(0);
   l3->drawBar(9,24,119,41);
   l3->selectColorPen(0xffffff);
   l3->drawRect(10,25,118,40);
   l3->drawText(64,32,YDisplayLayer::ALIGN_CENTER,errmsg);
   l3->unhide();
}

static void showCarstatus(YMotor *fct, const string& value)
{
    cout << YAPI::GetTickCount() << ':'<< fct->get_hardwareId() << " : " << value  << endl;
   if (!displayAvailable)  return;
   YDisplayLayer*  l3 = display->get_displayLayer(3);
   l3->clear();
   if (value=="LOVOLT")  showCarError(l3,"LOW VOLTAGE");
   else if (value=="HICURR")  showCarError(l3,"OVERCURRENT");
   else if (value=="HIHEAT")  showCarError(l3,"OVERHEAT");
   else if (value=="FAILSF")  showCarError(l3,"FAILSAFE");
   else l3->hide();
}

static void showCarsvoltage(YVoltage *fct, const string& value)
{   cout << YAPI::GetTickCount() << ':'<< fct->get_hardwareId() << " : " << value  << endl;
    carLastVoltage = strtofloat(value);
}


static void showCarcurrent(YCurrent *fct, const string& value)
{
    cout << YAPI::GetTickCount() << ':'<< fct->get_hardwareId() << " : " << value  << endl;
	  carLastCurrent = strtofloat(value);
}

static void showCarTemperature(YTemperature *fct, const string& value)
{
    cout << YAPI::GetTickCount() << ':'<< fct->get_hardwareId() << " : " << value  << endl;
	  carLastTemperature = strtofloat(value);
}

static void refreshCarPower(int atLeastAfterDelay)
{ 
	u64 now = YAPI::GetTickCount();
	if (now - lastrefreshMotor < atLeastAfterDelay) return;
	if (!motorAvailable) return;
	carPower->set_drivingForce(motorValue / 10);
	lastrefreshMotor=now;
	cout << YAPI::GetTickCount() << ": new motor power "<< endl;
}

static void refreshCarDirection(int atLeastAfterDelay)
{ 
	u64 now = YAPI::GetTickCount();
	if (now - lastrefreshDirection < atLeastAfterDelay) return;
	lastrefreshDirection=now;
    if (!servoAvailable) return;

	carDirection->set_position(directionValue);
	lastrefreshDirection=now;
	
	cout << YAPI::GetTickCount() << ": new car direction "<< endl;
}

static void PowerChange(YAnButton *fct, const string& value)
{
	int v = strtoint(value)+30;
	motorValue = (v * 2 - 1000);
    if (abs(motorValue)<100)  motorValue=0;
	refreshCarPower(80);
   
}

static void directionChange(YAnButton *fct, const string& value)
{
  
	int v = strtoint(value);
    directionValue =  ( v * 2 - 1000) ;
	refreshCarDirection(80);
}

static void resetChange(YAnButton *fct, const string& value)
{
    cout << YAPI::GetTickCount() << ':'<< fct->get_hardwareId() << " : " << value  << endl;
	if ((motorAvailable) && (strtoint(value)>750))    carPower->resetStatus();
}

static double COS(double a){ return  cos( -(3*PI/4) + 2*(PI/4)*(a / 35));}
static double SIN(double a){ return  sin( -(3*PI/4) + 2*(PI/4)*(a / 35));}

static void initDisplay()
{  display->resetAll();
   YDisplayLayer *l0 = display->get_displayLayer(0);
   l0->hide();
   YDisplayLayer *l3 =display->get_displayLayer(3);
   l3->drawText(64,32,YDisplayLayer::ALIGN_CENTER,"Connecting");
   l0->selectFont("Yocto.yfm");
   l0->drawText(64,50,YDisplayLayer::ALIGN_BOTTOM_CENTER,"A");
   l0->drawCircle(CX,CY,R);
   l0->drawCircle(CX,CY,R-5);
   int i=0;
   l0->selectFont("Small.yfm");
   while (i<=35) 
	 {  
			 l0->moveTo(round(CX + (R-1)*COS(i))    , round(CY + (R-1)*SIN(i)));
	    l0->lineTo(round(CX + (R-10)*COS(i))   , round(CY + (R-10)*SIN(i)));
      l0->drawText(round(CX + (R-25)*COS(i)) , round(CY + (R-25)*SIN(i)),YDisplayLayer::ALIGN_BOTTOM_CENTER, inttostr(i) );
			i+=5;
	 }
   YDisplayLayer *l1 = display->get_displayLayer(1);
   l1->hide();
   l0->unhide();
   l3->hide();
}

static void deviceArrival(YModule *m)
{
    string serial = m->get_serialNumber();
    cout << YAPI::GetTickCount() << ':'<<  "Device arrival : " << serial << endl;

	if (serial == MOTORCONTROL_SERIAL) 
		 {  motorAvailable  = true;
        carPower        = YMotor::FindMotor(string(MOTORCONTROL_SERIAL)+string(".motor"));
        carVoltage      = YVoltage::FindVoltage(string(MOTORCONTROL_SERIAL)+string(".voltage"));
        carCurrent      = YCurrent::FindCurrent(string(MOTORCONTROL_SERIAL)+string(".current"));
        carTemperature  = YTemperature::FindTemperature(string(MOTORCONTROL_SERIAL)+string(".temperature"));
        carPower->registerValueCallback(showCarstatus);
        carVoltage->registerValueCallback(showCarsvoltage);
        carCurrent->registerValueCallback(showCarcurrent);
        carTemperature->registerValueCallback(showCarTemperature);
        carPower->set_failSafeTimeout(1000);
        carPower->set_cutOffVoltage(9.3) ;
		 } 

		if (serial == SERVOCONTROL_SERIAL) 
		{
       servoAvailable =true;
       carDirection   = YServo::FindServo(string(SERVOCONTROL_SERIAL)+string(".servo1"));
		}

		if (serial == DISPLAY_SERIAL)    
		{
       displayAvailable = true;
       direction1       = YAnButton::FindAnButton("direction1");
       power1           = YAnButton::FindAnButton("power1");
       resetBtn         = YAnButton::FindAnButton("reset");
	   power1->registerValueCallback(PowerChange);
       direction1->registerValueCallback(directionChange);
	   resetBtn->registerValueCallback(resetChange);
       display          =  YDisplay::FindDisplay("dashboard");
       initDisplay();
	}
			 
}

static void deviceRemoval(YModule *m)
{
  cout << YAPI::GetTickCount() << ':' << "Device removal : " << m->get_serialNumber()<<endl;
	string serial = m->get_serialNumber();
	if (serial == MOTORCONTROL_SERIAL)    motorAvailable =false;
  if (serial == SERVOCONTROL_SERIAL)    servoAvailable =false;
  if (serial== DISPLAY_SERIAL) displayAvailable = false;
 
}


static void refreshDisplay()
{ if (!displayAvailable) return;
   cout << YAPI::GetTickCount() << ": display refresh"<< endl;
   YDisplayLayer* l1 = display->get_displayLayer(1);
   l1->clear();
   l1->moveTo(CX ,CY) ;
   l1->lineTo(round(CX + (R+2)*COS(carLastCurrent /1000.0)),round(CY + (R+2)*SIN(carLastCurrent /1000.0)));
   l1->drawText(0,0,YDisplayLayer::ALIGN_TOP_LEFT,floattostr( carLastTemperature) +"C");
   l1->drawText(127,0,YDisplayLayer::ALIGN_TOP_RIGHT,floattostr( carLastVoltage) +"V");
   display->swapLayerContent(1,2);


		 
}


static void log(const string& val)
{
    cout << val;
}

int main(int argc, const char * argv[])
{
    string errmsg;
    
	cout << "starting.. " <<endl;
    cout << "emitter IP is " << EMITTERIP <<endl;
 	cout << "car IP is " << YOCTOCARIP <<endl;
   
	YAPI::DisableExceptions();
  
    YAPI::RegisterDeviceArrivalCallback(deviceArrival);
    YAPI::RegisterDeviceRemovalCallback(deviceRemoval);
    
    
    if (YAPI::PreregisterHub(EMITTERIP, errmsg) != YAPI::SUCCESS) {
        cerr << "RegisterHub error : " << errmsg<<endl;
        return 1;
		}


	 if (YAPI::PreregisterHub(YOCTOCARIP, errmsg) != YAPI::SUCCESS) {
        cerr << "RegisterHub error : " << errmsg<<endl;
        return 1;
		 }


	 
    while (true) 
		 {  YAPI::HandleEvents(errmsg);
		    u64 now = YAPI::GetTickCount();
    
   			    refreshCarPower(200);
   			    refreshCarDirection(200);
				if (now - lastrefreshDisplay >300)
	  			{ refreshDisplay();
				    lastrefreshDisplay=now;
				  }
				if (now - lastUpdateDeviceList > 2000)
	  			{ cout << now << ": update device list "<< endl;
				    YAPI::UpdateDeviceList(errmsg);
				    lastUpdateDeviceList=now;
				  }
     
	 	} 
}
