
import os, sys
from yocto_api import *
from yocto_colorledcluster import *

errmsg = YRefParam()
# Setup the API to use local USB devices
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)

leds = YColorLedCluster.FirstColorLedCluster();
if leds is None: sys.exit("No color led cluster found")

H=0             # Hue = red
S=255           # Maximum saturation
L=127           # 50% luminosity
LedCount=8      # total RGB LEDs to use
halfPeriod =800 # left to right time, in ms
tail = 2        # 2 pixels tail
Low = (H<<16) | (S<<8);
leds.set_activeLedCount(LedCount);
n=0
while True:
   HSLvalues = [Low for i in range(LedCount)]
   for i in range(1,tail+2):
       x = (n+i)%((2*LedCount)-2)  # some Euclidian division maths
       a = (x)%LedCount            # step [0..LedCount-1]
       b = -2*((x)//LedCount)+1    # way [1,-1]
       c = (LedCount-2)*((x)//LedCount) # offset [0,LedCount-2]
       HSLvalues[a*b+c] =  Low | int(i*L/(tail+1))
   leds.hslArray_move(HSLvalues,int(halfPeriod/LedCount))
   n=(n+1) % ((2*LedCount)-2)
   YAPI.Sleep(int(halfPeriod/LedCount),errmsg)


