
import os, sys
from yocto_api import *
from yocto_colorledcluster import *

errmsg = YRefParam()
# Setup the API to use local USB devices
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)


H=0        # Hue = red
S=255      # Maximum saturation
L=127      # 50% luminosity
LedCount=8 # total RGB LEDs to use
halfPeriod =800  # left to right time, if possible use a multiple of LedCount
tail=2     # tail leds count

Low = (H<<16) | (S<<8) #luminosity set to 0
High = Low | L         #luminosity set to L

halfPeriod += tail * (halfPeriod/LedCount)
LedCount+= tail

leds = YColorLedCluster.FirstColorLedCluster()
if leds is None: sys.exit("No color led cluster found")
leds.set_activeLedCount(LedCount)
leds.resetBlinkSeq(0)                  # reset sequence 0

# addHslMoveToBlinkSeq(sequence, color, duration)
leds.resetBlinkSeq(0)
leds.addHslMoveToBlinkSeq(0, High, halfPeriod /(2*LedCount))
leds.addHslMoveToBlinkSeq(0, Low, 0.75*tail*halfPeriod /(LedCount))
leds.addHslMoveToBlinkSeq(0, Low, 0.25*tail*halfPeriod /(LedCount))
leds.addHslMoveToBlinkSeq(0, Low, (LedCount-2*tail)*halfPeriod /(LedCount))
leds.addHslMoveToBlinkSeq(0, Low,  0.25*tail*halfPeriod /(LedCount))
leds.addHslMoveToBlinkSeq(0, High, 0.75*tail* halfPeriod /(LedCount))
leds.addHslMoveToBlinkSeq(0, High, halfPeriod /(2*LedCount))
leds.addMirrorToBlinkSeq(0)

for i in range(0,LedCount-tail):
     #linkLedToBlinkSeq(ledIndex,Count,Sequence,Offset)
     leds.linkLedToBlinkSeq(i,1,0, -(tail/4)*(halfPeriod /LedCount) \
     + halfPeriod-i*(halfPeriod /LedCount) \
     - halfPeriod /(2*LedCount) )
leds.startBlinkSeq(0)



