
import os, sys
from yocto_api import *
from yocto_colorledcluster import *

errmsg = YRefParam()
# Setup the API to use local USB devices
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)


H=0        # Hue = red
S=255      # Maximum saturation
L=127      # 50% luminosity
LedCount=8 # total RGB LEDs to use
halfPeriod =800  # left to right time, if possible use a multiple of LedCount

Low = (H<<16) | (S<<8) #luminosity set to 0
High = Low | L         #luminosity set to L

leds = YColorLedCluster.FirstColorLedCluster()
if leds is None: sys.exit("No color led cluster found")
leds.set_activeLedCount(LedCount)
leds.resetBlinkSeq(0)                  # reset sequence 0

# addHslMoveToBlinkSeq(sequence, color, duration)
leds.addHslMoveToBlinkSeq(0, High, halfPeriod /(2*LedCount)) # High
leds.addHslMoveToBlinkSeq(0, High, 0)
leds.addHslMoveToBlinkSeq(0, Low, 0)  # low
leds.addHslMoveToBlinkSeq(0, Low, (LedCount-1)*halfPeriod /(LedCount)) # keep it
leds.addHslMoveToBlinkSeq(0, Low, 0)
leds.addHslMoveToBlinkSeq(0, High, 0)  # High again
leds.addHslMoveToBlinkSeq(0, High, halfPeriod /(2*LedCount)) # keep it
leds.addMirrorToBlinkSeq(0)            # do the same thing the other way around

for i in range(0,LedCount):  # link leds to the sequence 0
    #linkLedToBlinkSeq(ledIndex,Count,Sequence,Offset)
    leds.linkLedToBlinkSeq(i,1,0, halfPeriod-i*(halfPeriod /LedCount)- (halfPeriod /(2*LedCount)))
leds.startBlinkSeq(0) # start the sequence

