unit Unit1;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,yocto_api,yocto_temperature,Yocto_relay,
  Vcl.ExtCtrls;

type
  TForm1 = class(TForm)
    TargetValue: TEdit;
    CurrentValue: TEdit;
    IncButton: TButton;
    DecButton: TButton;
    RunButton: TButton;
    StopButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure IncButtonClick(Sender: TObject);
    procedure DecButtonClick(Sender: TObject);
    procedure RunButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
  private
    { Private declarations }
    Sensor : TYtemperature;
    Relay  : TYRelay;
    running  : boolean;
    PID_Data : array[0..10] of double;
    PID_Ptr :  integer;
    VirtualTarget : double;

  public
    { Public declarations }
    procedure resetPID();
    function PID(target,current:double):double;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


procedure  TForm1.resetPID();
 begin
  PID_Ptr :=0;
 end;

function   TForm1.PID(target,current:double):double;
var err,P,I,D : double;
    n:integer;
const
    PID_A = 150.0;
    PID_B = 100.0;
    PID_C = -50.0;

 begin
  err :=   target-current;
  if PID_Ptr<length(PID_Data)-1 then
     begin
         PID_Data[PID_Ptr]:=err;
         inc(PID_Ptr);
     end
     else
     begin
       move(PID_Data[1],PID_Data[0],(length(PID_Data)-1)*sizeof(double));
       PID_Data[length(PID_Data)-1] := err;
     end;

   if PID_Ptr>2 then
   begin
     P :=   PID_Data[PID_Ptr-1];
     I:=0;
     for n:=0 to  PID_Ptr-1 do    i:=i+  PID_Data[n];
     I := I / PID_Ptr;
     D :=   ( PID_Data[PID_Ptr-1] -    PID_Data[0] ) /  PID_Ptr;
     PID := PID_A * P +    PID_B * I + PID_C * D;
   end else PID:=0;
 end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   resetPID();
   Sensor := YFindTemperature('Box-Temp');
   Relay := YFindrelay('Box-Lamp');
   if not(Sensor.isOnline()) then
   begin
    MessageDlg('No temperature sensor named Box-Temp',mtwarning,[mbok],0);
    RunButton.Enabled:=false;
   end;
   if not(Relay.isOnline()) then
   begin
    MessageDlg('No relay named Box-Lamp',mtwarning,[mbok],0);
    RunButton.Enabled:=false;
   end;
end;


procedure TForm1.IncButtonClick(Sender: TObject);
begin
   TargetValue.Text := inttoStr(strtoint(TargetValue.Text)+1);
end;

procedure TForm1.DecButtonClick(Sender: TObject);
begin
   TargetValue.Text := inttoStr(strtoint(TargetValue.Text)-1);
end;

procedure TForm1.RunButtonClick(Sender: TObject);
begin
  RunButton.Enabled:=false;
  StopButton.Enabled:=true;
  VirtualTarget := Sensor.get_currentValue();
  running:=true;
end;

procedure TForm1.StopButtonClick(Sender: TObject);
begin
  RunButton.Enabled:=true;
  StopButton.Enabled:=false;
  running:=false;
end;

{
// Basic ON/OFF regulation
procedure TForm1.Timer1Timer(Sender: TObject);
var
 temp : double ;
 target : double ;
begin
   if Sensor.isOnline() then
     begin
        target := strtofloat(TargetValue.Text)  ;
        temp :=  Sensor.get_currentValue();
        CurrentValue.Text :=  format('%.2f', [temp]  )+   Sensor.get_unit();
        if (running and relay.isOnline()) then
         begin
          if temp<target  then  relay.pulse(timer1.Interval+100)
                          else  relay.set_state(0);
         end;
     end;
end;
 }

{
// PID, no slew control
procedure TForm1.Timer1Timer(Sender: TObject);
var
 temp : double ;
 target : double ;
 delay:integer;
begin
   if Sensor.isOnline() then
     begin
        target := strtofloat(TargetValue.Text)  ;
        temp :=  Sensor.get_currentValue();
        CurrentValue.Text :=  format('%.2f', [temp]  )+   Sensor.get_unit();
        if (running and relay.isOnline()) then
         begin
           delay:=  round(PID(target,temp));
           if (delay<0) then delay:=0;
           if (delay>timer1.Interval+100)  then delay:=timer1.Interval+100;
           Relay.pulse(delay );
         end;
     end;
end;
 }


// PID, with slew control
procedure TForm1.Timer1Timer(Sender: TObject);
var
 temp : double ;
 target : double ;
 delay:integer;
begin
   if Sensor.isOnline() then
     begin
        target := strtofloat(TargetValue.Text);
        if abs(target-virtualTarget)>1 then
          begin
            if virtualTarget< target
               then  virtualTarget:=virtualTarget+1
               else  virtualTarget:=virtualTarget-1;
          end else   virtualTarget:=target;
        temp :=  Sensor.get_currentValue();
        CurrentValue.Text :=  format('%.2f', [temp]  )+   Sensor.get_unit();
        if (running and relay.isOnline()) then
          begin
            delay := round( PID(virtualTarget,temp) );
            if (delay<0) then delay:=0;
            if (delay>timer1.Interval+100)  then delay:=timer1.Interval+100;
            Relay.pulse(delay );
           end;
     end;
end;


end.
