import os, sys
from  GT521F52 import *
from yocto_api import *
from yocto_serialport import *

def eventCallback(eventType, id):  #something happened
    if eventType== GT521F52_fingerPrintScanner.EVENT_IDENTOK:
        print("Sucessfull ID="+str(id))
    if eventType== GT521F52_fingerPrintScanner.EVENT_IDENTFAILED:
        print("Failed")

errmsg = YRefParam()
# Setup the API to use local USB devices
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)
# assumes the  GT521F52 is conencted to the first serial port available
serial = YSerialPort.FirstSerialPort()
scanner =  GT521F52_fingerPrintScanner(serial)

if not scanner.open(): print(scanner.lastErrorMsg)
YAPI.Sleep(100)
scanner.ledControl(True) # don't forget to turn the  internal LED on!
scanner.set_eventCallback(eventCallback) # callback to call after any fingerprint scan
scanner.runInBackground() # fingerprint recognition will automatically  run in background

while scanner.isBackgroundRunning():

  print("\nHello, "+str(scanner.getEnrollCount())+" fingerprints are enrolled")
  print("What would you like to do?")
  print("1- Add new entry")
  print("2- Clear All entries")
  print("3- Quit")
  print("")
  c = input("your choice:")
  if c=="1": scanner.startEnrollProcess(print)
  if c=="2": scanner.deleteAll()
  if c=="3":
       scanner.stopBackgroundRun()
       while scanner.isBackgroundRunning(): time.sleep(2)
print("terminated")










