import os, sys
from  GT521F52 import *
from yocto_api import *
from yocto_serialport import *
from yocto_buzzer import *
from yocto_led import *

def eventCallback(event, id):  #something happened
    if event==  GT521F52_fingerPrintScanner.EVENT_IDENTOK:
         greenLED.set_power(100)
         redLED.set_power(0)
         buzzer.playNotes("200% 'G12 C E G6 E12 G2")
    elif event==  GT521F52_fingerPrintScanner.EVENT_IDENTFAILED:
         greenLED.set_power(00)
         redLED.set_power(100)
         buzzer.playNotes(",C32^ C32^ C8")
    elif event==  GT521F52_fingerPrintScanner.EVENT_FINGEROFF:
         greenLED.set_power(0)
         redLED.set_power(0)


errmsg = YRefParam()
# Setup the API to use local USB devices
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)
# assumes the  GT521F52 is conencted to the first serial port available
serial   = YSerialPort.FirstSerialPort()
scanner  = GT521F52_fingerPrintScanner(serial)
buzzer   = YBuzzer.FirstBuzzer()
greenLED = YLed.FindLed(buzzer.get_module().get_serialNumber()+".led1")
redLED   = YLed.FindLed(buzzer.get_module().get_serialNumber()+".led2")

greenLED.set_blinking(YLed.BLINKING_STILL)
redLED.set_blinking(YLed.BLINKING_STILL)


if not scanner.open(): print(scanner.lastErrorMsg)
YAPI.Sleep(100)
scanner.ledControl(True) # don't forget to turn the  internal LED on!
scanner.set_eventCallback(eventCallback) # callback to call whenever something happens
scanner.runInBackground() # fingerprint recognition will automatically  run in background

while scanner.isBackgroundRunning():
  print("\nHello, "+str(scanner.getEnrollCount())+" fingerprints are enrolled")
  print("What would you like to do?")
  print("1- Add new entry")
  print("2- Clear All entries")
  print("3- Quit")
  print("")
  c = input("your choice:")
  if c=="1": scanner.startEnrollProcess(print)
  if c=="2": scanner.deleteAll()
  if c=="3":
       scanner.stopBackgroundRun()
       while scanner.isBackgroundRunning(): time.sleep(2)
print("terminated")



