import os, sys
import threading
from yocto_api import *
from yocto_serialport import *
from yocto_poweroutput import *


class GT521F52_response:

    ERR_NACKTIMEOUT        = 0x1001
    ERR_INVALIDBUADRATE    = 0x1002
    ERR_INVALIDPOS         = 0x1003
    ERR_ISNOTUSED          = 0x1004
    ERR_ISALREADYUSED      = 0x1005
    ERR_COMMERR            = 0x1006
    ERR_VERIFYFAILED       = 0x1007
    ERR_IDENTIFYFAILED     = 0x1008
    ERR_DBISFULL           = 0x1009
    ERR_DBISEMPTY          = 0x100A
    ERR_TURNERR            = 0x100B
    ERR_BADFINGER          = 0x100C
    ERR_ENROLLFAILED       = 0x100D
    ERR_NOTSUPPORTED       = 0x100E
    ERR_DEVERR             = 0x100F
    ERR_CAPTURECANCELLED   = 0x1010
    ERR_INVALIDPARAM       = 0x1011
    ERR_FINGERISNOTPRESSED = 0x1012

    OK = False
    data = -1
    error = 0
    errormsg="unknow error"


    def __init__(self, hexstring,debug ):
        if debug:  print(" ->"+hexstring)
        res = bytearray.fromhex(hexstring)
        if res[8] == 0x30 :
              self.OK       = True
              self.data     = res[4] +  (res[5]<<8) +  (res[6]<<16) +  (res[7]<<24)
              self.errormsg = "no error"
        else:
          if res[8] == 0x31 :   self.error = res[4] +  (res[5]<<8) +  (res[6]<<16) +  (res[7]<<24)
          if self.error == self.ERR_NACKTIMEOUT :       self.errormsg="capture timeout"
          if self.error == self.ERR_INVALIDBUADRATE :   self.errormsg="invalid serial baud rate"
          if self.error == self.ERR_INVALIDPOS :        self.errormsg="the specified ID is not 0-999"
          if self.error == self.ERR_ISNOTUSED :         self.errormsg="the specified ID is not used"
          if self.error == self.ERR_ISALREADYUSED :     self.errormsg="the specified ID is already used"
          if self.error == self.ERR_COMMERR :           self.errormsg="communication error"
          if self.error == self.ERR_VERIFYFAILED:       self.errormsg="1:1 verification error"
          if self.error == self.ERR_IDENTIFYFAILED :    self.errormsg="1:N verification error"
          if self.error == self.ERR_DBISFULL :          self.errormsg="the database is full"
          if self.error == self.ERR_DBISEMPTY:          self.errormsg="the database is empty"
          if self.error == self.ERR_TURNERR :           self.errormsg="invalid order of enrollment"
          if self.error == self.ERR_BADFINGER:          self.errormsg="too bad fingerprint"
          if self.error == self.ERR_ENROLLFAILED :      self.errormsg="enrollment failure"
          if self.error == self.ERR_NOTSUPPORTED :      self.errormsg="The specified command is not supported"
          if self.error == self.ERR_DEVERR :            self.errormsg="device error"
          if self.error == self.ERR_CAPTURECANCELLED :  self.errormsg="the capturing is canceled"
          if self.error == self.ERR_INVALIDPARAM :      self.errormsg="invalid finger"
          if self.error == self.ERR_FINGERISNOTPRESSED: self.errormsg="finger is nor pressed"





class GT521F52_fingerPrintScanner:
    serial=None
    lastErrorMsg = ""
    lastErrorCode = 0
    debug=False
    mustTerminate=False
    backgroundRunning = False
    eventCallback = None
    recursion=0
    mustRestoreBg =False



    CMD_OPEN              = 0x01
    CMD_CLOSE             = 0x02
    CMD_USBINTERNALCHECK  = 0x03
    CMD_CHANGEBAUDRATE    = 0x04
    CMD_CMOSLED           = 0x12
    CMD_GETENROLLCOUNT    = 0x20
    CMD_CHECKENROLLED     = 0x21
    CMD_ENROLLSTART       = 0x22
    CMD_ENROLL1           = 0x23
    CMD_ENROLL2           = 0x24
    CMD_ENROLL3           = 0x25
    CMD_ISPRESSFINGER     = 0x26
    CMD_DELETEID          = 0x40
    CMD_DELETE_ALL        = 0x41
    CMD_VERIFY            = 0x50
    CMD_IDENTIFY          = 0x51
    CMD_VERIFYTEMPLATE    = 0x52
    CMD_IDENTIFYTEMPLATE  = 0x53
    CMD_CAPTUREFINGER     = 0x60
    CMD_MAKETEMPLATE      = 0x61
    CMD_GETIMAGE          = 0x62
    CMD_GETRAWIMAGE       = 0x63
    CMD_GETTEMPLATE       = 0x70
    CMD_SETTEMPALTE       = 0x71
    CMD_GETDATABASETART   = 0x72
    CMD_GETDATABASE_END   = 0x73
    CMD_SETSECURITYLEVEL  = 0xF0
    CMD_GETSECURITYLEVEL  = 0xf1
    CMD_IDENTIFYTEMPLATE2 = 0xf4
    CMD_ENTERSTANDBYMODE  = 0xf9

    EVENT_FINGERON       = 1
    EVENT_FINGEROFF      = 3
    EVENT_IDENTOK        = 2
    EVENT_IDENTFAILED  = 0




    def __init__(self, serialPort):
        self.serial= serialPort

        if (self.serial.isOnline()):

          self.serial.set_voltageLevel( YSerialPort.VOLTAGELEVEL_TTL3V)
          self.serial.set_protocol("Frame:10ms")
          power=  YPowerOutput.FindPowerOutput(self.serial.get_module().get_serialNumber()+".powerOutput")
          power.set_voltage(YPowerOutput.VOLTAGE_OUT3V3)
          self.serial.reset()
        else:
          raise   Exception('serial port is offline')

    def setDebug(self, debug):
       self.debug=debug

    def cmd(self, command ,parameter):
        res = [0x55, 0xAA, 0x01, 0x00, 0x00, 0x00,0x00, 0x00, 0x00,0x00, 0x00, 0x00];
        res[4] = (parameter & 0xFF)
        res[5] = (parameter >> 8) & 0xFF
        res[6] = (parameter >> 16) & 0xFF
        res[7] = (parameter >> 32) & 0xFF
        res[8] = (command  & 0xFF)
        res[9] = (command >> 8) & 0xFF
        sum =0
        for i in range(0,9): sum += res[i]
        res[10] = (sum  & 0xFF)
        res[11] = (sum >> 8) & 0xFF
        c=  ''.join('{:02X}'.format(x) for x in res)
        if self.debug : print(c)
        return c

    def readResponse(self):
        doLoop = True
        while  doLoop:
           response = self.serial.readMessages("",200)
           if len(response)>0: doLoop=False

        res =  GT521F52_response(response[0],self.debug)
        self.lastErrorMsg = res.errormsg
        self.lastErrorCode = res.error
        return res

    def open(self):
        self.serial.writeHex(self.cmd(self.CMD_OPEN,0))
        return self.readResponse().OK

    def close(self):
        self.serial.writeHex(self.cmd(self.CMD_CLOSE,0))
        return self.readResponse().OK

    def ledControl(self, bool_on):
        if bool_on :
           self.serial.writeHex(self.cmd(self.CMD_CMOSLED,1))
        else:
           self.serial.writeHex(self.cmd(self.CMD_CMOSLED,0))
        return self.readResponse().OK

    def  getEnrollCount(self):
        self.pauseBackGroundWork()
        self.serial.writeHex(self.cmd(self.CMD_GETENROLLCOUNT,0))
        c=  self.readResponse().data;
        self.restoreBackGroundWork()
        return c

    def  checkEnrolled(self, id):
        self.serial.writeHex(self.cmd(self.CMD_CHECKENROLLED ,id))
        return self.readResponse().OK

    def  enrollStart(self,id):
        self.serial.writeHex(self.cmd(self.CMD_ENROLLSTART  ,id))
        return self.readResponse().OK

    def  enroll(self, passNumber):
        if passNumber==1 :
            self.serial.writeHex(self.cmd(self.CMD_ENROLL1  ,0))
        elif passNumber==2 :
            self.serial.writeHex(self.cmd(self.CMD_ENROLL2  ,0))
        elif passNumber==3 :
            self.serial.writeHex(self.cmd(self.CMD_ENROLL3  ,0))
        else: raise Exception('Invalid pass number')
        ok =  self.readResponse().OK
        if (passNumber==3) and ok:
             response = self.serial.readMessages("",200)
        return ok

    def _isPressFinger(self):

        self.serial.writeHex(self.cmd(self.CMD_ISPRESSFINGER   ,0))
        response = self.readResponse();

        if   response.OK and response.data==0 : return True
        return False

    def isPressFinger(self):
        self.pauseBackGroundWork()
        res= self._isPressFinger()
        self.restoreBackGroundWork()
        return res

    def deleteID(self,id):
        self.pauseBackGroundWork()
        self.serial.writeHex(self.cmd(self.CMD_DELETEID   ,id))
        ok= self.readResponse().OK
        self.restoreBackGroundWork()
        return ok

    def deleteAll(self):
        self.pauseBackGroundWork()
        self.serial.writeHex(self.cmd(self.CMD_DELETE_ALL   ,0))
        ok= self.readResponse().OK
        self.restoreBackGroundWork()
        return ok

    def verify(self,id):
        self.serial.writeHex(self.cmd(self.CMD_VERIFY   ,id))
        return self.readResponse().OK


    def identify(self):
        self.serial.writeHex(self.cmd(self.CMD_IDENTIFY   ,0))
        response = self.readResponse()
        if response.OK : return response.data

        return -1

    def captureFinger(self,fast):

        param = 1
        if fast :  param=0
        self.serial.writeHex(self.cmd(self.CMD_CAPTUREFINGER   ,param))
        ok=  self.readResponse().OK

        return ok

    def internalLoop(self):
       self.backgroundRunning= True
       retriesCount =0
       waitForFingerRemoval = False


       while not self.mustTerminate:
          if self._isPressFinger():
             if not waitForFingerRemoval:  self.eventCallback(self.EVENT_FINGERON,0)
             if not waitForFingerRemoval:
                if self.captureFinger(True):
                   id= self.identify()
                   if id >0:
                      self.eventCallback(self.EVENT_IDENTOK,id)
                      waitForFingerRemoval=True
                   else:
                      retriesCount=retriesCount+1
                      if retriesCount>2 :
                         self.eventCallback(self.EVENT_IDENTFAILED,-1)
                         waitForFingerRemoval=True
          else:
              if waitForFingerRemoval:  self.eventCallback(self.EVENT_FINGEROFF,0)
              waitForFingerRemoval=False
              retriesCount=0

       self.backgroundRunning= False


    def set_eventCallback(self,callback):
        # call back must a 2 parameter fonction
        # param 1 will contain the event type:  EVENT_FINGERON, EVENT_FINGEROFF,  EVENT_IDENTOK,  EVENT_IDENTFAILED
        # if event type = EVENT_IDENTOK then second parameter will be the ID
        self.eventCallback = callback

    def runInBackground(self):
        self.mustTerminate=False
        t=threading.Thread(target=self.internalLoop, args = ())
        t.daemon = True
        t.start()

    def isBackgroundRunning(self):
        return self.backgroundRunning

    def stopBackgroundRun(self):
        self.mustTerminate=True;

    def error(self, showMessage, message):
        self.restoreBackGroundWork()
        if not showMessage is None:   showMessage(message);
        return False

    def pauseBackGroundWork(self):

        self.recursion= self.recursion+1;
        if self.recursion>1:  return;

        self.mustRestoreBg  = self.isBackgroundRunning()
        if self.mustRestoreBg:
          self.stopBackgroundRun()
          while self.isBackgroundRunning():time.sleep(1)



    def restoreBackGroundWork(self):

        self.recursion= self.recursion-1
        if  not  self.mustRestoreBg : return
        if self.recursion>0: return
        self.runInBackground()

    def startEnrollProcess(self, showMessage):
        self.pauseBackGroundWork()
        id =1
        while self.checkEnrolled(id) and (id<2999) :  id=id+1;
        if  not self.enrollStart(id) :  return self.error( showMessage, self.lastErrorMsg)
        for i in range(1,4):
           if not showMessage is None:   showMessage(str(i)+"/3 Place your finger on the Sensor");

           timeout=0;
           while not(self.isPressFinger()) and timeout<50 :
             time.sleep(0.1)
             timeout=timeout+1

           if not self.isPressFinger()  : return self.error( showMessage, "timeout")

           if not self.captureFinger(True):return self.error( showMessage, self.lastErrorMsg)

           if not self.enroll(i) : return self.error( showMessage, self.lastErrorMsg)

           if not showMessage is None:   showMessage(str(i)+"/3 Remove your finger from the Sensor");
           timeout=0
           while self.isPressFinger() and timeout<50 :
                time.sleep(0.1)
                timeout=timeout+1
           if  self.isPressFinger() : return self.error( showMessage, "timeout")

        if not showMessage is None:   showMessage("Enrollement done");
        self.restoreBackGroundWork()
        return True
