/*********************************************************************
 *
 *  $Id: svn_id $
 *
 *  Implements commands to handle Sdi12Port functions
 *
 *  - - - - - - - - - License information: - - - - - - - - -
 *
 *  Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
 *
 *  Yoctopuce Sarl (hereafter Licensor) grants to you a perpetual
 *  non-exclusive license to use, modify, copy and integrate this
 *  file into your software for the sole purpose of interfacing
 *  with Yoctopuce products.
 *
 *  You may reproduce and distribute copies of this file in
 *  source or object form, as long as the sole purpose of this
 *  code is to interface with Yoctopuce products. You must retain
 *  this notice in the distributed source file.
 *
 *  You should refer to Yoctopuce General Terms and Conditions
 *  for additional information regarding your rights and
 *  obligations.
 *
 *  THE SOFTWARE AND DOCUMENTATION ARE PROVIDED 'AS IS' WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 *  WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS
 *  FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
 *  EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA,
 *  COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR
 *  SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
 *  LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
 *  CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
 *  BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
 *  WARRANTY, OR OTHERWISE.
 *
 *********************************************************************/


#define _CRT_SECURE_NO_DEPRECATE
#include <stdio.h>
#include "YSdi12Port.h"
#include "yocto_api.h"
#include "yocto_sdi12port.h"

using namespace std;

//--- (generated code: YSdi12Port definitions)

static const char *enumSerialVoltageLevel[] = {
    "OFF",
    "TTL3V",
    "TTL3VR",
    "TTL5V",
    "TTL5VR",
    "RS232",
    "RS485",
    "TTL1V8",
    "SDI12",
    NULL
};

//--- (end of generated code: YSdi12Port definitions)


//--- (generated code: YSdi12Port implementation)
bool   YSdi12PortCmdLine::isModule(void)      { return false; }
string YSdi12PortCmdLine::YFunctionName(void) { return "YSdi12Port"; }

// type of logicalName is string (Text)
// type of advertisedValue is string (PubText)
// type of rxCount is int (UInt31)
// type of txCount is int (UInt31)
// type of errCount is int (UInt31)
// type of rxMsgCount is int (UInt31)
// type of txMsgCount is int (UInt31)
// type of lastMsg is string (Text)
// type of currentJob is string (Text)
// type of startupJob is string (Text)
// type of jobMaxTask is int (UInt31)
// type of jobMaxSize is int (UInt31)
// type of command is string (Text)
// type of protocol is string (Protocol)
// type of voltageLevel is int (SerialVoltageLevel)
// type of serialMode is string (SerialMode)
/**
 * Returns the logical name of the SDI12 port.
 *
 * @return a string corresponding to the logical name of the SDI12 port
 *
 * On failure, throws an exception or returns YSdi12Port.LOGICALNAME_INVALID.
 */
class Sdi12Port_get_logicalName : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_logicalName(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_logicalName";
  }

  string getDescription()
  {
    return "Returns the logical name of the SDI12 port.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_logicalName();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the logical name of the SDI12 port. You can use yCheckLogicalName()
 * prior to this call to make sure that your parameter is valid.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @param newval : a string corresponding to the logical name of the SDI12 port
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class Sdi12Port_set_logicalName : public YapiCommand /* arguments: newval */
{
public:
  Sdi12Port_set_logicalName(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_logicalName";
  }

  string getDescription()
  {
    return "Changes the logical name of the SDI12 port.";
  }

  string getMoreInfo()
  {
    return "You can use yCheckLogicalName() prior to this call to make sure that your parameter is valid. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "newval", "a string corresponding to the logical name of the SDI12 port", "_LOGICAL", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    if (!YAPI::CheckLogicalName((*args)[0]->get_stringValue())) {
        throw std::string("Invalid name :" + (*args)[0]->get_stringValue());
    }
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_logicalName(string((*args)[0]->get_stringValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns a short string representing the current state of the SDI12 port.
 *
 * @return a string corresponding to a short string representing the current state of the SDI12 port
 *
 * On failure, throws an exception or returns YSdi12Port.ADVERTISEDVALUE_INVALID.
 */
class Sdi12Port_get_advertisedValue : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_advertisedValue(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_advertisedValue";
  }

  string getDescription()
  {
    return "Returns a short string representing the current state of the SDI12 port.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_advertisedValue();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the total number of bytes received since last reset.
 *
 * @return an integer corresponding to the total number of bytes received since last reset
 *
 * On failure, throws an exception or returns YSdi12Port.RXCOUNT_INVALID.
 */
class Sdi12Port_get_rxCount : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_rxCount(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_rxCount";
  }

  string getDescription()
  {
    return "Returns the total number of bytes received since last reset.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_rxCount();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the total number of bytes transmitted since last reset.
 *
 * @return an integer corresponding to the total number of bytes transmitted since last reset
 *
 * On failure, throws an exception or returns YSdi12Port.TXCOUNT_INVALID.
 */
class Sdi12Port_get_txCount : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_txCount(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_txCount";
  }

  string getDescription()
  {
    return "Returns the total number of bytes transmitted since last reset.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_txCount();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the total number of communication errors detected since last reset.
 *
 * @return an integer corresponding to the total number of communication errors detected since last reset
 *
 * On failure, throws an exception or returns YSdi12Port.ERRCOUNT_INVALID.
 */
class Sdi12Port_get_errCount : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_errCount(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_errCount";
  }

  string getDescription()
  {
    return "Returns the total number of communication errors detected since last reset.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_errCount();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the total number of messages received since last reset.
 *
 * @return an integer corresponding to the total number of messages received since last reset
 *
 * On failure, throws an exception or returns YSdi12Port.RXMSGCOUNT_INVALID.
 */
class Sdi12Port_get_rxMsgCount : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_rxMsgCount(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_rxMsgCount";
  }

  string getDescription()
  {
    return "Returns the total number of messages received since last reset.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_rxMsgCount();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the total number of messages send since last reset.
 *
 * @return an integer corresponding to the total number of messages send since last reset
 *
 * On failure, throws an exception or returns YSdi12Port.TXMSGCOUNT_INVALID.
 */
class Sdi12Port_get_txMsgCount : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_txMsgCount(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_txMsgCount";
  }

  string getDescription()
  {
    return "Returns the total number of messages send since last reset.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_txMsgCount();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the latest message fully received.
 *
 * @return a string corresponding to the latest message fully received
 *
 * On failure, throws an exception or returns YSdi12Port.LASTMSG_INVALID.
 */
class Sdi12Port_get_lastMsg : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_lastMsg(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_lastMsg";
  }

  string getDescription()
  {
    return "Returns the latest message fully received.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_lastMsg();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the name of the job file currently in use.
 *
 * @return a string corresponding to the name of the job file currently in use
 *
 * On failure, throws an exception or returns YSdi12Port.CURRENTJOB_INVALID.
 */
class Sdi12Port_get_currentJob : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_currentJob(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_currentJob";
  }

  string getDescription()
  {
    return "Returns the name of the job file currently in use.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_currentJob();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Selects a job file to run immediately. If an empty string is
 * given as argument, stops running current job file.
 *
 * @param newval : a string
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class Sdi12Port_set_currentJob : public YapiCommand /* arguments: newval */
{
public:
  Sdi12Port_set_currentJob(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_currentJob";
  }

  string getDescription()
  {
    return "Selects a job file to run immediately.";
  }

  string getMoreInfo()
  {
    return "If an empty string is given as argument, stops running current job file.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "newval", "a string", "_STRING", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_currentJob(string((*args)[0]->get_stringValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the job file to use when the device is powered on.
 *
 * @return a string corresponding to the job file to use when the device is powered on
 *
 * On failure, throws an exception or returns YSdi12Port.STARTUPJOB_INVALID.
 */
class Sdi12Port_get_startupJob : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_startupJob(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_startupJob";
  }

  string getDescription()
  {
    return "Returns the job file to use when the device is powered on.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_startupJob();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the job to use when the device is powered on.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @param newval : a string corresponding to the job to use when the device is powered on
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class Sdi12Port_set_startupJob : public YapiCommand /* arguments: newval */
{
public:
  Sdi12Port_set_startupJob(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_startupJob";
  }

  string getDescription()
  {
    return "Changes the job to use when the device is powered on.";
  }

  string getMoreInfo()
  {
    return "Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "newval", "a string corresponding to the job to use when the device is powered on", "_STRING", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_startupJob(string((*args)[0]->get_stringValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the maximum number of tasks in a job that the device can handle.
 *
 * @return an integer corresponding to the maximum number of tasks in a job that the device can handle
 *
 * On failure, throws an exception or returns YSdi12Port.JOBMAXTASK_INVALID.
 */
class Sdi12Port_get_jobMaxTask : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_jobMaxTask(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_jobMaxTask";
  }

  string getDescription()
  {
    return "Returns the maximum number of tasks in a job that the device can handle.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_jobMaxTask();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns maximum size allowed for job files.
 *
 * @return an integer corresponding to maximum size allowed for job files
 *
 * On failure, throws an exception or returns YSdi12Port.JOBMAXSIZE_INVALID.
 */
class Sdi12Port_get_jobMaxSize : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_jobMaxSize(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_jobMaxSize";
  }

  string getDescription()
  {
    return "Returns maximum size allowed for job files.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_jobMaxSize();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the type of protocol used over the serial line, as a string.
 * Possible values are "Line" for ASCII messages separated by CR and/or LF,
 * "Frame:[timeout]ms" for binary messages separated by a delay time,
 * "Char" for a continuous ASCII stream or
 * "Byte" for a continuous binary stream.
 *
 * @return a string corresponding to the type of protocol used over the serial line, as a string
 *
 * On failure, throws an exception or returns YSdi12Port.PROTOCOL_INVALID.
 */
class Sdi12Port_get_protocol : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_protocol(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_protocol";
  }

  string getDescription()
  {
    return "Returns the type of protocol used over the serial line, as a string.";
  }

  string getMoreInfo()
  {
    return "Possible values are \"Line\" for ASCII messages separated by CR and/or LF, \"Frame:[timeout]ms\" for binary messages separated by a delay time, \"Char\" for a continuous ASCII stream or \"Byte\" for a continuous binary stream.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_protocol();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the type of protocol used over the serial line.
 * Possible values are "Line" for ASCII messages separated by CR and/or LF,
 * "Frame:[timeout]ms" for binary messages separated by a delay time,
 * "Char" for a continuous ASCII stream or
 * "Byte" for a continuous binary stream.
 * The suffix "/[wait]ms" can be added to reduce the transmit rate so that there
 * is always at lest the specified number of milliseconds between each bytes sent.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @param newval : a string corresponding to the type of protocol used over the serial line
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class Sdi12Port_set_protocol : public YapiCommand /* arguments: newval */
{
public:
  Sdi12Port_set_protocol(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_protocol";
  }

  string getDescription()
  {
    return "Changes the type of protocol used over the serial line.";
  }

  string getMoreInfo()
  {
    return "Possible values are \"Line\" for ASCII messages separated by CR and/or LF, \"Frame:[timeout]ms\" for binary messages separated by a delay time, \"Char\" for a continuous ASCII stream or \"Byte\" for a continuous binary stream. The suffix \"/[wait]ms\" can be added to reduce the transmit rate so that there is always at lest the specified number of milliseconds between each bytes sent. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "newval", "a string corresponding to the type of protocol used over the serial line", "_STRING", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_protocol(string((*args)[0]->get_stringValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the voltage level used on the serial line.
 *
 * @return a value among YSdi12Port.VOLTAGELEVEL_OFF, YSdi12Port.VOLTAGELEVEL_TTL3V,
 * YSdi12Port.VOLTAGELEVEL_TTL3VR, YSdi12Port.VOLTAGELEVEL_TTL5V, YSdi12Port.VOLTAGELEVEL_TTL5VR,
 * YSdi12Port.VOLTAGELEVEL_RS232, YSdi12Port.VOLTAGELEVEL_RS485, YSdi12Port.VOLTAGELEVEL_TTL1V8 and
 * YSdi12Port.VOLTAGELEVEL_SDI12 corresponding to the voltage level used on the serial line
 *
 * On failure, throws an exception or returns YSdi12Port.VOLTAGELEVEL_INVALID.
 */
class Sdi12Port_get_voltageLevel : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_voltageLevel(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_voltageLevel";
  }

  string getDescription()
  {
    return "Returns the voltage level used on the serial line.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_voltageLevel();
        string strval =  enumString(attrval,enumSerialVoltageLevel);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the voltage type used on the serial line. Valid
 * values  will depend on the Yoctopuce device model featuring
 * the serial port feature.  Check your device documentation
 * to find out which values are valid for that specific model.
 * Trying to set an invalid value will have no effect.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @param newval : a value among YSdi12Port.VOLTAGELEVEL_OFF, YSdi12Port.VOLTAGELEVEL_TTL3V,
 * YSdi12Port.VOLTAGELEVEL_TTL3VR, YSdi12Port.VOLTAGELEVEL_TTL5V, YSdi12Port.VOLTAGELEVEL_TTL5VR,
 * YSdi12Port.VOLTAGELEVEL_RS232, YSdi12Port.VOLTAGELEVEL_RS485, YSdi12Port.VOLTAGELEVEL_TTL1V8 and
 * YSdi12Port.VOLTAGELEVEL_SDI12 corresponding to the voltage type used on the serial line
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class Sdi12Port_set_voltageLevel : public YapiCommand /* arguments: newval */
{
public:
  Sdi12Port_set_voltageLevel(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_voltageLevel";
  }

  string getDescription()
  {
    return "Changes the voltage type used on the serial line.";
  }

  string getMoreInfo()
  {
    return "Valid values will depend on the Yoctopuce device model featuring the serial port feature. Check your device documentation to find out which values are valid for that specific model. Trying to set an invalid value will have no effect. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "newval", "a value among OFF, TTL3V, TTL3VR, TTL5V, TTL5VR, RS232, RS485, TTL1V8 and SDI12 corresponding to the voltage type used on the serial line", "OFF=0,TTL3V=1,TTL3VR=2,TTL5V=3,TTL5VR=4,RS232=5,RS485=6,TTL1V8=7,SDI12=8", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_voltageLevel(Y_VOLTAGELEVEL_enum((*args)[0]->get_intValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the serial port communication parameters, as a string such as
 * "1200,7E1,Simplex". The string includes the baud rate, the number of data bits,
 * the parity, and the number of stop bits. The suffix "Simplex" denotes
 * the fact that transmission in both directions is multiplexed on the
 * same transmission line.
 *
 * @return a string corresponding to the serial port communication parameters, as a string such as
 *         "1200,7E1,Simplex"
 *
 * On failure, throws an exception or returns YSdi12Port.SERIALMODE_INVALID.
 */
class Sdi12Port_get_serialMode : public YapiCommand /* arguments: */
{
public:
  Sdi12Port_get_serialMode(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_serialMode";
  }

  string getDescription()
  {
    return "Returns the serial port communication parameters, as a string such as\"1200,7E1,Simplex\".";
  }

  string getMoreInfo()
  {
    return "The string includes the baud rate, the number of data bits, the parity, and the number of stop bits. The suffix \"Simplex\" denotes the fact that transmission in both directions is multiplexed on the same transmission line.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_serialMode();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the serial port communication parameters, with a string such as
 * "1200,7E1,Simplex". The string includes the baud rate, the number of data bits,
 * the parity, and the number of stop bits. The suffix "Simplex" denotes
 * the fact that transmission in both directions is multiplexed on the
 * same transmission line.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @param newval : a string corresponding to the serial port communication parameters, with a string such as
 *         "1200,7E1,Simplex"
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class Sdi12Port_set_serialMode : public YapiCommand /* arguments: newval */
{
public:
  Sdi12Port_set_serialMode(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_serialMode";
  }

  string getDescription()
  {
    return "Changes the serial port communication parameters, with a string such as\"1200,7E1,Simplex\".";
  }

  string getMoreInfo()
  {
    return "The string includes the baud rate, the number of data bits, the parity, and the number of stop bits. The suffix \"Simplex\" denotes the fact that transmission in both directions is multiplexed on the same transmission line. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "newval", "a string corresponding to the serial port communication parameters, with a string such as \"1200,7E1,Simplex\"", "_STRING", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_serialMode(string((*args)[0]->get_stringValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

// type of valueCallbackSdi12Port is YSdi12PortValueCallback* (YSdi12PortValueCallback)
// type of rxptr is int (int)
// type of rxbuff is bin (bin)
// type of rxbuffptr is int (int)
// type of eventPos is int (int)
/**
 * Disables the propagation of every new advertised value to the parent hub.
 * You can use this function to save bandwidth and CPU on computers with limited
 * resources, or to prevent unwanted invocations of the HTTP callback.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @return YAPI.SUCCESS when the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_muteValueCallbacks : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_muteValueCallbacks(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "muteValueCallbacks";
  }

  string getDescription()
  {
    return "Disables the propagation of every new advertised value to the parent hub.";
  }

  string getMoreInfo()
  {
    return "You can use this function to save bandwidth and CPU on computers with limited resources, or to prevent unwanted invocations of the HTTP callback. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->muteValueCallbacks();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Re-enables the propagation of every new advertised value to the parent hub.
 * This function reverts the effect of a previous call to muteValueCallbacks().
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @return YAPI.SUCCESS when the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_unmuteValueCallbacks : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_unmuteValueCallbacks(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "unmuteValueCallbacks";
  }

  string getDescription()
  {
    return "Re-enables the propagation of every new advertised value to the parent hub.";
  }

  string getMoreInfo()
  {
    return "This function reverts the effect of a previous call to muteValueCallbacks(). Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->unmuteValueCallbacks();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Indicates whether changes to the function are prohibited or allowed.
 * Returns true if the function is blocked by an admin password
 * or if the function is not available.
 *
 * @return true if the function is write-protected or not online.
 */
class apifun_Sdi12Port_isReadOnly : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_isReadOnly(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "isReadOnly";
  }

  string getDescription()
  {
    return "Indicates whether changes to the function are prohibited or allowed.";
  }

  string getMoreInfo()
  {
    return "Returns true if the function is blocked by an admin password or if the function is not available.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        bool value = (*list)[i]->isReadOnly();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Returns the serial number of the module, as set by the factory.
 *
 * @return a string corresponding to the serial number of the module, as set by the factory.
 *
 * On failure, throws an exception or returns YFunction.SERIALNUMBER_INVALID.
 */
class apifun_Sdi12Port_get_serialNumber : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_get_serialNumber(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_serialNumber";
  }

  string getDescription()
  {
    return "Returns the serial number of the module, as set by the factory.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->get_serialNumber();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Reads a single line (or message) from the receive buffer, starting at current stream position.
 * This function is intended to be used when the serial port is configured for a message protocol,
 * such as 'Line' mode or frame protocols.
 *
 * If data at current stream position is not available anymore in the receive buffer,
 * the function returns the oldest available line and moves the stream position just after.
 * If no new full line is received, the function returns an empty line.
 *
 * @return a string with a single line of text
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_readLine : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_readLine(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readLine";
  }

  string getDescription()
  {
    return "Reads a single line (or message) from the receive buffer, starting at current stream position.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for a message protocol, such as 'Line' mode or frame protocols.\nIf data at current stream position is not available anymore in the receive buffer, the function returns the oldest available line and moves the stream position just after. If no new full line is received, the function returns an empty line.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->readLine();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Searches for incoming messages in the serial port receive buffer matching a given pattern,
 * starting at current position. This function will only compare and return printable characters
 * in the message strings. Binary protocols are handled as hexadecimal strings.
 *
 * The search returns all messages matching the expression provided as argument in the buffer.
 * If no matching message is found, the search waits for one up to the specified maximum timeout
 * (in milliseconds).
 *
 * @param pattern : a limited regular expression describing the expected message format,
 *         or an empty string if all messages should be returned (no filtering).
 *         When using binary protocols, the format applies to the hexadecimal
 *         representation of the message.
 * @param maxWait : the maximum number of milliseconds to wait for a message if none is found
 *         in the receive buffer.
 *
 * @return an array of strings containing the messages found, if any.
 *         Binary messages are converted to hexadecimal representation.
 *
 * On failure, throws an exception or returns an empty array.
 */
class apifun_Sdi12Port_readMessages : public YapiCommand /* arguments: pattern maxWait */
{
public:
  apifun_Sdi12Port_readMessages(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readMessages";
  }

  string getDescription()
  {
    return "Searches for incoming messages in the serial port receive buffer matching a given pattern,starting at current position.";
  }

  string getMoreInfo()
  {
    return "This function will only compare and return printable characters in the message strings. Binary protocols are handled as hexadecimal strings.\nThe search returns all messages matching the expression provided as argument in the buffer. If no matching message is found, the search waits for one up to the specified maximum timeout (in milliseconds).";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "pattern", "a limited regular expression describing the expected message format, or an empty string if all messages should be returned (no filtering). When using binary protocols, the format applies to the hexadecimal representation of the message.", "_STRING", false));
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum number of milliseconds to wait for a message if none is found in the receive buffer.", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<string> value = (*list)[i]->readMessages((*args)[0]->get_stringValue(),
                                                        (int)(*args)[1]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Changes the current internal stream position to the specified value. This function
 * does not affect the device, it only changes the value stored in the API object
 * for the next read operations.
 *
 * @param absPos : the absolute position index for next read operations.
 *
 * @return nothing.
 */
class apifun_Sdi12Port_read_seek : public YapiCommand /* arguments: absPos */
{
public:
  apifun_Sdi12Port_read_seek(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "read_seek";
  }

  string getDescription()
  {
    return "Changes the current internal stream position to the specified value.";
  }

  string getMoreInfo()
  {
    return "This function does not affect the device, it only changes the value stored in the API object for the next read operations.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "absPos", "the absolute position index for next read operations.", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->read_seek((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Returns the current absolute stream position pointer of the API object.
 *
 * @return the absolute position index for next read operations.
 */
class apifun_Sdi12Port_read_tell : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_read_tell(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "read_tell";
  }

  string getDescription()
  {
    return "Returns the current absolute stream position pointer of the API object.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->read_tell();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Returns the number of bytes available to read in the input buffer starting from the
 * current absolute stream position pointer of the API object.
 *
 * @return the number of bytes available to read
 */
class apifun_Sdi12Port_read_avail : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_read_avail(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "read_avail";
  }

  string getDescription()
  {
    return "Returns the number of bytes available to read in the input buffer starting from thecurrent absolute stream position pointer of the API object.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->read_avail();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a text line query to the serial port, and reads the reply, if any.
 * This function is intended to be used when the serial port is configured for 'Line' protocol.
 *
 * @param query : the line query to send (without CR/LF)
 * @param maxWait : the maximum number of milliseconds to wait for a reply.
 *
 * @return the next text line received after sending the text query, as a string.
 *         Additional lines can be obtained by calling readLine or readMessages.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_queryLine : public YapiCommand /* arguments: query maxWait */
{
public:
  apifun_Sdi12Port_queryLine(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "queryLine";
  }

  string getDescription()
  {
    return "Sends a text line query to the serial port, and reads the reply, if any.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'Line' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "query", "the line query to send (without CR/LF)", "_STRING", false));
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum number of milliseconds to wait for a reply.", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->queryLine((*args)[0]->get_stringValue(),
                                             (int)(*args)[1]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a binary message to the serial port, and reads the reply, if any.
 * This function is intended to be used when the serial port is configured for
 * Frame-based protocol.
 *
 * @param hexString : the message to send, coded in hexadecimal
 * @param maxWait : the maximum number of milliseconds to wait for a reply.
 *
 * @return the next frame received after sending the message, as a hex string.
 *         Additional frames can be obtained by calling readHex or readMessages.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_queryHex : public YapiCommand /* arguments: hexString maxWait */
{
public:
  apifun_Sdi12Port_queryHex(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "queryHex";
  }

  string getDescription()
  {
    return "Sends a binary message to the serial port, and reads the reply, if any.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for Frame-based protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "hexString", "the message to send, coded in hexadecimal", "_STRING", false));
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum number of milliseconds to wait for a reply.", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->queryHex((*args)[0]->get_stringValue(),
                                            (int)(*args)[1]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Saves the job definition string (JSON data) into a job file.
 * The job file can be later enabled using selectJob().
 *
 * @param jobfile : name of the job file to save on the device filesystem
 * @param jsonDef : a string containing a JSON definition of the job
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_uploadJob : public YapiCommand /* arguments: jobfile jsonDef */
{
public:
  apifun_Sdi12Port_uploadJob(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "uploadJob";
  }

  string getDescription()
  {
    return "Saves the job definition string (JSON data) into a job file.";
  }

  string getMoreInfo()
  {
    return "The job file can be later enabled using selectJob().";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "jobfile", "name of the job file to save on the device filesystem", "_STRING", false));
    res->push_back(new ArgumentDesc(STRING_ARG, "jsonDef", "a string containing a JSON definition of the job", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    value = value + " "+ (*args)[1]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->uploadJob((*args)[0]->get_stringValue(),
                              (*args)[1]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Load and start processing the specified job file. The file must have
 * been previously created using the user interface or uploaded on the
 * device filesystem using the uploadJob() function.
 *
 * @param jobfile : name of the job file (on the device filesystem)
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_selectJob : public YapiCommand /* arguments: jobfile */
{
public:
  apifun_Sdi12Port_selectJob(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "selectJob";
  }

  string getDescription()
  {
    return "Load and start processing the specified job file.";
  }

  string getMoreInfo()
  {
    return "The file must have been previously created using the user interface or uploaded on the device filesystem using the uploadJob() function.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "jobfile", "name of the job file (on the device filesystem)", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->selectJob((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Clears the serial port buffer and resets counters to zero.
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_reset : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_reset(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "reset";
  }

  string getDescription()
  {
    return "Clears the serial port buffer and resets counters to zero.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->reset();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a single byte to the serial port.
 *
 * @param code : the byte to send
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_writeByte : public YapiCommand /* arguments: code */
{
public:
  apifun_Sdi12Port_writeByte(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "writeByte";
  }

  string getDescription()
  {
    return "Sends a single byte to the serial port.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "code", "the byte to send", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->writeByte((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends an ASCII string to the serial port, as is.
 *
 * @param text : the text string to send
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_writeStr : public YapiCommand /* arguments: text */
{
public:
  apifun_Sdi12Port_writeStr(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "writeStr";
  }

  string getDescription()
  {
    return "Sends an ASCII string to the serial port, as is.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "text", "the text string to send", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->writeStr((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a binary buffer to the serial port, as is.
 *
 * @param buff : the binary buffer to send
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_writeBin : public YapiCommand /* arguments: buff */
{
public:
  apifun_Sdi12Port_writeBin(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "writeBin";
  }

  string getDescription()
  {
    return "Sends a binary buffer to the serial port, as is.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(BIN_ARG, "buff", "the binary buffer to send", "_BIN", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->writeBin((*args)[0]->get_binValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a byte sequence (provided as a list of bytes) to the serial port.
 *
 * @param byteList : a list of byte codes
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_writeArray : public YapiCommand /* arguments: byteList */
{
public:
  apifun_Sdi12Port_writeArray(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "writeArray";
  }

  string getDescription()
  {
    return "Sends a byte sequence (provided as a list of bytes) to the serial port.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INTARR_ARG, "byteList", "a list of byte codes", "_INTARR", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->writeArray((*args)[0]->get_intArrValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a byte sequence (provided as a hexadecimal string) to the serial port.
 *
 * @param hexString : a string of hexadecimal byte codes
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_writeHex : public YapiCommand /* arguments: hexString */
{
public:
  apifun_Sdi12Port_writeHex(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "writeHex";
  }

  string getDescription()
  {
    return "Sends a byte sequence (provided as a hexadecimal string) to the serial port.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "hexString", "a string of hexadecimal byte codes", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->writeHex((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends an ASCII string to the serial port, followed by a line break (CR LF).
 *
 * @param text : the text string to send
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_writeLine : public YapiCommand /* arguments: text */
{
public:
  apifun_Sdi12Port_writeLine(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "writeLine";
  }

  string getDescription()
  {
    return "Sends an ASCII string to the serial port, followed by a line break (CR LF).";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "text", "the text string to send", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->writeLine((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Reads one byte from the receive buffer, starting at current stream position.
 * If data at current stream position is not available anymore in the receive buffer,
 * or if there is no data available yet, the function returns YAPI_NO_MORE_DATA.
 *
 * @return the next byte
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_readByte : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_readByte(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readByte";
  }

  string getDescription()
  {
    return "Reads one byte from the receive buffer, starting at current stream position.";
  }

  string getMoreInfo()
  {
    return "If data at current stream position is not available anymore in the receive buffer, or if there is no data available yet, the function returns YAPI_NO_MORE_DATA.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->readByte();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Reads data from the receive buffer as a string, starting at current stream position.
 * If data at current stream position is not available anymore in the receive buffer, the
 * function performs a short read.
 *
 * @param nChars : the maximum number of characters to read
 *
 * @return a string with receive buffer contents
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_readStr : public YapiCommand /* arguments: nChars */
{
public:
  apifun_Sdi12Port_readStr(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readStr";
  }

  string getDescription()
  {
    return "Reads data from the receive buffer as a string, starting at current stream position.";
  }

  string getMoreInfo()
  {
    return "If data at current stream position is not available anymore in the receive buffer, the function performs a short read.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "nChars", "the maximum number of characters to read", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->readStr((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Reads data from the receive buffer as a binary buffer, starting at current stream position.
 * If data at current stream position is not available anymore in the receive buffer, the
 * function performs a short read.
 *
 * @param nChars : the maximum number of bytes to read
 *
 * @return a binary object with receive buffer contents
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_readBin : public YapiCommand /* arguments: nChars */
{
public:
  apifun_Sdi12Port_readBin(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readBin";
  }

  string getDescription()
  {
    return "Reads data from the receive buffer as a binary buffer, starting at current stream position.";
  }

  string getMoreInfo()
  {
    return "If data at current stream position is not available anymore in the receive buffer, the function performs a short read.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "nChars", "the maximum number of bytes to read", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->readBin((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Reads data from the receive buffer as a list of bytes, starting at current stream position.
 * If data at current stream position is not available anymore in the receive buffer, the
 * function performs a short read.
 *
 * @param nChars : the maximum number of bytes to read
 *
 * @return a sequence of bytes with receive buffer contents
 *
 * On failure, throws an exception or returns an empty array.
 */
class apifun_Sdi12Port_readArray : public YapiCommand /* arguments: nChars */
{
public:
  apifun_Sdi12Port_readArray(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readArray";
  }

  string getDescription()
  {
    return "Reads data from the receive buffer as a list of bytes, starting at current stream position.";
  }

  string getMoreInfo()
  {
    return "If data at current stream position is not available anymore in the receive buffer, the function performs a short read.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "nChars", "the maximum number of bytes to read", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<int> value = (*list)[i]->readArray((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Reads data from the receive buffer as a hexadecimal string, starting at current stream position.
 * If data at current stream position is not available anymore in the receive buffer, the
 * function performs a short read.
 *
 * @param nBytes : the maximum number of bytes to read
 *
 * @return a string with receive buffer contents, encoded in hexadecimal
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_Sdi12Port_readHex : public YapiCommand /* arguments: nBytes */
{
public:
  apifun_Sdi12Port_readHex(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readHex";
  }

  string getDescription()
  {
    return "Reads data from the receive buffer as a hexadecimal string, starting at current stream position.";
  }

  string getMoreInfo()
  {
    return "If data at current stream position is not available anymore in the receive buffer, the function performs a short read.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "nBytes", "the maximum number of bytes to read", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->readHex((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a SDI-12 query to the bus, and reads the sensor immediate reply.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @param sensorAddr : the sensor address, as a string
 * @param cmd : the SDI12 query to send (without address and exclamation point)
 * @param maxWait : the maximum timeout to wait for a reply from sensor, in millisecond
 *
 * @return the reply returned by the sensor, without newline, as a string.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_querySdi12 : public YapiCommand /* arguments: sensorAddr cmd maxWait */
{
public:
  apifun_Sdi12Port_querySdi12(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "querySdi12";
  }

  string getDescription()
  {
    return "Sends a SDI-12 query to the bus, and reads the sensor immediate reply.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "sensorAddr", "the sensor address, as a string", "_STRING", false));
    res->push_back(new ArgumentDesc(STRING_ARG, "cmd", "the SDI12 query to send (without address and exclamation point)", "_STRING", false));
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum timeout to wait for a reply from sensor, in millisecond", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->querySdi12((*args)[0]->get_stringValue(),
                                              (*args)[1]->get_stringValue(),
                                              (int)(*args)[2]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a discovery command to the bus, and reads the sensor information reply.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 * This function work when only one sensor is connected.
 *
 * @return the reply returned by the sensor, as a YSdi12SensorInfo object.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_discoverSingleSensor : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_discoverSingleSensor(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "discoverSingleSensor";
  }

  string getDescription()
  {
    return "Sends a discovery command to the bus, and reads the sensor information reply.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol. This function work when only one sensor is connected.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        YSdi12SensorInfo value = (*list)[i]->discoverSingleSensor();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a discovery command to the bus, and reads all sensors information reply.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @return all the information from every connected sensor, as an array of YSdi12SensorInfo object.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_discoverAllSensors : public YapiCommand /* arguments: */
{
public:
  apifun_Sdi12Port_discoverAllSensors(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "discoverAllSensors";
  }

  string getDescription()
  {
    return "Sends a discovery command to the bus, and reads all sensors information reply.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<YSdi12SensorInfo> value = (*list)[i]->discoverAllSensors();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a mesurement command to the SDI-12 bus, and reads the sensor immediate reply.
 * The supported commands are:
 * M: Measurement start control
 * M1...M9: Additional measurement start command
 * D: Measurement reading control
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @param sensorAddr : the sensor address, as a string
 * @param measCmd : the SDI12 query to send (without address and exclamation point)
 * @param maxWait : the maximum timeout to wait for a reply from sensor, in millisecond
 *
 * @return the reply returned by the sensor, without newline, as a list of float.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_readSensor : public YapiCommand /* arguments: sensorAddr measCmd maxWait */
{
public:
  apifun_Sdi12Port_readSensor(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readSensor";
  }

  string getDescription()
  {
    return "Sends a mesurement command to the SDI-12 bus, and reads the sensor immediate reply.";
  }

  string getMoreInfo()
  {
    return "The supported commands are: M: Measurement start control M1...M9: Additional measurement start command D: Measurement reading control This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "sensorAddr", "the sensor address, as a string", "_STRING", false));
    res->push_back(new ArgumentDesc(STRING_ARG, "measCmd", "the SDI12 query to send (without address and exclamation point)", "_STRING", false));
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum timeout to wait for a reply from sensor, in millisecond", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<double> value = (*list)[i]->readSensor((*args)[0]->get_stringValue(),
                                                      (*args)[1]->get_stringValue(),
                                                      (int)(*args)[2]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Changes the address of the selected sensor, and returns the sensor information with the new address.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @param oldAddress : Actual sensor address, as a string
 * @param newAddress : New sensor address, as a string
 *
 * @return the sensor address and information , as a YSdi12SensorInfo object.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_changeAddress : public YapiCommand /* arguments: oldAddress newAddress */
{
public:
  apifun_Sdi12Port_changeAddress(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "changeAddress";
  }

  string getDescription()
  {
    return "Changes the address of the selected sensor, and returns the sensor information with the new address.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "oldAddress", "Actual sensor address, as a string", "_STRING", false));
    res->push_back(new ArgumentDesc(STRING_ARG, "newAddress", "New sensor address, as a string", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        YSdi12SensorInfo value = (*list)[i]->changeAddress((*args)[0]->get_stringValue(),
                                                           (*args)[1]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a information command to the bus, and reads sensors information selected.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @param sensorAddr : Sensor address, as a string
 *
 * @return the reply returned by the sensor, as a YSdi12Port object.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_getSensorInformation : public YapiCommand /* arguments: sensorAddr */
{
public:
  apifun_Sdi12Port_getSensorInformation(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "getSensorInformation";
  }

  string getDescription()
  {
    return "Sends a information command to the bus, and reads sensors information selected.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "sensorAddr", "Sensor address, as a string", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        YSdi12SensorInfo value = (*list)[i]->getSensorInformation((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a information command to the bus, and reads sensors information selected.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @param sensorAddr : Sensor address, as a string
 *
 * @return the reply returned by the sensor, as a YSdi12Port object.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_readConcurrentMeasurements : public YapiCommand /* arguments: sensorAddr */
{
public:
  apifun_Sdi12Port_readConcurrentMeasurements(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "readConcurrentMeasurements";
  }

  string getDescription()
  {
    return "Sends a information command to the bus, and reads sensors information selected.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "sensorAddr", "Sensor address, as a string", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<double> value = (*list)[i]->readConcurrentMeasurements((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Sends a information command to the bus, and reads sensors information selected.
 * This function is intended to be used when the serial port is configured for 'SDI-12' protocol.
 *
 * @param sensorAddr : Sensor address, as a string
 *
 * @return the reply returned by the sensor, as a YSdi12Port object.
 *
 * On failure, throws an exception or returns an empty string.
 */
class apifun_Sdi12Port_requestConcurrentMeasurements : public YapiCommand /* arguments: sensorAddr */
{
public:
  apifun_Sdi12Port_requestConcurrentMeasurements(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "requestConcurrentMeasurements";
  }

  string getDescription()
  {
    return "Sends a information command to the bus, and reads sensors information selected.";
  }

  string getMoreInfo()
  {
    return "This function is intended to be used when the serial port is configured for 'SDI-12' protocol.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "sensorAddr", "Sensor address, as a string", "_STRING", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    value = value +  (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->requestConcurrentMeasurements((*args)[0]->get_stringValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Retrieves messages (both direction) in the SDI12 port buffer, starting at current position.
 *
 * If no message is found, the search waits for one up to the specified maximum timeout
 * (in milliseconds).
 *
 * @param maxWait : the maximum number of milliseconds to wait for a message if none is found
 *         in the receive buffer.
 * @param maxMsg : the maximum number of messages to be returned by the function; up to 254.
 *
 * @return an array of YSdi12SnoopingRecord objects containing the messages found, if any.
 *
 * On failure, throws an exception or returns an empty array.
 */
class apifun_Sdi12Port_snoopMessagesEx : public YapiCommand /* arguments: maxWait maxMsg */
{
public:
  apifun_Sdi12Port_snoopMessagesEx(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "snoopMessagesEx";
  }

  string getDescription()
  {
    return "Retrieves messages (both direction) in the SDI12 port buffer, starting at current position.";
  }

  string getMoreInfo()
  {
    return "If no message is found, the search waits for one up to the specified maximum timeout (in milliseconds).";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum number of milliseconds to wait for a message if none is found in the receive buffer.", "_INT", false));
    res->push_back(new ArgumentDesc(INT_ARG, "maxMsg", "the maximum number of messages to be returned by the function; up to 254.", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<YSdi12SnoopingRecord> value = (*list)[i]->snoopMessagesEx((int)(*args)[0]->get_intValue(),
                                                                         (int)(*args)[1]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Retrieves messages (both direction) in the SDI12 port buffer, starting at current position.
 *
 * If no message is found, the search waits for one up to the specified maximum timeout
 * (in milliseconds).
 *
 * @param maxWait : the maximum number of milliseconds to wait for a message if none is found
 *         in the receive buffer.
 *
 * @return an array of YSdi12SnoopingRecord objects containing the messages found, if any.
 *
 * On failure, throws an exception or returns an empty array.
 */
class apifun_Sdi12Port_snoopMessages : public YapiCommand /* arguments: maxWait */
{
public:
  apifun_Sdi12Port_snoopMessages(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "snoopMessages";
  }

  string getDescription()
  {
    return "Retrieves messages (both direction) in the SDI12 port buffer, starting at current position.";
  }

  string getMoreInfo()
  {
    return "If no message is found, the search waits for one up to the specified maximum timeout (in milliseconds).";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "maxWait", "the maximum number of milliseconds to wait for a message if none is found in the receive buffer.", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YSdi12Port*>* list = enumerateTargets<YSdi12Port>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        vector<YSdi12SnoopingRecord> value = (*list)[i]->snoopMessages((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

//--- (end of generated code: YSdi12Port implementation)

//--- (generated code: YSdi12Port functions)
void YSdi12PortCmdLine::RegisterCommands(vector<YapiCommand*>* cmdList)
  {
    RegisterGenericFunctions<YSdi12Port>(this, cmdList);
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_logicalName(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_set_logicalName(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_advertisedValue(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_rxCount(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_txCount(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_errCount(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_rxMsgCount(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_txMsgCount(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_lastMsg(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_currentJob(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_set_currentJob(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_startupJob(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_set_startupJob(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_jobMaxTask(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_jobMaxSize(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_protocol(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_set_protocol(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_voltageLevel(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_set_voltageLevel(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_get_serialMode(this)));
    cmdList->push_back((YapiCommand*) (new Sdi12Port_set_serialMode(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_muteValueCallbacks(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_unmuteValueCallbacks(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_isReadOnly(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_get_serialNumber(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readLine(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readMessages(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_read_seek(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_read_tell(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_read_avail(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_queryLine(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_queryHex(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_uploadJob(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_selectJob(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_reset(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_writeByte(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_writeStr(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_writeBin(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_writeArray(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_writeHex(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_writeLine(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readByte(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readStr(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readBin(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readArray(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readHex(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_querySdi12(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_discoverSingleSensor(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_discoverAllSensors(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readSensor(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_changeAddress(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_getSensorInformation(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_readConcurrentMeasurements(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_requestConcurrentMeasurements(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_snoopMessagesEx(this)));
    cmdList->push_back((YapiCommand*) (new apifun_Sdi12Port_snoopMessages(this)));
  }

//--- (end of generated code: YSdi12Port functions)
