/*********************************************************************
 *
 *  $Id: svn_id $
 *
 *  Implements commands to handle InputCapture functions
 *
 *  - - - - - - - - - License information: - - - - - - - - -
 *
 *  Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
 *
 *  Yoctopuce Sarl (hereafter Licensor) grants to you a perpetual
 *  non-exclusive license to use, modify, copy and integrate this
 *  file into your software for the sole purpose of interfacing
 *  with Yoctopuce products.
 *
 *  You may reproduce and distribute copies of this file in
 *  source or object form, as long as the sole purpose of this
 *  code is to interface with Yoctopuce products. You must retain
 *  this notice in the distributed source file.
 *
 *  You should refer to Yoctopuce General Terms and Conditions
 *  for additional information regarding your rights and
 *  obligations.
 *
 *  THE SOFTWARE AND DOCUMENTATION ARE PROVIDED 'AS IS' WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 *  WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS
 *  FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
 *  EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA,
 *  COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR
 *  SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
 *  LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
 *  CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
 *  BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
 *  WARRANTY, OR OTHERWISE.
 *
 *********************************************************************/


#define _CRT_SECURE_NO_DEPRECATE
#include <stdio.h>
#include "YInputCapture.h"
#include "yocto_api.h"
#include "yocto_inputcapture.h"

using namespace std;

//--- (generated code: YInputCapture definitions)

static const char *enumCaptureTypeAll[] = {
    "NONE",
    "TIMED",
    "V_MAX",
    "V_MIN",
    "I_MAX",
    "I_MIN",
    "P_MAX",
    "P_MIN",
    "V_AVG_MAX",
    "V_AVG_MIN",
    "V_RMS_MAX",
    "V_RMS_MIN",
    "I_AVG_MAX",
    "I_AVG_MIN",
    "I_RMS_MAX",
    "I_RMS_MIN",
    "P_AVG_MAX",
    "P_AVG_MIN",
    "PF_MIN",
    "DPF_MIN",
    NULL
};

//--- (end of generated code: YInputCapture definitions)


//--- (generated code: YInputCapture implementation)
bool   YInputCaptureCmdLine::isModule(void)      { return false; }
string YInputCaptureCmdLine::YFunctionName(void) { return "YInputCapture"; }

// type of logicalName is string (Text)
// type of advertisedValue is string (PubText)
// type of lastCaptureTime is s64 (Time)
// type of nSamples is int (UInt31)
// type of samplingRate is int (UInt31)
// type of captureType is int (CaptureTypeAll)
// type of condValue is double (MeasureVal)
// type of condAlign is int (Percent)
// type of captureTypeAtStartup is int (CaptureTypeAll)
// type of condValueAtStartup is double (MeasureVal)
/**
 * Returns the logical name of the instant snapshot trigger.
 *
 * @return a string corresponding to the logical name of the instant snapshot trigger
 *
 * On failure, throws an exception or returns YInputCapture.LOGICALNAME_INVALID.
 */
class InputCapture_get_logicalName : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_logicalName(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_logicalName";
  }

  string getDescription()
  {
    return "Returns the logical name of the instant snapshot trigger.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_logicalName();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the logical name of the instant snapshot trigger. You can use yCheckLogicalName()
 * prior to this call to make sure that your parameter is valid.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @param newval : a string corresponding to the logical name of the instant snapshot trigger
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_logicalName : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_logicalName(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_logicalName";
  }

  string getDescription()
  {
    return "Changes the logical name of the instant snapshot trigger.";
  }

  string getMoreInfo()
  {
    return "You can use yCheckLogicalName() prior to this call to make sure that your parameter is valid. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(STRING_ARG, "newval", "a string corresponding to the logical name of the instant snapshot trigger", "_LOGICAL", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    if (!YAPI::CheckLogicalName((*args)[0]->get_stringValue())) {
        throw std::string("Invalid name :" + (*args)[0]->get_stringValue());
    }
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_logicalName(string((*args)[0]->get_stringValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns a short string representing the current state of the instant snapshot trigger.
 *
 * @return a string corresponding to a short string representing the current state of the instant snapshot trigger
 *
 * On failure, throws an exception or returns YInputCapture.ADVERTISEDVALUE_INVALID.
 */
class InputCapture_get_advertisedValue : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_advertisedValue(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_advertisedValue";
  }

  string getDescription()
  {
    return "Returns a short string representing the current state of the instant snapshot trigger.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string attrval = (*list)[i]->get_advertisedValue();
        string strval =  attrval;
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the number of elapsed milliseconds between the module power on
 * and the last capture (time of trigger), or zero if no capture has been done.
 *
 * @return an integer corresponding to the number of elapsed milliseconds between the module power on
 *         and the last capture (time of trigger), or zero if no capture has been done
 *
 * On failure, throws an exception or returns YInputCapture.LASTCAPTURETIME_INVALID.
 */
class InputCapture_get_lastCaptureTime : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_lastCaptureTime(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_lastCaptureTime";
  }

  string getDescription()
  {
    return "Returns the number of elapsed milliseconds between the module power onand the last capture (time of trigger), or zero if no capture has been done.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        s64 attrval = (*list)[i]->get_lastCaptureTime();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%u [ms]", (u32)attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the number of samples that will be captured.
 *
 * @return an integer corresponding to the number of samples that will be captured
 *
 * On failure, throws an exception or returns YInputCapture.NSAMPLES_INVALID.
 */
class InputCapture_get_nSamples : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_nSamples(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_nSamples";
  }

  string getDescription()
  {
    return "Returns the number of samples that will be captured.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_nSamples();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the type of automatic conditional capture.
 * The maximum number of samples depends on the device memory.
 *
 * If you want the change to be kept after a device reboot,
 * make sure  to call the matching module saveToFlash().
 *
 * @param newval : an integer corresponding to the type of automatic conditional capture
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_nSamples : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_nSamples(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_nSamples";
  }

  string getDescription()
  {
    return "Changes the type of automatic conditional capture.";
  }

  string getMoreInfo()
  {
    return "The maximum number of samples depends on the device memory.\nIf you want the change to be kept after a device reboot, make sure to call the matching module saveToFlash().";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "newval", "an integer corresponding to the type of automatic conditional capture", "_INT", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_nSamples(int((*args)[0]->get_intValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the sampling frequency, in Hz.
 *
 * @return an integer corresponding to the sampling frequency, in Hz
 *
 * On failure, throws an exception or returns YInputCapture.SAMPLINGRATE_INVALID.
 */
class InputCapture_get_samplingRate : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_samplingRate(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_samplingRate";
  }

  string getDescription()
  {
    return "Returns the sampling frequency, in Hz.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_samplingRate();
        char buf[32]; SAFE_SPRINTF(buf, 32, "%d", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the type of automatic conditional capture.
 *
 * @return a value among YInputCapture.CAPTURETYPE_NONE, YInputCapture.CAPTURETYPE_TIMED,
 * YInputCapture.CAPTURETYPE_V_MAX, YInputCapture.CAPTURETYPE_V_MIN, YInputCapture.CAPTURETYPE_I_MAX,
 * YInputCapture.CAPTURETYPE_I_MIN, YInputCapture.CAPTURETYPE_P_MAX, YInputCapture.CAPTURETYPE_P_MIN,
 * YInputCapture.CAPTURETYPE_V_AVG_MAX, YInputCapture.CAPTURETYPE_V_AVG_MIN,
 * YInputCapture.CAPTURETYPE_V_RMS_MAX, YInputCapture.CAPTURETYPE_V_RMS_MIN,
 * YInputCapture.CAPTURETYPE_I_AVG_MAX, YInputCapture.CAPTURETYPE_I_AVG_MIN,
 * YInputCapture.CAPTURETYPE_I_RMS_MAX, YInputCapture.CAPTURETYPE_I_RMS_MIN,
 * YInputCapture.CAPTURETYPE_P_AVG_MAX, YInputCapture.CAPTURETYPE_P_AVG_MIN,
 * YInputCapture.CAPTURETYPE_PF_MIN and YInputCapture.CAPTURETYPE_DPF_MIN corresponding to the type of
 * automatic conditional capture
 *
 * On failure, throws an exception or returns YInputCapture.CAPTURETYPE_INVALID.
 */
class InputCapture_get_captureType : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_captureType(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_captureType";
  }

  string getDescription()
  {
    return "Returns the type of automatic conditional capture.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_captureType();
        string strval =  enumString(attrval,enumCaptureTypeAll);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the type of automatic conditional capture.
 *
 * @param newval : a value among YInputCapture.CAPTURETYPE_NONE, YInputCapture.CAPTURETYPE_TIMED,
 * YInputCapture.CAPTURETYPE_V_MAX, YInputCapture.CAPTURETYPE_V_MIN, YInputCapture.CAPTURETYPE_I_MAX,
 * YInputCapture.CAPTURETYPE_I_MIN, YInputCapture.CAPTURETYPE_P_MAX, YInputCapture.CAPTURETYPE_P_MIN,
 * YInputCapture.CAPTURETYPE_V_AVG_MAX, YInputCapture.CAPTURETYPE_V_AVG_MIN,
 * YInputCapture.CAPTURETYPE_V_RMS_MAX, YInputCapture.CAPTURETYPE_V_RMS_MIN,
 * YInputCapture.CAPTURETYPE_I_AVG_MAX, YInputCapture.CAPTURETYPE_I_AVG_MIN,
 * YInputCapture.CAPTURETYPE_I_RMS_MAX, YInputCapture.CAPTURETYPE_I_RMS_MIN,
 * YInputCapture.CAPTURETYPE_P_AVG_MAX, YInputCapture.CAPTURETYPE_P_AVG_MIN,
 * YInputCapture.CAPTURETYPE_PF_MIN and YInputCapture.CAPTURETYPE_DPF_MIN corresponding to the type of
 * automatic conditional capture
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_captureType : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_captureType(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_captureType";
  }

  string getDescription()
  {
    return "Changes the type of automatic conditional capture.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "newval", "a value among NONE, TIMED, V_MAX, V_MIN, I_MAX, I_MIN, P_MAX, P_MIN, V_AVG_MAX, V_AVG_MIN, V_RMS_MAX, V_RMS_MIN, I_AVG_MAX, I_AVG_MIN, I_RMS_MAX, I_RMS_MIN, P_AVG_MAX, P_AVG_MIN, PF_MIN and DPF_MIN corresponding to the type of automatic conditional capture", "NONE=0,TIMED=1,V_MAX=2,V_MIN=3,I_MAX=4,I_MIN=5,P_MAX=6,P_MIN=7,V_AVG_MAX=8,V_AVG_MIN=9,V_RMS_MAX=10,V_RMS_MIN=11,I_AVG_MAX=12,I_AVG_MIN=13,I_RMS_MAX=14,I_RMS_MIN=15,P_AVG_MAX=16,P_AVG_MIN=17,PF_MIN=18,DPF_MIN=19", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_captureType(Y_CAPTURETYPE_enum((*args)[0]->get_intValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Changes current threshold value for automatic conditional capture.
 *
 * @param newval : a floating point number corresponding to current threshold value for automatic
 * conditional capture
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_condValue : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_condValue(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_condValue";
  }

  string getDescription()
  {
    return "Changes current threshold value for automatic conditional capture.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(DOUBLE_ARG, "newval", "a floating point number corresponding to current threshold value for automatic conditional capture", "_DOUBLE", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_condValue(double((*args)[0]->get_doubleValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns current threshold value for automatic conditional capture.
 *
 * @return a floating point number corresponding to current threshold value for automatic conditional capture
 *
 * On failure, throws an exception or returns YInputCapture.CONDVALUE_INVALID.
 */
class InputCapture_get_condValue : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_condValue(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_condValue";
  }

  string getDescription()
  {
    return "Returns current threshold value for automatic conditional capture.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        double attrval = (*list)[i]->get_condValue();
        char buf[32]; SAFE_SPRINTF(buf,32,"%.3f",attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Returns the relative position of the trigger event within the capture window.
 * When the value is 50%, the capture is centered on the event.
 *
 * @return an integer corresponding to the relative position of the trigger event within the capture window
 *
 * On failure, throws an exception or returns YInputCapture.CONDALIGN_INVALID.
 */
class InputCapture_get_condAlign : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_condAlign(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_condAlign";
  }

  string getDescription()
  {
    return "Returns the relative position of the trigger event within the capture window.";
  }

  string getMoreInfo()
  {
    return "When the value is 50%, the capture is centered on the event.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_condAlign();
        char buf[32]; SAFE_SPRINTF(buf, 32,"%u%%", attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the relative position of the trigger event within the capture window.
 * The new value must be between 10% (on the left) and 90% (on the right).
 * When the value is 50%, the capture is centered on the event.
 *
 * If you want the change to be kept after a device reboot,
 * make sure  to call the matching module saveToFlash().
 *
 * @param newval : an integer corresponding to the relative position of the trigger event within the capture window
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_condAlign : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_condAlign(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_condAlign";
  }

  string getDescription()
  {
    return "Changes the relative position of the trigger event within the capture window.";
  }

  string getMoreInfo()
  {
    return "The new value must be between 10% (on the left) and 90% (on the right). When the value is 50%, the capture is centered on the event.\nIf you want the change to be kept after a device reboot, make sure to call the matching module saveToFlash().";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "newval", "an integer corresponding to the relative position of the trigger event within the capture window", "_INT", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_condAlign(int((*args)[0]->get_intValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the type of automatic conditional capture
 * applied at device power on.
 *
 * @return a value among YInputCapture.CAPTURETYPEATSTARTUP_NONE,
 * YInputCapture.CAPTURETYPEATSTARTUP_TIMED, YInputCapture.CAPTURETYPEATSTARTUP_V_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_V_MIN, YInputCapture.CAPTURETYPEATSTARTUP_I_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_I_MIN, YInputCapture.CAPTURETYPEATSTARTUP_P_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_P_MIN, YInputCapture.CAPTURETYPEATSTARTUP_V_AVG_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_V_AVG_MIN, YInputCapture.CAPTURETYPEATSTARTUP_V_RMS_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_V_RMS_MIN, YInputCapture.CAPTURETYPEATSTARTUP_I_AVG_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_I_AVG_MIN, YInputCapture.CAPTURETYPEATSTARTUP_I_RMS_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_I_RMS_MIN, YInputCapture.CAPTURETYPEATSTARTUP_P_AVG_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_P_AVG_MIN, YInputCapture.CAPTURETYPEATSTARTUP_PF_MIN and
 * YInputCapture.CAPTURETYPEATSTARTUP_DPF_MIN corresponding to the type of automatic conditional capture
 *         applied at device power on
 *
 * On failure, throws an exception or returns YInputCapture.CAPTURETYPEATSTARTUP_INVALID.
 */
class InputCapture_get_captureTypeAtStartup : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_captureTypeAtStartup(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_captureTypeAtStartup";
  }

  string getDescription()
  {
    return "Returns the type of automatic conditional captureapplied at device power on.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        int attrval = (*list)[i]->get_captureTypeAtStartup();
        string strval =  enumString(attrval,enumCaptureTypeAll);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

/**
 * Changes the type of automatic conditional capture
 * applied at device power on.
 *
 * If you want the change to be kept after a device reboot,
 * make sure  to call the matching module saveToFlash().
 *
 * @param newval : a value among YInputCapture.CAPTURETYPEATSTARTUP_NONE,
 * YInputCapture.CAPTURETYPEATSTARTUP_TIMED, YInputCapture.CAPTURETYPEATSTARTUP_V_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_V_MIN, YInputCapture.CAPTURETYPEATSTARTUP_I_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_I_MIN, YInputCapture.CAPTURETYPEATSTARTUP_P_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_P_MIN, YInputCapture.CAPTURETYPEATSTARTUP_V_AVG_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_V_AVG_MIN, YInputCapture.CAPTURETYPEATSTARTUP_V_RMS_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_V_RMS_MIN, YInputCapture.CAPTURETYPEATSTARTUP_I_AVG_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_I_AVG_MIN, YInputCapture.CAPTURETYPEATSTARTUP_I_RMS_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_I_RMS_MIN, YInputCapture.CAPTURETYPEATSTARTUP_P_AVG_MAX,
 * YInputCapture.CAPTURETYPEATSTARTUP_P_AVG_MIN, YInputCapture.CAPTURETYPEATSTARTUP_PF_MIN and
 * YInputCapture.CAPTURETYPEATSTARTUP_DPF_MIN corresponding to the type of automatic conditional capture
 *         applied at device power on
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_captureTypeAtStartup : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_captureTypeAtStartup(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_captureTypeAtStartup";
  }

  string getDescription()
  {
    return "Changes the type of automatic conditional captureapplied at device power on.";
  }

  string getMoreInfo()
  {
    return "If you want the change to be kept after a device reboot, make sure to call the matching module saveToFlash().";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "newval", "a value among NONE, TIMED, V_MAX, V_MIN, I_MAX, I_MIN, P_MAX, P_MIN, V_AVG_MAX, V_AVG_MIN, V_RMS_MAX, V_RMS_MIN, I_AVG_MAX, I_AVG_MIN, I_RMS_MAX, I_RMS_MIN, P_AVG_MAX, P_AVG_MIN, PF_MIN and DPF_MIN corresponding to the type of automatic conditional capture applied at device power on", "NONE=0,TIMED=1,V_MAX=2,V_MIN=3,I_MAX=4,I_MIN=5,P_MAX=6,P_MIN=7,V_AVG_MAX=8,V_AVG_MIN=9,V_RMS_MAX=10,V_RMS_MIN=11,I_AVG_MAX=12,I_AVG_MIN=13,I_RMS_MAX=14,I_RMS_MIN=15,P_AVG_MAX=16,P_AVG_MIN=17,PF_MIN=18,DPF_MIN=19", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_captureTypeAtStartup(Y_CAPTURETYPEATSTARTUP_enum((*args)[0]->get_intValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Changes current threshold value for automatic conditional
 * capture applied at device power on.
 *
 * If you want the change to be kept after a device reboot,
 * make sure  to call the matching module saveToFlash().
 *
 * @param newval : a floating point number corresponding to current threshold value for automatic conditional
 *         capture applied at device power on
 *
 * @return YAPI.SUCCESS if the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class InputCapture_set_condValueAtStartup : public YapiCommand /* arguments: newval */
{
public:
  InputCapture_set_condValueAtStartup(YFunctionCmdLine *function):YapiCommand(function){}
  string getName()
  {
    return "set_condValueAtStartup";
  }

  string getDescription()
  {
    return "Changes current threshold value for automatic conditionalcapture applied at device power on.";
  }

  string getMoreInfo()
  {
    return "If you want the change to be kept after a device reboot, make sure to call the matching module saveToFlash().";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(DOUBLE_ARG, "newval", "a floating point number corresponding to current threshold value for automatic conditional capture applied at device power on", "_DOUBLE", false));
    return res;
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = (*args)[0]->to_str();
    for (i = 0; i < list->size(); i++) {
        (*list)[i]->set_condValueAtStartup(double((*args)[0]->get_doubleValue()));
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
    }
  }
};

/**
 * Returns the threshold value for automatic conditional
 * capture applied at device power on.
 *
 * @return a floating point number corresponding to the threshold value for automatic conditional
 *         capture applied at device power on
 *
 * On failure, throws an exception or returns YInputCapture.CONDVALUEATSTARTUP_INVALID.
 */
class InputCapture_get_condValueAtStartup : public YapiCommand /* arguments: */
{
public:
  InputCapture_get_condValueAtStartup(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_condValueAtStartup";
  }

  string getDescription()
  {
    return "Returns the threshold value for automatic conditionalcapture applied at device power on.";
  }

  void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches )
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        double attrval = (*list)[i]->get_condValueAtStartup();
        char buf[32]; SAFE_SPRINTF(buf,32,"%.3f",attrval); string strval =  string(buf);
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), strval, true);
      }
  }
};

// type of valueCallbackInputCapture is YInputCaptureValueCallback* (YInputCaptureValueCallback)
/**
 * Disables the propagation of every new advertised value to the parent hub.
 * You can use this function to save bandwidth and CPU on computers with limited
 * resources, or to prevent unwanted invocations of the HTTP callback.
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @return YAPI.SUCCESS when the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_InputCapture_muteValueCallbacks : public YapiCommand /* arguments: */
{
public:
  apifun_InputCapture_muteValueCallbacks(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "muteValueCallbacks";
  }

  string getDescription()
  {
    return "Disables the propagation of every new advertised value to the parent hub.";
  }

  string getMoreInfo()
  {
    return "You can use this function to save bandwidth and CPU on computers with limited resources, or to prevent unwanted invocations of the HTTP callback. Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->muteValueCallbacks();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Re-enables the propagation of every new advertised value to the parent hub.
 * This function reverts the effect of a previous call to muteValueCallbacks().
 * Remember to call the saveToFlash() method of the module if the
 * modification must be kept.
 *
 * @return YAPI.SUCCESS when the call succeeds.
 *
 * On failure, throws an exception or returns a negative error code.
 */
class apifun_InputCapture_unmuteValueCallbacks : public YapiCommand /* arguments: */
{
public:
  apifun_InputCapture_unmuteValueCallbacks(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "unmuteValueCallbacks";
  }

  string getDescription()
  {
    return "Re-enables the propagation of every new advertised value to the parent hub.";
  }

  string getMoreInfo()
  {
    return "This function reverts the effect of a previous call to muteValueCallbacks(). Remember to call \"YModule {target} saveToFlash\" if the modification must be kept.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    string value = "";
    for (i = 0; i < list->size(); i++)
      {
        (*list)[i]->unmuteValueCallbacks();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Indicates whether changes to the function are prohibited or allowed.
 * Returns true if the function is blocked by an admin password
 * or if the function is not available.
 *
 * @return true if the function is write-protected or not online.
 */
class apifun_InputCapture_isReadOnly : public YapiCommand /* arguments: */
{
public:
  apifun_InputCapture_isReadOnly(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "isReadOnly";
  }

  string getDescription()
  {
    return "Indicates whether changes to the function are prohibited or allowed.";
  }

  string getMoreInfo()
  {
    return "Returns true if the function is blocked by an admin password or if the function is not available.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        bool value = (*list)[i]->isReadOnly();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Returns the serial number of the module, as set by the factory.
 *
 * @return a string corresponding to the serial number of the module, as set by the factory.
 *
 * On failure, throws an exception or returns YFunction.SERIALNUMBER_INVALID.
 */
class apifun_InputCapture_get_serialNumber : public YapiCommand /* arguments: */
{
public:
  apifun_InputCapture_get_serialNumber(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_serialNumber";
  }

  string getDescription()
  {
    return "Returns the serial number of the module, as set by the factory.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        string value = (*list)[i]->get_serialNumber();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Returns all details about the last automatic input capture.
 *
 * @return an YInputCaptureData object including
 *         data series and all related meta-information.
 *         On failure, throws an exception or returns an capture object.
 */
class apifun_InputCapture_get_lastCapture : public YapiCommand /* arguments: */
{
public:
  apifun_InputCapture_get_lastCapture(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_lastCapture";
  }

  string getDescription()
  {
    return "Returns all details about the last automatic input capture.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        YInputCaptureData value = (*list)[i]->get_lastCapture();
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

/**
 * Returns a new immediate capture of the device inputs.
 *
 * @param msDuration : duration of the capture window,
 *         in milliseconds (eg. between 20 and 1000).
 *
 * @return an YInputCaptureData object including
 *         data series for the specified duration.
 *         On failure, throws an exception or returns an capture object.
 */
class apifun_InputCapture_get_immediateCapture : public YapiCommand /* arguments: msDuration */
{
public:
  apifun_InputCapture_get_immediateCapture(YFunctionCmdLine *function):YapiCommand(function){}

  string getName()
  {
    return "get_immediateCapture";
  }

  string getDescription()
  {
    return "Returns a new immediate capture of the device inputs.";
  }

  vector<ArgumentDesc*>* getArgumentDesc()
  {
    vector<ArgumentDesc*>* res = new vector<ArgumentDesc*>();
    res->push_back(new ArgumentDesc(INT_ARG, "msDuration", "duration of the capture window, in milliseconds (eg. between 20 and 1000).", "_INT", false));
    return res;
  }

  virtual void execute(string target, vector<YModule*> *modulelist, string resultformat, vector<ArgumentDesc*>* args, vector<SwitchDesc*>* switches)
  {
    vector<YInputCapture*>* list = enumerateTargets<YInputCapture>(_function, target, modulelist);
    unsigned int i;
    for (i = 0; i < list->size(); i++)
      {
        YInputCaptureData value = (*list)[i]->get_immediateCapture((int)(*args)[0]->get_intValue());
        PrintResult(resultformat, this->getName(),YFunctionInfoCache((*list)[i]), value, true);
      }
  }
};

//--- (end of generated code: YInputCapture implementation)

//--- (generated code: YInputCapture functions)
void YInputCaptureCmdLine::RegisterCommands(vector<YapiCommand*>* cmdList)
  {
    RegisterGenericFunctions<YInputCapture>(this, cmdList);
    cmdList->push_back((YapiCommand*) (new InputCapture_get_logicalName(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_logicalName(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_advertisedValue(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_lastCaptureTime(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_nSamples(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_nSamples(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_samplingRate(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_captureType(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_captureType(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_condValue(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_condValue(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_condAlign(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_condAlign(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_captureTypeAtStartup(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_captureTypeAtStartup(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_set_condValueAtStartup(this)));
    cmdList->push_back((YapiCommand*) (new InputCapture_get_condValueAtStartup(this)));
    cmdList->push_back((YapiCommand*) (new apifun_InputCapture_muteValueCallbacks(this)));
    cmdList->push_back((YapiCommand*) (new apifun_InputCapture_unmuteValueCallbacks(this)));
    cmdList->push_back((YapiCommand*) (new apifun_InputCapture_isReadOnly(this)));
    cmdList->push_back((YapiCommand*) (new apifun_InputCapture_get_serialNumber(this)));
    cmdList->push_back((YapiCommand*) (new apifun_InputCapture_get_lastCapture(this)));
    cmdList->push_back((YapiCommand*) (new apifun_InputCapture_get_immediateCapture(this)));
  }

//--- (end of generated code: YInputCapture functions)
