import sys

from yocto_api import *
from yocto_colorled import *
from yocto_genericsensor import *
from yocto_wakeupmonitor import *

laststate = -1

def sendHubtoSleep():
  hub = YWakeUpMonitor.FindWakeUpMonitor("MailBox_Monitor")
  if hub.isOnline() :
      print('Hub will go to sleep is 5 seconds')
      hub.sleep(5)
  else:
      print('hub is offline')

# update the leds of the mail indicator
def SetMailIndicator(mailSensor,value):
  global laststate
  print('Updatind Leds, distance is '+ value)
  led1 = YColorLed.FindColorLed("Mail_Indicator.colorLed1")
  led2 = YColorLed.FindColorLed("Mail_Indicator.colorLed2")
  if not(led1.isOnline()):
    print('Leds ar offline')
    return

  if (float(value)<200):
    led1.set_rgbColor(0xFF0000)
    led2.set_rgbColor(0xFF0000)
    state = 1
  else:
    led1.set_rgbColor(0x00FF00)
    led2.set_rgbColor(0x00FF00)
    state = 0
  if (state!=laststate): sendHubtoSleep()
  laststate = state

#this function will be automatically called a new device comes online,
def deviceArrival(m):
    print('Device arrival : ' +  m.get_serialNumber())
    name = m.get_logicalName()
    if (name=='Mail_Sensor'):
         sensor = YGenericSensor.FindGenericSensor("Mail_Sensor.genericSensor1")
         value = sensor.get_currentValue()
         SetMailIndicator(sensor,"%f" % value)
         sendHubtoSleep()
         sensor.registerValueCallback(SetMailIndicator)


errmsg=YRefParam()

# No exception please
YAPI.DisableExceptions()

# Setup the API to use local USB devices
if YAPI.RegisterHub("usb", errmsg)!= YAPI.SUCCESS:
    sys.exit("init error"+errmsg.value)

# configure the API to use the mailbox hub if available
if YAPI.PreregisterHub("172.17.17.76", errmsg)!= YAPI.SUCCESS:
    sys.exit("init error"+errmsg.value)

# Each time a device com online, deviceArrival will be called
YAPI.RegisterDeviceArrivalCallback(deviceArrival)

print('Hit Ctrl-C to Stop ')

#nothing to do except waiting
while True:
    YAPI.UpdateDeviceList(errmsg) # traps plug/unplug events
    YAPI.Sleep(500, errmsg)   # traps others events


