import {PluginDispatcher, YoctopuceDeviceHandler} from "./common_code/yoctopuce_plugin.js"
import {StreamDeck_YRelayAction} from "./relay/relay_plugin.js"
import {StreamDeck_YCurrentLoopOutputSettingsAction} from "./currentLoopOutput/currentLoopOutput_plugin.js"
import {StreamDeck_YVoltageOutputSettingsAction} from "./voltageOutput/voltageOutput_plugin.js"
import {StreamDeck_YServoAction} from "./servo/servo_plugin.js"
import {StreamDeck_YWakeUpMonitorAction} from "./wakeUpMonitor/wakeUpMonitor_plugin";
import {StreamDeck_YBuzzerAction} from "./buzzer/buzzer_plugin";
import {StreamDeck_YColorLedClusterAction} from "./colorLedCluster/colorLedCluster_plugin";



export class YoctopucePlugin
{
   public static run(inPort: string, inPluginUUID: string, inRegisterEvent: any, inInfo:any)
   {
      // Yocto-Relay, Yocto-PowerReplay v1,v2,v3, Yocto-MaxiPowerRelay  etc....
      PluginDispatcher.registerActionClass(StreamDeck_YRelayAction.actionUUID, StreamDeck_YRelayAction);

      // Yocto-4-20mA-tx
      PluginDispatcher.registerActionClass(StreamDeck_YCurrentLoopOutputSettingsAction.actionUUID, StreamDeck_YCurrentLoopOutputSettingsAction)

      // Yocto-0-10v-tx
      PluginDispatcher.registerActionClass(StreamDeck_YVoltageOutputSettingsAction.actionUUID, StreamDeck_YVoltageOutputSettingsAction)

      // Servo
      PluginDispatcher.registerActionClass(StreamDeck_YServoAction.actionUUID, StreamDeck_YServoAction)

      // Wake-up monitor
      PluginDispatcher.registerActionClass(StreamDeck_YWakeUpMonitorAction.actionUUID, StreamDeck_YWakeUpMonitorAction)

      // Buzzer
      PluginDispatcher.registerActionClass(StreamDeck_YBuzzerAction.actionUUID, StreamDeck_YBuzzerAction)

      // ColorledCluster
      PluginDispatcher.registerActionClass(StreamDeck_YColorLedClusterAction.actionUUID, StreamDeck_YColorLedClusterAction)


      PluginDispatcher.run(inPort,inPluginUUID,inRegisterEvent,inInfo)
      YoctopuceDeviceHandler.run();
   }

}