
import { PI_handler } from '../common_code/yoctopuce_pi.js'
import { wakeUpMonitorSettings } from './wakeUpMonitor_settings.js'


export {wakeUpMonitorSettings}

export class YWakeUpMonitor_PI_handler extends PI_handler
{
    private _settings: wakeUpMonitorSettings;
    protected  get settings():wakeUpMonitorSettings {return this._settings}


    /*******************************
     * Constructor , load action's settings
     *******************************/
    constructor (inPort: string, inUUID: string, inRegisterEvent: any, inInfo:any,inActionInfo:string)
    {   super(inPort,inUUID,inRegisterEvent,inInfo,inActionInfo, new  wakeUpMonitorSettings()  )
        this._settings = this.deviceSettings as  wakeUpMonitorSettings;

    }

    /*******************************
     * called with action settings
     *******************************/

    protected didReceiveSettings(context: any,unknownSettings: any) :boolean
    {   if (!super.didReceiveSettings(context,unknownSettings )) return false;
        let action :HTMLSelectElement |null = document.getElementById("action") as HTMLSelectElement;
        let sleepDuration :HTMLInputElement |null = document.getElementById("sleepDuration") as HTMLInputElement;
        action.value = this.settings.action;
        sleepDuration.value = this.settings.sleepDuration.toString();
        let f : HTMLDivElement | null = document.getElementById("sleepDurationField") as HTMLDivElement;
        if (f) f.style.display = this.settings.action=="SLEEPFOR"?"":"none";
        return true
    }

    /*******************************
     * called when a Properties inpector field has changed
     *******************************/

    protected inspectorValueHasChanged(source: HTMLInputElement | HTMLSelectElement)
    {
        super.inspectorValueHasChanged(source);
        switch (source.id)
        {
            case "action" :
                this.settings.action = source.value;
                let it :HTMLElement | null = document.getElementById("sleepDurationField");
                if (it) it.style.display = this.settings.action=="SLEEPFOR"?"":"none";
                this.saveSettings(this.settings);
                break;
            case "sleepDuration" :
                this.settings.sleepDuration = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
        }
    }
}