
import { PI_handler } from '../common_code/yoctopuce_pi.js'
import { servoSettings } from './servo_settings.js'
export {servoSettings}

export class YServo_PI_handler extends PI_handler
{

    private _settings: servoSettings;
    protected  get settings():servoSettings {return this._settings}
    private targetMax   :HTMLInputElement |null =null;

    /*******************************
     * Constructor , load action's settings
     *******************************/

    constructor (inPort: string, inUUID: string, inRegisterEvent: any, inInfo:any,inActionInfo:string)
    {   super(inPort,inUUID,inRegisterEvent,inInfo,inActionInfo, new servoSettings()  )
        this._settings = this.deviceSettings as servoSettings;
        this.DisableUI(true);
    }

    /*******************************
     * called with action settings
     *******************************/
    protected didReceiveSettings(context: any,unknownSettings: any) :boolean
    {   if (!super.didReceiveSettings(context,unknownSettings )) return false;

        let action :HTMLSelectElement     |null = document.getElementById("action") as HTMLSelectElement;
        let targetMin :HTMLInputElement   |null = document.getElementById("targetMin") as HTMLInputElement;
        this.targetMax = document.getElementById("targetMax") as HTMLInputElement;
        let moveDelay :HTMLInputElement   |null = document.getElementById("moveDelay") as HTMLInputElement;
        let increment :HTMLInputElement   |null = document.getElementById("increment") as HTMLInputElement;

        action.value = this.settings.action;
        targetMin.value = this.settings.targetmin.toString();
        this.targetMax.value = this.settings.targetmax.toString();
        moveDelay.value = this.settings.delay.toString();
        increment.value = this.settings.increment.toString();
        let it :HTMLElement | null = document.getElementById("targetMaxField");
        if (it) it.style.display = this.dualLimits(action.value) ?"":"none";
        this.DisableUI(this.settings.hwdName=="");
        return true;
    }


    private DisableUI(state :boolean)
    {
        let action : HTMLSelectElement | null = document.getElementById("action") as HTMLSelectElement ;
        if  (action!=null)  action.disabled =  state;
        let targetMin : HTMLInputElement | null = document.getElementById("targetMin") as HTMLInputElement ;
        if  (targetMin!=null)  targetMin.disabled =  state;
        let targetMax : HTMLInputElement | null = document.getElementById("targetMax") as HTMLInputElement ;
        if  (targetMax!=null)  targetMax.disabled =  state;
        let moveDelay : HTMLInputElement | null = document.getElementById("moveDelay") as HTMLInputElement ;
        if  (moveDelay!=null)  moveDelay.disabled =  state;
    }


    /*******************************
     * called when a Properties inpector field has changed
     *******************************/

    protected inspectorValueHasChanged(source: HTMLInputElement | HTMLSelectElement)
    {   super.inspectorValueHasChanged(source);
        switch (source.id)
        {   case "deviceList":
                this.DisableUI(source.value=="") ;
            break;
            case "action" :
                this.settings.action = source.value;
                let it :HTMLElement | null = document.getElementById("targetMaxField");
                if (it) it.style.display = this.dualLimits(source.value)?"":"none";
                this.saveSettings(this.settings);
                break;
            case "targetMin" :
                this.settings.targetmin = parseFloat(source.value);
                this.saveSettings(this.settings);
                break;
            case "targetMax" :
                this.settings.targetmax = parseFloat(source.value);
                this.saveSettings(this.settings);
                break;
            case "moveDelay" :
                this.settings.delay = parseInt( source.value);
                this.saveSettings(this.settings);
                break;
            case "increment" :
                let value : number = parseFloat( source.value)
                this.settings.increment = Math.max(0.1,value);
                if  (value!=this.settings.increment)
                     (source as HTMLInputElement).value = this.settings.increment.toFixed(1);
                this.saveSettings(this.settings);
                break;

        }

    }

    /*******************************
     * extra stuff
     *******************************/

    private dualLimits(action:string)
    {  return (action=="TOGGLE") || (action=="MOMENTARY");

    }


}