
import { PI_handler } from '../common_code/yoctopuce_pi.js'
import { relaySettings } from './relay_settings.js'


export {relaySettings}

export class YRelay_PI_handler extends PI_handler
{
    private _settings: relaySettings;
    protected  get settings():relaySettings {return this._settings}

    /*******************************
     * Constructor , load action's settings
     *******************************/
    constructor (inPort: string, inUUID: string, inRegisterEvent: any, inInfo:any,inActionInfo:string)
    {   super(inPort,inUUID,inRegisterEvent,inInfo,inActionInfo, new  relaySettings()  )
        this._settings = this.deviceSettings as  relaySettings;
        this.DisableUI(true);
    }


    private DisableUI(state :boolean)
    {   let action : HTMLSelectElement | null = document.getElementById("action") as HTMLSelectElement ;
        if  (action!=null)  action.disabled =  state;
        let pulsedelay : HTMLInputElement | null = document.getElementById("pulsedelay") as HTMLInputElement ;
        if  (pulsedelay!=null)  pulsedelay.disabled =  state;

    }


    /*******************************
     * called with action settings
     *******************************/

    protected didReceiveSettings(context: any,unknownSettings: any) :boolean
    {   if (!super.didReceiveSettings(context,unknownSettings )) return false;
        let action :HTMLSelectElement |null = document.getElementById("action") as HTMLSelectElement;
        let pulsedelay :HTMLInputElement |null = document.getElementById("pulsedelay") as HTMLInputElement;
        action.value = this.settings.action;
        pulsedelay.value = this.settings.pulsedelay.toString();
        let f : HTMLDivElement | null = document.getElementById("pulseDelayField") as HTMLDivElement;
        if (f) f.style.display = this.settings.action=="PULSE"?"":"none";
        this.DisableUI(this.settings.hwdName=="");
        return true
    }


    private updateUI()
    {   let action :HTMLSelectElement |null = document.getElementById("action") as HTMLSelectElement;
        let pulseDelay :HTMLInputElement |null = document.getElementById("pulsedelay") as HTMLInputElement;
        action.value        = this.settings.action;
        pulseDelay.value      = this.settings.pulsedelay.toString();
        let pulseDelayField : HTMLDivElement | null = document.getElementById("pulseDelayField") as HTMLDivElement;
        if (pulseDelayField) pulseDelayField.style.display = this.settings.action=="PULSE"?"":"none";
    }


    /*******************************
     * called when a Properties inpector field has changed
     *******************************/

    protected inspectorValueHasChanged(source: HTMLInputElement | HTMLSelectElement)
    {
        super.inspectorValueHasChanged(source);
        switch (source.id)
        {   case "deviceList":
                this.DisableUI(source.value=="") ;
            break;
            case "action" :
                this.settings.action = source.value;
                this.saveSettings(this.settings);
                this.updateUI();
                break;
            case "pulsedelay" :
                this.settings.pulsedelay = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
        }
    }
}