﻿//
//  this is the active code of the Thermal controler
//  it handles parameters saving, temperature check,  mail alarm

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Mail;
using System.Net.Mime;
using Microsoft.Win32;

 class ThermalController
  {

    private const String registryPathDebug = "HKEY_CURRENT_USER\\Software\\Yoctopuce\\ThermalControl\\parameters";  // debug
    private const String registryPath = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\ThermalControl\\parameters";  // service
    private const string NullPassword= "%%NO!PASSWORD%%";
    private static bool TempAlarm = false;
    private static bool DebugMode = false;
    private static DateTime lastMail = new DateTime(1, 1, 1, 1, 1, 1);
    private const  string  cryptokey = "%&!+?+";  // mail server password is encrypted in the registry


    /*
     *  registry access
     * 
     */
    static private bool WriteParamToRegistry(string name, string value, ref string errmsg)
    {
        try
        {Registry.SetValue(DebugMode?registryPathDebug:registryPath, name, value, RegistryValueKind.String);
        }
        catch (Exception)
        {
            errmsg = "Cannot write registry value " + registryPath + '\\' + name;
            return false;
        }

        return true;
    }

    static private bool ReadParamFromRegistry(string name, string defaultValue, ref string value, ref string errmsg)
    {
        try
        {   value = (string)Registry.GetValue(DebugMode ? registryPathDebug : registryPath, name, defaultValue);
            return true;
        }
        catch (Exception) { return false; }

    }

    /*
     *  configuration parameters read/write
     *  parameters are savec in the registry
     */

    static public bool setMailSrvAddr(string mailSrvAddr, ref string errmsg)
    {
        return WriteParamToRegistry("mailSrvAddr", mailSrvAddr, ref errmsg);
    }

    static public bool getMailSrvAddr(ref string value, ref string errmsg)
    {
        return ReadParamFromRegistry("mailSrvAddr", "yourmailserver.com", ref value, ref errmsg);
    }

    static  public bool setMailSrvUsername(string mailSrvUsername, ref string errmsg)
    {   
        return WriteParamToRegistry("mailSrvUsername", mailSrvUsername, ref errmsg);
    }

    static  public bool getMailSrvUsername(ref string value, ref string errmsg)
    {
        return ReadParamFromRegistry("mailSrvUsername", "me@mymail.com", ref value, ref errmsg);
    }

    static public bool setMailSrvPassword(string mailSrvPassword, ref string errmsg)
    {
        if (mailSrvPassword == NullPassword) return true; 
        mailSrvPassword = EncDec.Encrypt(mailSrvPassword,cryptokey);
        return WriteParamToRegistry("mailSrvPassword", mailSrvPassword, ref errmsg);
    }

    static  public bool getMailSrvPassword(ref string value, ref string errmsg)
    {
        if (!ReadParamFromRegistry("mailSrvPassword", "", ref value, ref errmsg)) return false;
        if (value!="") value = EncDec.Decrypt(value,cryptokey);
        return true;
    }

    static  public bool setMailNotificationTo(string mailNotificationTo, ref string errmsg)
    {
        return WriteParamToRegistry("mailNotificationTo", mailNotificationTo, ref errmsg);
    }

    static  public bool getMailNotificationTo(ref string value, ref string errmsg)
    {
        return ReadParamFromRegistry("mailNotificationTo", "it@mymail.com", ref value, ref errmsg);
    }

    static public bool setMailNotificationSubject(string mailNotificationSubject, ref string errmsg)
    {
        return WriteParamToRegistry("mailNotificationSubject", mailNotificationSubject, ref errmsg);
    }

    static  public bool getMailNotificationSubject(ref string value, ref string errmsg)
    {
        return ReadParamFromRegistry("mailNotificationSubject", "Overheat alarm", ref value, ref errmsg);
    }

    static  public bool setMailNotificationBody(string mailNotificationBody, ref string errmsg)
    {
        return WriteParamToRegistry("mailNotificationBody", mailNotificationBody, ref errmsg);
    }

    static  public bool getMailNotificationBody(ref string value, ref string errmsg)
    {
        return ReadParamFromRegistry("mailNotificationBody", "Yoctopuce sensor %SENSORNAME% reported %SENSORVALUE%", ref value, ref errmsg);
    }


    static public bool setSensorThreshold(double sensorThreshold, ref string errmsg)
    {
        return WriteParamToRegistry("sensorThreshold", sensorThreshold.ToString(), ref errmsg);
    }

    static public bool getSensorThreshold(ref double value, ref string errmsg)
    {
        string svalue = "";
        bool ok = ReadParamFromRegistry("sensorThreshold", "35.0", ref svalue, ref errmsg);
        if (ok) value = Convert.ToDouble(svalue);
        return ok;

    }

    
    // just a trick to handle error return
    static private bool error(ref string msgvar, string message)
    {
      msgvar = message;
      return false;
    }


    /*
     * this is the  temperature check function
     * 
     */ 

    static public bool Check4Temp(ref string errmsg)
    {   string sensorname = "";
        double value = 0;
        double threshold = 0;
        string MailSrvAddr = "";
        string MailSrvUsername = "";
        string MailSrvPassword = "";
        string MailNotificationTo = "";
        string MailNotificationSubject = "";
        string MailNotificationBody = "";

        bool ok;
        if (!getSensorValue(ref  sensorname, ref  value, ref  errmsg))
          return false;

        if (!getSensorThreshold(ref threshold, ref  errmsg))
           return false;

        if (value > threshold+0.5)   TempAlarm = true;
        if (value < threshold + 0.5) TempAlarm = false;

        if (TempAlarm)
        {
            TimeSpan ts = DateTime.Now - lastMail;
            if (ts.TotalSeconds >= 4 * 3600) 
             {  ok = getMailSrvAddr(ref MailSrvAddr, ref errmsg);
                if (ok) ok = getMailSrvUsername(ref MailSrvUsername, ref errmsg);
                if (ok) ok = getMailSrvPassword(ref MailSrvPassword, ref  errmsg);
                if (ok) ok = getMailNotificationTo(ref MailNotificationTo, ref errmsg);
                if (ok) ok = getMailNotificationSubject(ref MailNotificationSubject, ref errmsg);
                if (ok) ok = getMailNotificationBody(ref MailNotificationBody, ref errmsg);
                if (!ok) return false;
                 MailNotificationBody = MailNotificationBody.Replace("%SENSORNAME%", sensorname);
                MailNotificationBody = MailNotificationBody.Replace("%SENSORVALUE%", value.ToString("0.0")+"deg C");
                if (!sendSmtpMail(MailSrvAddr, MailSrvUsername, MailSrvPassword,MailNotificationTo,MailNotificationSubject, MailNotificationBody, ref  errmsg))
                    return false;
                lastMail = DateTime.Now;
             }
        }
        else lastMail = new DateTime(1, 1, 1, 1, 1, 1);
        return true;


     }
 
    // send a mail using .NET Smtp library
    static public bool sendSmtpMail(string mailsrv, string mailuser, string mailpass,string sendto, string subject, string body, ref string errmsg )
    {
       System.Net.Mail.SmtpClient client = new System.Net.Mail.SmtpClient(mailsrv);
       client.EnableSsl = false;
       client.Port = 587;
       client.Credentials = new System.Net.NetworkCredential(mailuser, mailpass);
       MailAddress from = new MailAddress(mailuser);
       MailAddress to = new MailAddress(sendto);
       MailMessage message = new MailMessage(from, to);
       message.Body = body;
       message.Subject = subject;
       try
        {
          client.Send(message);

        }
        catch (Exception e)
       {
          errmsg = e.Message;
          return false;
       }
        
       message.Dispose();
       return true;
    }


   // esend a test mail, required by the setup UI 
   static public bool sendTestMail(string MailSrvAddr, string MailSrvUsername, string MailSrvPassword, string  MailNotificationTo ,ref string errmsg)
   { if (MailSrvPassword == NullPassword)
        if (!getMailSrvPassword(ref MailSrvPassword, ref  errmsg)) return false;

     if (!sendSmtpMail(MailSrvAddr, MailSrvUsername, MailSrvPassword,MailNotificationTo, "Thermal control test mail", "This is a test mail from Thermal Control Service, If you're reading this, that means you can save your settings :-)", ref errmsg ))
     {
         return false;

       } 
      return true;
   }


   // those two methods are the only one specific to Yoctopuce
   // hardware, everything else is pure C# Windows Programming

   // init part : used to init the Yoctopuce API
   static public bool init(bool debug, ref string errmsg, ref bool fatalError)
   {
       DebugMode = debug;
       fatalError = false;
       YAPI.DisableExceptions();

       // try to register using native control
       if (YAPI.RegisterHub("usb", ref errmsg) != yAPI.SUCCESS)
       {
           fatalError = true;
           return false;
       }

       WriteParamToRegistry("started", DateTime.Now.ToString(), ref errmsg);

       return true;

   }

   // read temperature form the first temperature sensor found.
   static public bool getSensorValue(ref string sensorname, ref double value, ref string errmsg)
   {
        
       
        int res = YAPI.UpdateDeviceList(ref errmsg);   // handle plug an play
       
           
       if (res!= YAPI.SUCCESS) return false;

      
       YTemperature t = YTemperature.FirstTemperature();
    

       if (t != null)
       {  if (t.isOnline())
           {
               value = t.get_currentValue();
               sensorname = t.get_logicalName();
               if (sensorname == "") sensorname = t.get_module().get_logicalName();
               if (sensorname == "") sensorname = t.get_module().get_serialNumber();
               return true;
           }
       }
       value = 0;
       errmsg = "No temperature function found, make sure there is a Yoctopuce device featuring a temperature sensor connected to this computer.";
       return false;
   }
  
  

}
