﻿
/*
 * this application configures the ThermalControl service 
 * more info on
 * http://www.yoctopuce.com/EN/article/temperature-warnings-under-windows
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
       


        public Form1()
        {
            InitializeComponent();
           
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            timer1.Enabled = true;
           
        }

        private void timer1_Tick(object sender, EventArgs e)
        { string sensorname = "";
          double sensorvalue = 0;
          string errmsg = "";
          ThermalControlClient client = new ThermalControlClient();

          timer1.Enabled = false;

          try
          { if (client.getSensorValue(ref sensorname, ref sensorvalue, ref errmsg))
              {
                  ValueDisplay.Text = sensorvalue.ToString("0.0")+"°C";
                  NameDisplay.Text = sensorname;
                  ErrorDisplay.Text = "";
              }
             else
              {
                  ValueDisplay.Text = "N/A";
                  NameDisplay.Text = "";
                  ErrorDisplay.Text = errmsg;

              }
           }
           catch (Exception exc)
           {    ValueDisplay.Text = "N/A";
                NameDisplay.Text = "";
                ErrorDisplay.Text = "Communication error: The ThemalControl service is probably stopped or not even installed.\n\n" + exc.Message ;
                client.Abort();  
           }

            client.Close();
            timer1.Enabled = true;
        }

        private void label2_Click(object sender, EventArgs e)
        {

        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            string errmsg = "" ;
            ErrorMsg.Text = "Sending test mail, please wait....";
            
            Application.DoEvents();

            ThermalControlClient client = new ThermalControlClient();
            try
            {
                if (client.sendTestMail(MailSrvAddr.Text,
                                        MailSrvUsername.Text,
                                        MailSrvPassword.Text,
                                        MailNotificationTo.Text,
                                        ref errmsg))
                    ErrorMsg.Text = "Test mail sent.";
                else
                {
                    ErrorMsg.Text = "Test failed: " + errmsg;
                }
            }
            catch (Exception)
            {
                ErrorMsg.Text = "Communication Error, is service started ?";
                client.Abort();
            }
            client.Close();
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            
        }

        private void tabPage2_Enter(object sender, EventArgs e)
        {
            string value = "";
            string errmsg = "";
            Boolean ok = false;
            double tresholdvalue = 0;
            ErrorMsg.Text = "";

            MailSrvAddr.Enabled = false;
            MailSrvUsername.Enabled = false;
            MailSrvPassword.Enabled = false;
            MailNotificationTo.Enabled = false;
            MailNotificationSubject.Enabled = false;
            MailNotificationBody.Enabled = false;
            SensorThreshold.Enabled = false;
            TestBtn.Enabled = false;
            SaveBtn.Enabled = false;

            ThermalControlClient client = new ThermalControlClient();
            // for obvious security reasons, the service
            // will no give back the mail server password
            // %%NO!PASSWORD%% value will be ignored by the 
            // service
            MailSrvPassword.Text = "%%NO!PASSWORD%%";

            try
            {
                ok = client.getMailSrvAddr(ref value, ref errmsg);
                MailSrvAddr.Text = value;
                if (ok)
                {
                    ok = client.getMailSrvUsername(ref value, ref errmsg);
                    MailSrvUsername.Text = value;
                }
                if (ok)
                {
                    ok = client.getMailNotificationTo(ref value, ref errmsg);
                    MailNotificationTo.Text = value;
                }
                if (ok)
                {
                    ok = client.getMailNotificationSubject(ref value, ref errmsg);
                    MailNotificationSubject.Text = value;
                }

                if (ok)
                {
                    ok = client.getMailNotificationBody(ref value, ref errmsg);
                    MailNotificationBody.Text = value;
                }

                if (ok)
                {
                    ok = client.getSensorThreshold(ref tresholdvalue, ref errmsg);
                    SensorThreshold.Text = tresholdvalue.ToString("0.0");
                }

            }

            catch (Exception)
            { ErrorMsg.Text="Communication Error, is service started ?";
              client.Abort();
              client.Close();
            }

            if (!ok)
            {
                client.Close();
                ErrorMsg.Text = "Service error: " + errmsg;
                return;
            }

            client.Close();
            MailSrvAddr.Enabled = true;
            MailSrvUsername.Enabled = true;
            MailSrvPassword.Enabled = true;
            MailNotificationTo.Enabled = true;
            MailNotificationSubject.Enabled = true;
            MailNotificationBody.Enabled = true;
            SensorThreshold.Enabled = true;
            TestBtn.Enabled = true;
            SaveBtn.Enabled = true;
            

        }

        private void SaveBtn_Click(object sender, EventArgs e)
        {
           
            string errmsg = "";
            Boolean ok = false;
            

            ThermalControlClient client = new ThermalControlClient();
            try
            {
                ok = client.setMailSrvAddr(MailSrvAddr.Text, ref errmsg);
                if (ok) ok = client.setMailSrvUsername(MailSrvUsername.Text, ref errmsg);
                if (ok) ok = client.setMailSrvPassword(MailSrvPassword.Text, ref errmsg);
                if (ok) ok = client.setMailNotificationTo(MailNotificationTo.Text, ref errmsg);
                if (ok) ok = client.setMailNotificationSubject(MailNotificationSubject.Text, ref errmsg);
                if (ok) ok = client.setMailNotificationBody(MailNotificationBody.Text, ref errmsg);
                if (ok) ok = client.setSensorThreshold(Convert.ToDouble(SensorThreshold.Text), ref errmsg);
            }
            catch (Exception)
            {
                ErrorMsg.Text = "Communication Error, is service started ?";
                client.Abort();
                client.Close();
                return;
            }

            client.Close();
            if (!ok) ErrorMsg.Text = "Service error: " + errmsg;
                else ErrorMsg.Text = "Saved.";
             
            

        }

        private void linkLabel1_Click(object sender, EventArgs e)
        {
            ProcessStartInfo sInfo = new ProcessStartInfo("http://www.yoctopuce.com/");
            Process.Start(sInfo);
        }


    }
}
