

#!/usr/bin/python
import sys
from yocto_api import *
from yocto_anbutton import *
from yocto_digitalio import *

slider1 = None
slider2 = None

class motorizedSlider:

  MINIMUMPULSE = 3       # Minimum pulse length required to move the slider
  POSPRECISION = 10      # expected tracking precision
  ABSORPTION   = 3       # reduce bouncing
  TIMEOUT      = 1       # cancel auto-move after 1 sec with no move detected

  _io  =None
  _ioBit0 = 0
  _ioBit1 = 0
  _anInput = None
  _aninputIndex =0
  _lastdir = 999
  _lastvalue = -1
  _target   = -1
  _moveCallback = None
  _lasttarget = 0
  _lastStop = YAPI.GetTickCount()

  # automatically called each the slider physically move (resistance change)
  # controls the current movement, and calls user callback if cursor is moved manually
  def buttonChange(self,source,value):
    pos = int(value)
    self._lastvalue = pos
    now = YAPI.GetTickCount()
    delta_time = (YAPI.GetTickCount()-self._lastStop).total_seconds()
    if (self._target>=0)    :
       self._lastStop = now
       delta = abs(pos - self._target)
       if (delta <=  self.POSPRECISION) or (delta_time>=1):
          self._lasttarget=self._target
          self.stop()
          return
       direction =0
       if (self._target>pos):
            direction = -1
       else:
            direction=1
       self._move( direction ,delta)
       return
    else:
      delta_pos = abs(self._lastvalue-self._lasttarget)
      if (abs(delta_pos)>50) or   (delta_time> 1) :
        if self._moveCallback!=None :
          self._moveCallback(self, self._lastvalue)

  # constructor
  def __init__(self,io,ioBit0,iobit1, anInput, moveCallback):
    self._io = io
    self._ioBit0 = ioBit0
    self._ioBit1 = iobit1
    self._anInput = anInput
    self._moveCallback = moveCallback
    anInput.registerValueCallback(self.buttonChange)

  # stop the current movement
  def stop(self):
     self._io.set_bitState(self._ioBit0, 0)
     self._io.set_bitState(self._ioBit1, 0)
     self._target=-1
     self._lastdir =0

  # return the current slider position
  def getPosition(self):
    return self._lastvalue

  # make the slider automatically reach a position
  def setPosition(self,target):
    if target<0 or target>999 :  return
    if   abs(self._lastvalue-target)<=self.POSPRECISION :  return
    self._target=target
    delta = abs(self._target-self._lastvalue)
    if self._target<self._lastvalue :
      self._move(1,delta)
    else:
      self._move(-1,delta)

  # Configure the IO channels according to direction and send an initial
  # electrical pulse to the motor to make it move.
  def _move(self,  direction ,delta):
    if (direction>0):
      if (direction!=self._lastdir):
        self._io.set_bitState(self._ioBit1, 0)
        self._io.set_bitDirection(self._ioBit0, 1)
        self._io.set_bitOpenDrain(self._ioBit0, 0)
        self._io.set_bitDirection(self._ioBit1, 1)
        io.set_bitOpenDrain(self._ioBit1, 1)
      self._io.pulse(self._ioBit0, max(self.MINIMUMPULSE,delta/ self.ABSORPTION))
      self._lastdir =direction
    elif (direction<0):
      if (direction!=self._lastdir):
        self._io.set_bitState(self._ioBit0, 0)
        self._io.set_bitDirection(self._ioBit1, 1)
        self._io.set_bitOpenDrain(self._ioBit1, 0)
        self._io.set_bitDirection(self._ioBit0, 1)
        self._io.set_bitOpenDrain(self._ioBit0, 1)
      self._io.pulse(self._ioBit1, max(self.MINIMUMPULSE,delta/ self.ABSORPTION))
      self._lastdir =direction
    else:
      self.stop()


mirror=1
def SwitchAction(source,value):
   global mirror
   mirror= 1 if  int(value)>500 else -1

def Slider1HasMoved(source,value):
   global mirror
   if slider2!=None : slider2.setPosition((mirror-1)*-500 + mirror *value)

def Slider2HasMoved(source,value):
   global mirror
   if slider1!=None : slider1.setPosition((mirror-1)*-500 + mirror *value)

errmsg = YRefParam()
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)

anyButton = YAnButton.FirstAnButton()
if anyButton is None:   sys.exit("Yocto-knob not found");
io = YDigitalIO.FirstDigitalIO()
if io is None:   sys.exit("Yocto-IO not found");

serial = anyButton.get_module().get_serialNumber()
sliderInput1 = YAnButton.FindAnButton(serial+".anButton1")
sliderInput2 = YAnButton.FindAnButton(serial+".anButton2")
switchInput  = YAnButton.FindAnButton(serial+".anButton3")
switchInput.registerValueCallback(SwitchAction)

io.set_outputVoltage(YDigitalIO.OUTPUTVOLTAGE_EXT_V)

slider1 = motorizedSlider(io,0,1,sliderInput1,Slider1HasMoved)
slider2 = motorizedSlider(io,2,3,sliderInput2,Slider2HasMoved)

print("Running...")
while True:
  YAPI.Sleep(1000,errmsg)

YAPI.FreeAPI()