#!/usr/bin/python
# -*- coding: utf-8 -*-

# This is just a simple demo for the Yoctopuce Yocto-MaxiBuzzer
# the result can be seen here: www.youtube.com/watch?v=K2cv9vHxsUk
 
 
import os, sys, math
from yocto_api import *
from yocto_buzzer import *
from yocto_colorledcluster import *
from yocto_anbutton import *

inputVol    = 0
inputFreq   = 0
buzFreq     = 0
needUpdate  = True

# called each time the volume knob is moved
def volchanged(src,str_value):
    global inputVol
    global needUpdate
    inputVol = int(str_value) /10
    needUpdate =True

# called each time the frequency  knob is moved
def freqchanged(src,str_value):
    global inputFreq
    global needUpdate
    inputFreq = int(str_value) *5
    needUpdate =True

# called each time the frequency played by the buzzer changes
def buzchanged(src,str_value):
    global buzFreq
    global needUpdate
    buzFreq = int(str_value)
    needUpdate =True

# Setup the API to use local USB devices
errmsg = YRefParam()
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)

# find the buzzer
buz = YBuzzer.FirstBuzzer()
if buz is None:
    sys.exit('no device connected')

if not (buz.isOnline()):
    sys.exit('device not connected')

# find the other functions on the device
serial = buz.get_module().get_serialNumber()
leds = YColorLedCluster.FindColorLedCluster(serial + ".colorLedCluster")
volBtn = YAnButton.FindAnButton(serial + ".anButton1")
freqBtn = YAnButton.FindAnButton(serial + ".anButton2")

# setup calls backs
volBtn.registerValueCallback(volchanged)
freqBtn.registerValueCallback(freqchanged)
buz.registerValueCallback(buzchanged)

# set playmusic to true to play some music instead of knob drive frequency
playmusic= False

if playmusic:
   buz.playNotes("150% 'G8 F# E E F#2_ F#2 ,A8 'G F# E E4 F#4 D. E8 ,A2 A8 'E4 F#8 G4. E4 C# D8 E4. ,A4 'F#2."); # "Still Alive"  from Portal

while True:
    if needUpdate:
       # change the First led brightness according to played frequency
       l=0
       if playmusic:
          if buzFreq>0 : l = int (150 * math.log(buzFreq) / math.log(2)) - 1300
       else:
          l= int (buzFreq/20)
       print("F="+str(inputFreq)+" v="+str(inputVol)+" l= "+str(l) )

       leds.set_rgbColor(0,1,l<<16 | l<<8 | l)

       # update volume and frequency
       if not playmusic:
          buz.set_frequency(inputFreq)
       buz.set_volume(inputVol)

       # update RGB leds 1..8 according to volume settings
       HshArray= [];
       v = int (8* 128 * inputVol /100);
       for i in range(0,8):
         l=0
         if v>127:
            l  =  127
            v=v-127
         else:
            l  = v
            v = 0
         HshArray.append ((int ( 90 * (7-i) / 8)   << 16) | (255<<8) | l);
       leds.set_hslColorArray(1,HshArray)

       needUpdate =False

    YAPI.Sleep(10,errmsg)

