﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
  public partial class Form1 : Form
  {
    const int RelaysCount  = 16;
    const int channelCount = 16;
    const int refreshtime = 40;
    const int pixelsPerSec = 100; 

    MIDI.InputPort m;
    YColorLed led;
    int[] channels;
    YRelay[] relays;
    int timeline = 0;
    Bitmap display; 
    int selftestindex =0;
    int count = 0;

    public void log(string msg)
    {
      if (InvokeRequired) 
      {
        Invoke(new Action<string>(log), msg);
        return;
      }
      try
      {
          textBox1.AppendText(msg + Environment.NewLine);
      }
      catch (Exception e) { }
    }


    public void Hardwareinitialize()
    {
        yAPI.DisableExceptions();
        string errmsg = "";
       
      

        // open Midi port
        m = null;
        if (MIDI.InputPort.InputCount == 0)
        {   
            log("Cannot find MIDI instrument");
        }
        else
        {   m = new MIDI.InputPort(MidiProc);  // sets callback
            m.Open(0);   
            m.Start(); // start calpture
        }


        // usb Local Yocto-devices
        if (YAPI.RegisterHub("usb", ref errmsg) != YAPI.SUCCESS)
        {
            log("Error opening Yoctopuce API: " + errmsg);
            return;
        }

        // enummrate all 16 relays functions
        relays = new YRelay[RelaysCount];
        for (int i = 0; i < RelaysCount; i++)
        {   relays[i] = YRelay.FindRelay("R" + i);
            if (!relays[i].isOnline()) log("Relay R" + i + " is offline");
        }


        led = YColorLed.FirstColorLed();
        if (led == null)
        {   log("No color LED found");
        }


    }



    /*
     *  MIDI callback each time a note is played is player, this callback
     *  be be called
     */

    public void MidiProc(IntPtr hMidiIn, int wMsg, IntPtr dwInstance, int dwParam1, int dwParam2)
    {
      if (wMsg != 0x3c3) return;              // handle midi data only
      if ((dwParam1 & 0xff) != 0x99) return;  // handle notes only 
      int velo = (dwParam1 >> 16) & 0xff;
      int note = (dwParam1 >> 8) & 0xff;

      if ((velo > 0) && (led.isOnline()))  // if the is a RGB-LED connected lets change its color
       {
         led.set_hslColor(((note & 0xf) << 20) + 0xff00 + (velo > 0x40 ? 0x80 : 2*velo));
         led.rgbMove(0, 4*velo);
       }

      int channel = note %16;
      channels[channel] = velo;
     
      log("channel #" + channel + " -> " + velo + " ms");
      NewNote(channel, velo);

    }

    /*
     * drive the realyes 
     */
    void NewNote(int channel, int velocity)
    {
        count++;
        relays[channel].pulse(2 * velocity + 50);
        if (velocity >= 25) relays[15 - channel].pulse(2 * velocity + 50);
    }

  /*
   * refresh the time line  
   * 
   */
   public void refresh(int timeline)
    {
      int timelineGraduation = 1000; // one every secs

      int imageshift = (pixelsPerSec * refreshtime / 1000); 

     
       // lets use a double buffering technique to avoid flickering 
      Bitmap BackBuffer = new Bitmap(display.Width, display.Height);
      Graphics buffer = Graphics.FromImage(BackBuffer);
      Brush b = new SolidBrush(System.Drawing.Color.White);
      buffer.FillRectangle(b, 0, 0, display.Width, display.Height);
      Pen p = new Pen(Color.FromArgb(200, 200, 200), 1);
      Pen p2 = new Pen(Color.FromArgb(255, 0, 0), 10);

      for (int i = 0; i < channelCount; i++)
      {
        int y = (i + 1) * (display.Height / channelCount + 1);
        buffer.DrawLine(p, 0, y, display.Width, y);


        if (channels[i] >0)
        {
          buffer.DrawLine(p2, display.Width - imageshift, y, display.Width - imageshift + (channels[i] * pixelsPerSec) / 1000, y);
          channels[i] -= refreshtime;
          if (channels[i] < 0) channels[i] = 0;
  
        }
      }

      int pixelParGraduation = (pixelsPerSec * timelineGraduation) / 1000;


      for (int i = 0; i < (display.Width / pixelParGraduation) + 1; i++)
      {
        int x = display.Width - ((int)((timeline * pixelsPerSec) / 1000) % pixelParGraduation) - i * pixelParGraduation;
        buffer.DrawLine(p, x, 0, x, display.Height);
      }

   
      buffer.DrawImage(display, -imageshift, 0);
      display.Dispose();
      display = BackBuffer;


      
      Graphics Viewable = pictureBox1.CreateGraphics();
      Viewable.DrawImage(display, new Rectangle(0, 0, pictureBox1.Width, pictureBox1.Height));
      
      Viewable.Dispose();
      buffer.Dispose();
      p.Dispose();
      p2.Dispose();


    }

   private void timer1_Tick(object sender, EventArgs e)
   {
     timeline += refreshtime;
     refresh(timeline);
     if (selftest.Checked)
     {
       selftestindex = (selftestindex + 1) % 16;
       relays[selftestindex].pulse(40);

     }
   }



   public Form1()
   {
       InitializeComponent();

       channels = new int[channelCount];
       for (int i = 0; i < channelCount; i++)
           channels[i] = 0;

       Hardwareinitialize();

       display = new Bitmap(500, 600);


       timer1.Interval = refreshtime;
       timer1.Enabled = true;
   }



   private void checkBox1_CheckedChanged(object sender, EventArgs e)
   {

   }

   private void pictureBox1_Click(object sender, EventArgs e)
   {

   }

  }
}
