#include "yocto_api.h"
#include "yocto_servo.h"
#include <iostream>
#include <stdlib.h>

using namespace std;

static void usage(void)
{
    cout << "usage: updateServo <usb | ipaddr>  <cpu_pos> <disk_pos> [delay]" << endl;
    cout << "       positions are form -1000 to 1000 " << endl;
    exit(1);
}

static int updateServoPos(string name,int pos,int delay)
{

    YServo *servo;
    
    servo =  yFindServo(name);
    if(servo->isOnline())
        if(delay>0)
            servo->move(pos,delay);
        else
            servo->set_position(pos);
    else {
        cerr << "ERROR: servo "<<name <<" is not online"<<endl;
        cerr << "       check your cable and your device configuration (IE: function name)"<<endl;
        return 1;
    }
    return 0;
}

int main(int argc, const char * argv[])
{
    string errmsg;
    YServo *servo1;
    YServo *servo5;
    int delay =0;
  
    if (argc < 4) {
        usage();
    }
   
    if(argc==5) {
        delay = atol(argv[4]);
    }

    if (yRegisterHub(argv[1], errmsg) != YAPI_SUCCESS) {
        cerr << "RegisterHub("<<argv[1]<<") error: " << errmsg << endl;
        return 1;
    }

    if(updateServoPos("cpu_gauge",atol(argv[2]),delay))
        return 1;
    if(updateServoPos("disk_gauge",atol(argv[3]),delay))
        return 1;
        
    return 0;
}
