/*********************************************************************
 *
 * $Id: ytcp.h 5910 2012-04-02 21:54:04Z seb $
 *
 *  Declaration of a client TCP stack
 *
 * - - - - - - - - - License information: - - - - - - - - - 
 *
 * Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
 *
 * 1) If you have obtained this file from www.yoctopuce.com,
 *    Yoctopuce Sarl licenses to you (hereafter Licensee) the
 *    right to use, modify, copy, and integrate this source file
 *    into your own solution for the sole purpose of interfacing
 *    a Yoctopuce product with Licensee's solution.
 *
 *    The use of this file and all relationship between Yoctopuce 
 *    and Licensee are governed by Yoctopuce General Terms and 
 *    Conditions.
 *
 *    THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 *    WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING 
 *    WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS 
 *    FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
 *    EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
 *    INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, 
 *    COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR 
 *    SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT 
 *    LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
 *    CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
 *    BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
 *    WARRANTY, OR OTHERWISE.
 *
 * 2) If your intent is not to interface with Yoctopuce products,
 *    you are not entitled to use, read or create any derived 
 *    material from this source file.
 *
 *********************************************************************/


#ifndef YTCP_H
#define YTCP_H



#ifdef  __cplusplus
extern "C" {
#endif
    
#include "ydef.h"


#ifdef WINDOWS_API
/**************************************************************
 *
 *  WINDOWS IMPLEMENTATION
 *
 **************************************************************/

//SOCKET RELATED DEFIITIONS AND INCLUDE
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#define SOCKET_ERROR -1
#define INVALID_SOCKET -1
#define closesocket(s) close(s)
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/tcp.h>
#endif





#if 0
#define yTCPLOG(txt, ... )    printf(txt"\n",__VA_ARGS__)
#else
#ifdef __BORLANDC__
#define yTCPLOG notcplog
#else
#define yTCPLOG(txt,...)
#endif
#endif

// A TCP_SOCKET is stored as a single BYTE
#define YTCP_REMOTE_CLOSE 1


int  yTcpInit(char *errmsg);
u32  yResolveDNS(const char *name,char *errmsg);
int  yTcpOpenRef(YIOHDL *ioghdl,yUrlRef  ref,char *errmsg);
int  yTcpOpen(YIOHDL *ioghdl,u32 ip,u16 port,char *errmsg);
int  yTcpWrite(YIOHDL *ioghdl, const char *buffer, int len,char *errmsg);
int  yTcpRead(YIOHDL *ioghdl, char *buffer, int len,char *errmsg);
int  yTcpSelect(YIOHDL *ioghdl, int ms,char *errmsg);
int  yTcpMultiSelect(YIOHDL **ioghdl,int size, int ms,u32* bitmap,char *errmsg);
int  yTcpEOF(YIOHDL *iohdl,char *errmsg);
void yTcpClose(YIOHDL *ioghdl);
void yTcpShutdown(void);
#ifdef  __cplusplus
}
#endif
#endif
