/*********************************************************************
 *
 * $Id: yprog.h 5832 2012-03-29 15:14:04Z seb $
 *
 * Declaration of firmware upgrade functions
 *
 * - - - - - - - - - License information: - - - - - - - - - 
 *
 * Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
 *
 * 1) If you have obtained this file from www.yoctopuce.com,
 *    Yoctopuce Sarl licenses to you (hereafter Licensee) the
 *    right to use, modify, copy, and integrate this source file
 *    into your own solution for the sole purpose of interfacing
 *    a Yoctopuce product with Licensee's solution.
 *
 *    The use of this file and all relationship between Yoctopuce 
 *    and Licensee are governed by Yoctopuce General Terms and 
 *    Conditions.
 *
 *    THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 *    WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING 
 *    WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS 
 *    FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
 *    EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
 *    INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, 
 *    COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR 
 *    SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT 
 *    LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
 *    CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
 *    BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
 *    WARRANTY, OR OTHERWISE.
 *
 * 2) If your intent is not to interface with Yoctopuce products,
 *    you are not entitled to use, read or create any derived 
 *    material from this source file.
 *
 *********************************************************************/

#ifndef YPROG_H
#define YPROG_H
#include "ydef.h"

#ifdef MICROCHIP_API
typedef int ProgIface;
#else
#include "yproto.h"
typedef yInterfaceSt ProgIface;
#endif

#define MAX_ZONES_PER_FILES   8


#define  BYN_SIGN  ((u32) ('B'| ((u16)'Y'<<8) | ((u32)'N'<<16) ))
#define  BYN_REV_V4 4
#define  BYN_REV    5



typedef struct{
        u32 nbzones;
        u32 datasize;
}byn_head_v4;

typedef struct{
        char prog_version[YOCTO_FIRMWARE_LEN];
        u32 nbzones;
        u32 datasize;
}byn_head_v5;

typedef struct{
        u32 sign;
        u16 rev;
        char serial[YOCTO_SERIAL_LEN];
        char pictype[20];
        char product[YOCTO_PRODUCTNAME_LEN];
        char firmware[YOCTO_FIRMWARE_LEN];
}byn_head_sign;

typedef struct{
        byn_head_sign h;
        union {
            byn_head_v5 v5;
            byn_head_v4 v4;
        };
}byn_head_multi;



typedef struct{
    u32 addr;
    u32 len;
}byn_zone;


typedef struct{
    u32 addr;
    u32 nbinstr;
    u32 nbblock;
    u8  *ptr;
    u32 len;    
}memzones;


typedef struct{
    ProgIface  iface;
    u32         pr_blk_size;
    u32         er_blk_size;
    u32         last_addr;
    u32         settings_addr;
    u8          devid_family;
    u8          devid_model;
    u16         devid_rev;
    u32         startconfig;
    u32         endofconfig;
}BootloaderSt;




// Return 1 if the communication channel to the device is busy
// Return 0 if there is no ongoing transaction with the device
int ypIsSendBootloaderBusy(BootloaderSt *dev);

// Return 0 if there command was successfully queued for sending
// Return -1 if the output channel is busy and the command could not be sent
int ypSendBootloaderCmd(BootloaderSt *dev, const USB_Packet *pkt,char *errmsg);
// Return 0 if a reply packet was available and returned
// Return -1 if there was no reply available
int ypGetBootloaderReply(BootloaderSt *dev, USB_Packet *pkt,char *errmsg);
// Power cycle the device
void ypBootloaderShutdown(BootloaderSt *dev);

const char* prog_GetCPUName(BootloaderSt *dev);
int prog_RebootDevice(BootloaderSt *dev,char *errmsg);
int prog_BlankDevice(BootloaderSt *dev,char *errmsg);
int prog_FlashBlock(BootloaderSt *dev,u32 startAddr, u8 *data,int size,char *errmsg);
int prog_GetDeviceInfo(BootloaderSt *dev,char *errmsg);
int checkHardwareCompat(BootloaderSt *dev,const char *pictype);
int IsValidBynFile(const byn_head_multi  *head, u32 size,char *errmsg);
int ValidateBynCompat(const byn_head_multi *head,u32 size,const char *serial, BootloaderSt *dev,u32 *nbzones,char *errmsg);

#ifndef MICROCHIP_API
int prog_FlashDevice(yFlashArg *arg, int realyflash, char *errmsg);
int DecodeBynFile(const u8 *buffer,u32 size,memzones *zones,u32 nbzones,const char *serial, BootloaderSt *dev,char *errmsg);
int yUSBGetBooloader(const char *serial, const char * name,  yInterfaceSt *iface,char *errmsg);
void FreeZones(memzones *zones,u32 nbzones);
#endif
#endif
