#!/usr/bin/python
#
import subprocess
import pprint
import time

MAX_DISK_USAGE =1

def updateGauge(cpu,disk):
    global MAX_DISK_USAGE
    cpu_pos = (cpu *2000/100) -1000
    if disk>MAX_DISK_USAGE:
        MAX_DISK_USAGE = disk
    disk_pos = (disk*2000/100) -1000
    subprocess.call(["./updateGauge","usb",str(cpu_pos),str(disk_pos),"500"])




INTERVAL = 1

def getCPUTimeList():
    statFile = file("/proc/stat", "r")
    line = statFile.readline()
    timeList = line.split(" ")[2:6]
    statFile.close()
    for i in range(len(timeList))  :
        timeList[i] = int(timeList[i])
    return timeList

def GetTotalDiskIO(dev=None):
    file_path = '/proc/diskstats'
    total_wr = 0
    total_rd = 0

    # ref: http://lxr.osuosl.org/source/Documentation/iostats.txt
    columns_disk = ['m', 'mm', 'dev', 'reads', 'rd_mrg', 'rd_sectors',
                    'ms_reading', 'writes', 'wr_mrg', 'wr_sectors',
                    'ms_writing', 'cur_ios', 'ms_doing_io', 'ms_weighted']

    columns_partition = ['m', 'mm', 'dev', 'reads', 'rd_sectors', 'writes', 'wr_sectors']

    lines = open(file_path, 'r').readlines()
    for line in lines:
        if line == '': continue
        split = line.split()
        if len(split) == len(columns_disk):
            columns = columns_disk
        elif len(split) == len(columns_partition):
            columns = columns_partition
        else:
            # No match
            continue
        data = dict(zip(columns_disk, split))
        if dev != None and dev != data['dev']:
            continue
        total_rd += int(data['rd_sectors']);
        total_wr += int(data['wr_sectors']);
    return total_rd+total_wr



def deltaTime(interval)  :
    cpu_x = getCPUTimeList()
    disk_x = GetTotalDiskIO("md0")
    time.sleep(interval)
    cpu_y = getCPUTimeList()
    disk_y = GetTotalDiskIO("md0")
    for i in range(len(cpu_x))  :
        cpu_y[i] -= cpu_x[i]
    cpuPm = 100 - (cpu_y[len(cpu_y) - 1] * 100.0 / sum(cpu_y))

    disk_usage = disk_y-disk_x
    updateGauge(cpuPm,disk_usage)



def getSysTemp():
    p = subprocess.Popen(["/sbin/getsysinfo" ,"systmp"],stdout=subprocess.PIPE)
    temp_txt = p.stdout.read()
    temp_val =int(temp_txt.split(" ")[0])
    return temp_val



while True:
    deltaTime(0.5)




