unit main;


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  yocto_api,yocto_colorled, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    Label1: TLabel;
    Timer1: TTimer;
    StatusBar1: TStatusBar;
    Image1: TImage;
    saveBtn: TBitBtn;
    HTrackBar: TTrackBar;
    Label2: TLabel;
    STrackBar: TTrackBar;
    LTrackBar: TTrackBar;
    Label3: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);


    procedure HTrackBarChange(Sender: TObject);
    procedure saveBtnClick(Sender: TObject);
  private
    { Private declarations }
    scanCounter : integer;
    procedure disableColor();
  
    Procedure  setCurrentColor(c:integer);
    function   getCurrentColor:integer;
    procedure  drawColor(c:integer);
    function  hsl2rgb(HSL : integer):integer;
  public
    { Public declarations }
     Procedure modulesInventory();
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}



// fast HSL  to RGB  convertion (integer calculus)
function TForm1.hsl2rgb(HSL : integer):integer;
 function hsl2rgbInt(temp1,temp2,temp3 :integer):integer;
 begin
    if (temp3 >= 170) then
      begin
       hsl2rgbInt:=((temp1 + 127) div 255);
       exit;
      end;
     if (temp3 > 42) then
       begin
        if (temp3 <= 127)  then
          begin
            hsl2rgbInt:= ((temp2 + 127) div 255);
            exit;
          end;
        temp3 := 170 - temp3;
      end;
    hsl2rgbInt :=((temp1*255 + (temp2-temp1) * (6 * temp3) + 32512) div 65025);
  end;
  var
   H,S,L,R,G,B,temp1,temp2,temp3 : integer;

 begin
    H := (HSL shr 16)  and $ff;
    S := (HSL shr 8)  and $ff ;
    L :=  HSL  and $ff;

    if (S=0) then
      begin
       hsl2rgb := (L shl 16) or (L shl 8) or L;
       exit;
      end;

    if (L<=127) then temp2 := L * (255 + S)
      else temp2 := (L+S) * 255 - L*S;

    temp1 := 510 * L - temp2;

    // R
    temp3 := (H + 85);
    if (temp3 > 255) then temp3 := temp3-255;
    R := hsl2rgbInt(temp1, temp2, temp3);

    // G
    temp3 := H;
    if (temp3 > 255) then  temp3 := temp3-255;
    G := hsl2rgbInt(temp1, temp2, temp3);

    // B
    if (H >= 85) then temp3 := H - 85 else temp3 := H + 170;
    B := hsl2rgbInt(temp1, temp2, temp3);

    if (R>255) then R:=255;  // just in case
    if (G>255) then G:=255;
    if (B>255) then B:=255;

    hsl2rgb := (B shl 16) or (G shl 8) or  R;  // delphi format
end;


procedure devicelistchanged(m:Tymodule);

 begin
   // something has changed in the devices list
   // lets refresh it, quick and dirty way.
   form1.modulesInventory();
 end;


Procedure TForm1.modulesInventory();
  var
   module         : TYModule;
   name,lname     : string;
   currentModule  : Tymodule;
   index,i        : integer;
   c              : integer;
 begin

   // memorize the current selection
   currentModule := nil;
   if (combobox1.itemindex>=0) then
       currentModule := TYModule(combobox1.items.objects[combobox1.itemindex]);

   // update the list, brute force
   combobox1.items.clear;
   module := yFirstModule();
   while module<>nil  do
   begin
     name  :=  module.get_serialNumber();
     if copy(name,1,8)='YRGBLED1' then
      begin
       lname :=  module.get_logicalName();
       if (lname<>'') then  name:=name+' ('+lname+')';
       combobox1.items.AddObject(name,module);
      end;
      module := module.nextModule();
   end;

   // restore previous selection
   if (combobox1.items.count=0) then
    begin
      combobox1.enabled:=false;
    end
    else
    begin
     combobox1.enabled:=true;
     index :=0;
     for i:=0 to combobox1.items.count-1 do
       if  (combobox1.items.objects[i]=currentModule) then index:=i;
     combobox1.itemindex:=index;
    end;

   // enable/disable UI
   label2.enabled :=  combobox1.enabled;
   label3.enabled :=  combobox1.enabled;
   label4.enabled :=  combobox1.enabled;
   image1.enabled :=  combobox1.enabled;
   saveBtn.enabled:=  combobox1.enabled;
   HTrackBar.enabled := combobox1.enabled;
   STrackBar.enabled := combobox1.enabled;
   LTrackBar.enabled := combobox1.enabled;

   // update status bar
   if combobox1.items.count =0 then  StatusBar1.panels[0].text:='No Yocto-Color connected'
   else if combobox1.items.count =1 then  StatusBar1.panels[0].text:='One device connected'
   else StatusBar1.panels[0].text:=intToStr(combobox1.items.count)+' devices connected';

   if (combobox1.enabled) then
    begin
     // refresh UI
     c:=getCurrentColor();
     drawColor(c);
     HTrackBar.position := (c and $FF0000)shr 16;
     STrackBar.position  := (c and $00FF00)shr 8;
     LTrackBar.position  := (c and $0000FF);
   end else disableColor();
 end;


procedure TForm1.Timer1Timer(Sender: TObject);
var
  errmsg:string;
begin
  timer1.enabled:=false;
  if combobox1.enabled then
    if (combobox1.itemindex>=0) then
    begin
    end;
   // form time to time force a device scan, devicelistchanged
   // will be called if something interresting happened
   inc(scanCounter);
   if (scanCounter>10)  then
    begin
      yUpdateDeviceList(errmsg); // scan for changes
      scanCounter :=0;
    end;

   timer1.enabled:=true;
end;


procedure TForm1.FormCreate(Sender: TObject);
 begin
   scanCounter:=0;
   ModulesInventory();
   // we wanna know whant device list changes
   yRegisterDeviceArrivalCallBack( devicelistchanged);
   yRegisterDeviceRemovalCallBack( devicelistchanged);
   timer1.enabled:=true;
 end;

function TForm1.getCurrentColor:integer;
 var
  m:Tymodule;
  l:TYcolorLed;
  c:integer;
 begin
   // retreive the color from the module selected in the combo box
   if not(comboBox1.enabled) then
    begin
      getCurrentColor:=0;
      exit;
    end;
   m:=TYModule(combobox1.items.objects[combobox1.itemindex]);
   if not(m.isOnline()) then
     begin
      getCurrentColor:=0;
      exit;
    end;
   l:=YFindColorLed(m.get_serialNumber()+'.colorLed1');
   c :=  l.get_hslColor();
   getCurrentColor :=c;
 end;

Procedure   TForm1.setCurrentColor(c:integer);
 var
  m:tymodule;
  l:TYColorLed;
 begin
   // sets the color on the module selected in the combobox
   if not(comboBox1.enabled) then   exit;
   m:=TYModule(combobox1.items.objects[combobox1.itemindex]);
   if not(m.isOnline()) then   exit;
   l := YFindColorLed(m.get_serialNumber()+'.colorLed1');
   l.set_hslColor(c);
   l := YFindColorLed(m.get_serialNumber()+'.colorLed2');
   l.set_hslColor(c);
 end;

procedure TForm1.drawColor(c:integer);
 begin
    // draw the color on the UI
    image1.canvas.brush.color:= hsl2rgb(c);
    image1.canvas.brush.style:=bsSolid;
    image1.canvas.pen.color:=clBlack;
    image1.canvas.pen.style:=psSolid;
    image1.canvas.pen.Width:=1;
    image1.canvas.Rectangle(0,0,image1.width,image1.height);
   end;

 procedure TForm1.disableColor();
  begin
    image1.canvas.brush.color:= $C0C0C0  ;
    image1.canvas.brush.style:=bsSolid;
    image1.canvas.pen.color:=$808080;
    image1.canvas.pen.style:=psSolid;
    image1.canvas.pen.Width:=1;
    image1.canvas.Rectangle(0,0,image1.width,image1.height);
    image1.canvas.pen.color:=$A0A0A0;
    image1.canvas.pen.Width:=6;
    image1.canvas.moveTo(0,image1.height);
    image1.canvas.lineTo(image1.width,0);
    image1.canvas.pen.color:=$606060;
    image1.canvas.pen.Width:=5;
    image1.canvas.moveTo(0,image1.height);
    image1.canvas.lineTo(image1.width,0);

   end;




procedure TForm1.HTrackBarChange(Sender: TObject);
 var h,s,l,c : integer ;
begin
   // read color from sliders
   h:=HTrackBar.position;
   s:=STrackBar.position;
   L:=LTrackBar.position;
   c:= (h shl 16 ) or (s shl 8) or l;
   // draw ui
   drawcolor(c);
   // set module color
   setCurrentColor(c)
end;

procedure TForm1.saveBtnClick(Sender: TObject);
  var
   m:tymodule;
   l:TYcolorLed;
   c:integer;
begin
   if not(comboBox1.enabled) then   exit;
   m:=TYModule(combobox1.items.objects[combobox1.itemindex]);
   if not(m.isOnline()) then   exit;
   // sets the current color as the one to use at module startup
   l := YFindColorLed(m.get_serialNumber()+'.colorLed1');
   c:=l.get_rgbColor();
   l.set_rgbColorAtPowerOn(c);
   // save the current settings in the module flash
   m.saveToFlash();
end;

var
   errmsg: string;

initialization
   // some hardware init
   if yRegisterHub('usb', errmsg)<>YAPI_SUCCESS then
    begin
      Application.MessageBox(pchar('Yocto-api init failed: '+errmsg), 'Error', MB_OK);
      application.terminate();
    end;
   yDisableExceptions();
end.
