unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, yocto_api,yocto_servo;

type

 TCatapultControler = class(Tobject)
   private
     initOk       : boolean;
     initError    : string;
     runningstate : integer ;
     runTimer     : TTimer;
    procedure run(timer: Tobject);

   public
     constructor create();
     procedure fire();
     function isReady(var msg:string):boolean;
   end;

  TForm1 = class(TForm)
    fireButton: TButton;
    StatusBar1: TStatusBar;
    StateTimer: TTimer;
    procedure StateTimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure fireButtonClick(Sender: TObject);
  private
    { Private declarations }
    catapult :TCatapultControler;
    procedure   refresh();
  public
    { Public declarations }
  end;





var
  Form1: TForm1;

implementation

{$R *.DFM}

  constructor TCatapultControler.create();
   begin
     initOk            := not(YISERR(yRegisterHub('usb',initError)));
     runTimer          := ttimer.create(nil);
     runTimer.enabled  := false;
     runTimer.onTimer  := run;
     runningstate :=0;
   end;

  function TCatapultControler.isReady(var msg:string):boolean;
   var
     module: TyModule;
     ok    : boolean;
   begin
     ok  := true;
     msg := 'Catapult ready';
     if not(initOk) then
       begin
        ok   := false;
        msg  := initError;
       end;

     if (ok) then
       begin
         Module :=  yModule('catapult');
         if  not(Module.isOnline()) then
           begin
             ok    := false;
             msg  := 'No catapult device found, check cables';
          end;
       end;

     if (ok) and (runningstate<>0) then
      begin
        ok    := false;
        if  (runningstate=1)  then  msg  := 'Firing'
                              else  msg  := 'Rearming';
      end;
    isReady:=ok;  
   end;



  procedure TCatapultControler.run(timer: Tobject);
    var
      FireServo,ArmingServo: TyServo;
    const
      FireServoLimitA    = -800;
      FireServoLimitB    =  800;
      ArmingServoLimitA  = -1000;
      ArmningServoLimitB =  1000;

    procedure ScheduleNextState(delay:integer);
      begin
       runningstate            := runningstate+1;
       TTimer(timer).interval := delay;
       TTimer(timer).enabled   := true;
      end;

   begin
     TTimer(timer).enabled:=false;
     ArmingServo :=  yFindServo('catapult.servo1');
     FireServo   :=  yFindServo('catapult.servo2');
     if not(FireServo.isOnline()) then  exit;
     if (runningstate=0) then exit;

     case  runningstate of
       1 : begin
             FireServo.move(FireServoLimitB,500);
             ScheduleNextState(1000);
           end;
       2 : begin
             FireServo.move(FireServoLimitA,500);
             ArmingServo.move(ArmningServoLimitB,500);
             ScheduleNextState(600);
           end;
       3,5,7,9 :
           begin
            ArmingServo.move(ArmingServoLimitA,1000);
            ScheduleNextState(1500);
           end;
       4,6,8,10 :
           begin
             ArmingServo.move(ArmningServoLimitB,500);
             ScheduleNextState(600);
           end;
       11   :  runningstate :=0;
     end;
   end;

  procedure  TCatapultControler.fire();
   var
    msg:string;

   begin
     if isReady(msg) then
       begin
         msg          :='firing';
         runningstate :=1;
         run(runTimer);
       end;
   end;

  procedure   TForm1.refresh();
   var
    msg: string;
   begin
    fireButton.enabled        := catapult.isReady(msg);
    statusbar1.panels[0].text := msg;
   end;

  procedure TForm1.StateTimerTimer(Sender: TObject);
   begin
     refresh()
   end;

  procedure TForm1.FormCreate(Sender: TObject);
   begin
     catapult := TCatapultControler.create();
     StateTimer.enabled:=true;
   end;

  procedure TForm1.fireButtonClick(Sender: TObject);

   begin
     catapult.fire();
     refresh;
   end;

initialization
 // YDisableExceptions();

end.
