'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.zlib_crc32 = void 0;
// Note: we can't get significant speed boost here.
// So write code to minimize size - no pregenerated tables
// and array tools dependencies.
// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.
// Use ordinary array, since untyped makes no boost here
class zlib_crc32 {
    static makeTable() {
        let c;
        let table = new Int32Array(256);
        for (let n = 0; n < 256; n++) {
            c = n;
            for (let k = 0; k < 8; k++) {
                c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
            }
            table[n] = c;
        }
        return table;
    }
    static crc32(crc, buf, len, pos) {
        let t = zlib_crc32.crcTable;
        let end = pos + len;
        crc ^= -1;
        for (let i = pos; i < end; i++) {
            crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
        }
        return (crc ^ (-1)); // >>> 0;
    }
}
exports.zlib_crc32 = zlib_crc32;
// Create table on load. Just 255 signed longs. Not a problem.
zlib_crc32.crcTable = zlib_crc32.makeTable();
//# sourceMappingURL=crc32.js.map