﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication3
{
  public partial class Form1 : Form
  {
    Bitmap DrawArea;
    int n = 0;
   string videoFile = "C:\\tmp\\videotest.MOV";

    public Form1()
    {
      this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
      InitializeComponent();
      DrawArea = new Bitmap(pictureBox1.Size.Width, pictureBox1.Size.Height);
      pictureBox1.Image = DrawArea;    
      this.axWindowsMediaPlayer1.ClickEvent += new AxWMPLib._WMPOCXEvents_ClickEventHandler(axWindowsMediaPlayer1_ClickEvent);
    }

    void axWindowsMediaPlayer1_ClickEvent(object sender, AxWMPLib._WMPOCXEvents_ClickEvent e)
    {
      if (e.nButton == 2)
      {
        contextMenuStrip1.Show(MousePosition);
      }
    }

    void drawIt(Color c)
    {
      Graphics g;
      g = Graphics.FromImage(DrawArea);
      SolidBrush myBrush = new SolidBrush(c);
      g.FillRectangle(myBrush, new Rectangle(0, 0, DrawArea.Size.Width, DrawArea.Size.Height));
      myBrush.Dispose();  
      g.Dispose();
      pictureBox1.Image = DrawArea;
    }


    private void Form1_Load(object sender, EventArgs e)
    {
      this.WindowState = FormWindowState.Maximized;
      axWindowsMediaPlayer1.uiMode = "none";   
      axWindowsMediaPlayer1.URL = videoFile;
      axWindowsMediaPlayer1.stretchToFit = true;
      axWindowsMediaPlayer1.enableContextMenu = false;
      axWindowsMediaPlayer1.Ctlcontrols.play();
      timer1.Enabled = true;
    }

    private void timer1_Tick(object sender, EventArgs e)
    {
      n = (n + 1) % 2;
      drawIt(n == 0 ? Color.Black : Color.White); 
    }

    private void exitToolStripMenuItem_Click(object sender, EventArgs e)
    {
      Application.Exit();
    }

  
    }
}
