/*
  This is just a  demo code to Run on a Flic Hub LR
  If shows how to implement an abstraction over the
  Yoctopuce Rest API, mimicking the regular Yoctopuce
  API.

  (Partially) implemented features are Relay,
  Temperature and  colorLedCluster, but more can easily
  be added

  The demo monitor temperature and toggle the relay
  and the LED color when the value crosses a threshold
  but a click on a Flic.io button can override the
  relay state.

*/


var net = require("net");
var http = require("http");
var buttonManager = require("buttons");
var buttons = buttonManager.getButtons();


//  Makes a HTTP  GET request using Flic.io's http module.
function AsyncRequest(restUrl, success, failure)
  {
    http.makeRequest(
      { url: restUrl,
        method: "GET",
      }, function (err, result)
      {
      if (err == null)
        {switch (result.statusCode)
          { case 200: try { if (success) success(JSON.parse(result.content));}
                      catch (e) { if (failure) failure(e.message); }
                      break;
            case 404: if (failure) failure("404 Not found");
                      break;
            case 401: if (failure) failure("401 Access denied");
                      break;
            default:  if (failure) failure(result.statusCode + " HTTP error");
                       break;
          }
        } else { if (failure) failure(err +" on "+restUrl); }
      });
  }

//  Upload a file (binary data) using HTTP POST request with Flic.io's http module.

function AsyncUpload(restUrl, uploadName, uploadData, success, failure)
{ 
	var uploadUrl = restUrl.replace(/\/api\/.*$/,'/upload.html');

	var i, len = 0;
	var dataStr = '';
	for(i = 0; i < uploadData.length; i++) {
		dataStr += String.fromCharCode(uploadData[i]);
	}
	var boundary = 'Zz'+Math.floor(Math.random() * 0xffffff).toString(16)+'zZ';
	var hdr = 'Content-Disposition: form-data; name="'+uploadName+'"; filename="api"\r\n'+
            'Content-Type: application/octet-stream\r\n'+
            'Content-Transfer-Encoding: binary\r\n\r\n';
	var dash = '--';
	var crlf = '\r\n';
	var parts = [dash, boundary, crlf, hdr, dataStr, crlf, dash, boundary, dash, crlf];
	for(i = 0; i < parts.length; i++) {
		len += parts[i].length;
	}
	var body = '';
	for(i = 0; i < parts.length; i++) {
		body += parts[i];
	}

	var sock = new net.Socket();
	var fullhost = uploadUrl.replace(/^[^:]*:\/\/([^\/]*)\/.*$/,'$1');
	var hostParts = fullhost.split(':');
	var hostName = hostParts[0];
	var port = (hostParts.length > 1 ? parseInt(hostParts[1]) : 80);
	var relUrl = uploadUrl.replace(/^.*\/\/[^/]*/,'');
	var httpHeader = 'POST '+relUrl+' HTTP/1.1\r\n'+
				'Content-type: multipart/form-data; boundary='+boundary+'\r\n'+
				'Host: '+hostName+'\r\n'+
				'Connection: close\r\n'+
				'\r\n';
		var requestBin = new Buffer(httpHeader.length+body.length);
		var h = httpHeader.length;
		for(i = 0; i < h; i++) {
			requestBin[i] = httpHeader.charCodeAt(i);
		}
		for(i=0;i<body.length;i++ )
			{requestBin[i+h] = body.charCodeAt(i);}
		
	  var drained = false;
	  var responded = false;
	
	
		sock.on("error", function(err) { if (failure) failure("AsyncUpload "+err.message); });
		sock.on("data", function(data)
						 { var words = data.toString().split(' ');
							 var code = parseInt(words[1]);
							 switch (code)
                { case 200: try { if (success) success();}
                            catch (e) { if (failure) failure(e); }
                            break;
                  case 404: if (failure) failure("404 Not found");
                            break;
                  case 401: if (failure) failure("401 Access denied");
                            break;
                  default:  if (failure) failure(result.statusCode + " HTTP error");
                  break;
               } 
					       responded = true;
							   if (drained && responded )
									 {
							   		//	 sock.end();
									 }
							}
					   )
		sock.on("drain",  function(){drained =true; if(drained && responded )
		{ //	sock.end();
		 } } ); // somehow closes the socket too early
		sock.connect({host:hostName, port:port}, function() {
		
		//	console.log("Connected");
			sock.write(requestBin);
			
		});
	
}

// provides a better message when connection  causes HTTP 404 error
function errDecode(err)
  { if (err.substring(0, 3) == "404") err = "device " + this.hwdId + " unplugged";
    return err;
  }


// Global function used to retreive a Yoctopuce function url based on
// YoctoHub/VirtualHub IP address, Function type  and function name. Function
// can any hardware or logical name. If functionname is empty then the
// first available function matching will be returned.
function getFunctionURL(addr, functiontype, functionName, success, failed)
  { var modname = "";
    var modserial = "";
    var fctname = functionName;
    var p = functionName.indexOf(".")
    if (p >= 0)
    { modname = functionName.substring(0, p);
      fctname = functionName.substring(p + 1);
    }

    AsyncRequest("http://" + addr + "/api/services.json",
    function (res)
      { if (!res.hasOwnProperty("whitePages"))
          { if (failed) failed("no white pages found on " + addr);
            return
          }
        if (!res.hasOwnProperty("yellowPages"))
         { if (failed) failed("no yellow pages found " + addr);
           return
         }

        if (modname != '')
        {  for (var i = 0; i < res.whitePages.length; i++)
           {  if ((res.whitePages[i].logicalname == modname) || (res.whitePages[i].serialNumber == modname))
              modserial = res.whitePages[i].serialNumber;
           }
           if (modserial == "")
           { if (failed) failed("no module named " + modname + " on " + addr);
             return
           }
        }
        if (!res.yellowPages.hasOwnProperty(functiontype))
        {  if (failed) failed("no " + functiontype + " function available on " + addr);
           return;
        }

        for (var i = 0; i < res.yellowPages[functiontype].length; i++)
        {  var hwdid = res.yellowPages[functiontype][i].hardwareId;
           var p = hwdid.indexOf(".");
           var serial = hwdid.substring(0, p);
           var fid = hwdid.substring(p + 1);
           if ((functionName == "") || (fctname == fid) || (fctname == res.yellowPages[functiontype][i].logicalName))
           if ((modserial == "") || (modserial == serial))
            { //console.log("http://" + addr + "/bySerial/" + serial + "/api/" + fid)
							return success(hwdid, "http://" + addr + "/bySerial/" + serial + "/api/" + fid);}

        }
        if (failed)
        { failed("no " + functiontype + " function named " + functionName + " available on " + addr);
          return
        }
      },
     function (err)
      { if (failed) failed(err);
        return
      }
    );
  }


// wrapper to make url retreiving from objects easier
function generic_getUrl(success, failed)
  { var self = this;
    getFunctionURL(self.addr, self.type, self.name,
    function (id, url)
    { self.url = url;
      self.hwdId = id;
      self.get_data(success, failed)
    },
    function (res)
    { if (failed) failed(res); }
  );
  return 0;
  }

// retreive a yoctopuce function JSON  data block and pass it to the sucess callback.
function generic_getData(success, failed)
  { var self = this;
    if (self.url == "") return self.get_url(
      function () {  self.get_data(success, failed) },
       failed);
    var cmd = self.url + ".json";
    AsyncRequest(cmd,
    function (res)  { success(res); },
    function (err)  { if (failed) failed(self.errDecode(err)); }
    );
  }

/*
 *   Relay function
 */

// constructor
function YRelay(addr, name)
  { this.type = "Relay"
    this.get_data = generic_getData;
    this.get_url = generic_getUrl
    this.errDecode = errDecode;
    this.addr = addr;
    this.name = name;
    this.url = "";
    this.hwdId = "";
    this.pulse = YRelay_pulse;
    this.set_state = YRelay_set_state;
    this.toggle = YRelay_toggle;
  }

// makes a pulse (switch to B to a duration then switch back to A)
// duration  : pulse durtion (ms)
// success   : callback called with function's data if call succeeded
// failed    : callback called with error Message if call failed

function YRelay_pulse(duration, success, failed)
  { var self = this;
    if (self.url == "") return self.get_url(function ()
    { self.pulse(duration, success, failed) }, failed)
    var cmd = self.url + ".json?pulse=" + duration;
    AsyncRequest(cmd, success, function (err)
    { if (failed) failed(self.errDecode(err));});
  }

// changes the relay state
// state     : false = A , true = B
// success   : callback called with function's data if call succeeded
// failed    : callback called with error Message if call failed

function YRelay_set_state(state, success, failed)
  { var self = this;
    if (self.url == "")
      return self.get_url(function () {self.set_state(state, success, failed)}, failed)
    var cmd = self.url + ".json?state=" + (state ? "1" : "0");
    AsyncRequest(cmd, success, function (err) {if (failed) failed(self.errDecode(err));});
  }

// toggles the relay state
// success   : callback called with function's data if call succeeded
// failed    : callback called with error Message if call failed

function YRelay_toggle(success, failed)
  { var self = this;
    if (self.url == "")
      return self.get_url(function (){self.toggle(success, failed) }, failed)
    var cmd = self.url + ".json?state=X";
    AsyncRequest(cmd, success, function (err){ if (failed) failed(self.errDecode(err)); });

  }


/*
 * ColorLedCluster
 */

// constructor
function YColorLedCluster(addr, name)
  { this.type = "ColorLedCluster"
    this.get_data = generic_getData;
    this.get_url = generic_getUrl
    this.errDecode = errDecode;
    this.addr = addr;
    this.name = name;
    this.url = "";
    this.hwdId = "";
    this.set_rgbColor  = YColorLedCluster_set_rgbColor;
    this.rgb_move      = YColorLedCluster_rgb_move;
	  this.rgbColorArray = YColorLedCluster_rgbColorArray;
  }

// Affect a RGB color to set of adjacent LED
// ledIndex   : index of the first LED
// count      : Affected led count
// rgbvalue   : color endoded in a 24 bit integer
// success    : callback called with function's data if call succeeded
// failed     : callback called with error Message if call failed
function YColorLedCluster_set_rgbColor(ledIndex, count, rgbvalue, success, failed)
  { var self = this;
    if (self.url == "") return self.get_url(function ()
    { self.set_rgbColor(ledIndex, count, rgbvalue, success, failed)}, failed)
    var cmd = self.url + ".json?command=SR" + Math.round(ledIndex) + "," + Math.round(count) + ',' + rgbvalue.toString(16);
    AsyncRequest(cmd, success, function (err){if (failed) failed(self.errDecode(err));});
  }

// Slowly changes the color of a set of adjacent LED. The transition is performed in the RGB space.
// ledIndex   : index of the first LED
// count      : Affected led count
// rgbvalue   : color endoded in a 24 bit integer
// delay      : transition duration in ms
// success    : callback called with function's data if call succeeded
// failed     : callback called with error Message if call failed
function YColorLedCluster_rgb_move(ledIndex, count, rgbvalue, delay, success, failed)
  { var self = this;
    if (self.url == "")
      return self.get_url(function (){self.rgb_move(ledIndex, count, rgbvalue, delay, success, failed)}, failed)
    var cmd = self.url + ".json?command=MR" + Math.round(ledIndex) + "," + Math.round(count) + ',' + rgbvalue.toString(16) + ',' + Math.round(delay);
    AsyncRequest(cmd, success, function (err) { if (failed) failed(self.errDecode(err));});
  }

// Sends 24bit RGB colors (provided as a list of integers) to the LED RGB buffer, as is.
// The first number represents the RGB value of the LED specified as parameter, the second
// number represents the RGB value of the next LED, etc.
// ledIndex : index of the first LED which should be updated
// rgbList : a list of 24bit RGB codes, in the form 0xRRGGBB

function YColorLedCluster_rgbColorArray(ledIndex,  rgbList,success, failed )
{ var self = this;
    if (self.url == "")
      return self.get_url(function (){self.rgbColorArray(ledIndex, rgbList, success, failed)}, failed)
  var res=0;
  var listlen = rgbList.length;
  var  buff = new Uint8Array(3*listlen);
  var  idx = 0;
  while (idx < listlen)
	  {   var rgb = rgbList[idx];
         buff[3*idx]      = (rgb >> 16)  &0xff;
		     buff[3*idx+1]    = (rgb >> 8)  &0xff;
		     buff[3*idx+2]    = rgb   &0xff;
         idx = idx + 1;
    }

    AsyncUpload(self.url, 'rgb:0:'+parseInt(ledIndex), buff, success,failed);
	
}

// constructor
function YTemperature(addr, name)
  { this.type = "Temperature"
    this.get_data = generic_getData;
    this.get_url = generic_getUrl
    this.errDecode = errDecode;
    this.addr = addr;
    this.name = name;
    this.url = "";
    this.hwdId = "";
    this.get_currentValue = YTemperature_getCurrentValue;
    this.get_unit = YTemperature_getUnit;
  }

/*
 *   Temperature function
 */

// retreive the measured temperature
// success   : callback called with value if call succeeded
// failed    : callback called with error Message if call failed

function YTemperature_getCurrentValue(success, failed)
  { this.get_data(
    function (data) { if (success) success(data.currentValue / 65536.0);},
    function (err) { if (failed) failed(err) }
    );
  }

// retreive the sensor unit
// success   : callback called with value if call succeeded
// failed    : callback called with error Message if call failed
function YTemperature_getUnit(success, failed)
  { this.get_data(
      function (data) { if (success) success(data.unit); },
      function (err) { if (failed) failed(err) }
    );
  }

var lastTemp = 0;
var clickHappened = false;
var ACTION_DONOTHING = 0;
var ACTION_ON = 1;
var ACTION_OFF = 2;
var currentState = ACTION_DONOTHING;
var todo = ACTION_OFF
var override = false;
var refreshNeeded =true;

function logError(err) { console.log(err);  }

function run()
 {var delta=0.25  // Schmitt trigger
  
	if (todo == ACTION_DONOTHING)
    t.get_currentValue(
      function (res)
       { console.log("temp= "+res.toFixed(1))
         if ((res >= ts + delta) && (lastTemp < ts + delta)){override=false; todo = ACTION_ON;} 
         if ((res <= ts - delta) && (lastTemp > ts - delta)){override=false; todo = ACTION_OFF;}				
				 if (lastTemp!=res) refreshNeeded=true;		 
         lastTemp = res;								
       },
      function (err) { console.log(err); });

  switch (todo)
    { case ACTION_ON:
        console.log("ON");     
        r.set_state(1, null, logError)
        currentState = ACTION_ON;
        todo = ACTION_DONOTHING;
				refreshNeeded =true;
        break;
      case ACTION_OFF:
        console.log("OFF");
        refreshNeeded =true;
        r.set_state(0, null, logError)
        currentState = ACTION_OFF;
        todo = ACTION_DONOTHING;
        break;
    }
	 
	 if (refreshNeeded)
	 { var buffer = new Uint32Array(512);
		 var color = 0x101000;
		 if (lastTemp<ts-delta) color=  0x002000;
		 if (lastTemp>ts+delta) color=  0x200000;					 
     DrawTextinBuffer(buffer, lastTemp.toFixed(1)+"°C" , 0, FontSmall, color)	 		
		 DrawTextinBuffer(buffer, (currentState==ACTION_ON?"ON":"OFF") , 30, FontSmall, 0x101010);
		 if (override) DrawTextinBuffer(buffer, "OVRD" , 45, FontSmall, 0x04040A)
		 c.rgbColorArray(0,buffer,null,logError );				
	 }	
		
  }

/*
 *
 *
 */

var FontSmall = { "height":8,
   "chars": [[0,0,0],[250,0],[224,0,224,0],[40,254,254,40,0],[100,214,76,0],[134,56,194,0],
   [118,158,114,14,0],[224,0],[124,130,0],[130,124,0],[40,16,40,0],[16,56,16,0],[1,2,0],
   [16,16,16,0],[2,0],[6,24,96,0],[254,130,254,0],[254,0],[206,146,230,0],[198,146,254,0],
   [56,72,254,0],[246,146,222,0],[254,146,222,0],[192,142,240,0],[254,146,254,0],
   [246,146,254,0],[40,0],[1,10,0],[16,40,68,0],[20,20,20,0],[68,40,16,0],[64,154,96,0],
   [124,130,154,122,0],[126,200,126,0],[254,146,124,0],[124,130,130,0],[254,130,124,0],
   [254,146,130,0],[254,144,128,0],[124,130,158,0],[254,16,254,0],[254,0],[6,2,254,0],
   [254,24,230,0],[254,2,2,0],[254,48,12,48,254,0],[254,48,12,254,0],[254,130,254,0],
   [254,144,240,0],[254,131,254,0],[254,144,110,0],[230,146,206,0],[128,254,128,0],
   [254,2,254,0],[252,2,252,0],[252,6,252,6,252,0],[198,56,198,0],[224,62,224,0],
   [134,154,226,0],[254,130,0],[192,56,6,0],[130,254,0],[64,128,64,0],[1,1,1,0],[128,64,0],
   [36,42,30,0],[254,34,28,0],[28,34,34,0],[28,34,254,0],[28,42,26,0],[32,126,160,0],
   [25,37,62,0],[254,32,30,0],[190,0],[1,190,0],[254,12,18,0],[254,0],[62,32,30,32,30,0],
   [62,32,30,0],[28,34,28,0],[63,34,28,0],[28,34,63,0],[30,32,0],[18,42,36,0],[32,254,34,0],
   [62,2,62,0],[60,6,60,0],[60,2,60,2,60,0],[54,8,54,0],[61,5,63,0],[38,42,50,0],
   [16,238,130,0],[255,0],[130,254,16,0],[16,32,16,8,16,0],[0],[0],[0],[0],[0],[0],
   [0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],[0],
   [0],[0],[0],[0],[0],[0],[0],[0],[190,0],[30,63,18,0],[2,126,146,130,0],[36,24,24,36,0],
   [232,62,232,0],[51,0],[125,85,95,0],[32,0,32,0],[62,65,93,85,65,62,0],[0],[8,20,0,8,20,0],
   [8,8,8,14,0],[8,8,0],[62,65,93,93,65,62,0],[128,128,128,128,0],[112,80,112,0],
   [18,58,18,0],[88,104,0],[104,120,0],[32,64,0],[63,2,62,0],[16,40,47,63,0],[0],
   [0],[32,120,0],[56,40,56,0],[20,8,0,20,8,0],[248,6,24,38,10,31,0],[250,4,24,32,23,29,0],
   [168,250,12,24,38,10,31,0],[12,178,4,0],[126,200,126,0],[126,200,126,0],[126,200,126,0],
   [126,200,126,0],[126,200,126,0],[126,200,126,0],[126,200,126,74,66,0],[124,131,130,0],
   [254,146,130,0],[254,146,130,0],[254,146,130,0],[254,146,130,0],[254,0],[254,0],
   [254,0],[0,254,0],[254,130,124,0],[254,48,12,254,0],[254,130,254,0],[254,130,254,0],
   [254,130,254,0],[254,130,254,0],[254,130,254,0],[20,8,20,0],[254,130,254,0],[254,2,254,0],
   [254,2,254,0],[254,2,254,0],[254,2,254,0],[224,62,224,0],[62,20,8,0],[255,146,124,0],
   [164,106,30,0],[100,170,30,0],[100,170,94,0],[164,170,158,0],[164,42,158,0],[36,170,30,0],
   [36,42,26,62,42,58,0],[28,35,34,0],[28,170,90,0],[92,170,26,0],[92,170,90,0],[156,42,154,0],
   [190,64,0],[64,190,0],[64,190,64,0],[128,62,128,0],[156,162,156,0],[190,160,30,0],
   [28,162,92,0],[92,162,28,0],[92,162,92,0],[156,162,156,0],[156,34,156,0],[8,42,8,0],
   [13,22,26,44,0],[62,130,126,0],[62,66,190,0],[62,130,62,0],[190,2,190,0],[61,133,63,0],
   [63,18,30,0],[189,5,191,0]]}

function DrawTextinBuffer(buffer, text , x, font, color)
 { 
	 for (var i=0;i<text.length; i++)
	  { var code = text.charCodeAt(i)-32;
		  for (var row =0; row<font.chars[code].length; row++  )
				{ var value= font.chars[code][row];
			    if (x<64) for (var y =0; y<font.height; y++  )
						{  if (value & (1<<y))
								{  buffer[(x*8 +y) ] = color						       
								}
						}
					x++
				 }
    }
 }

var ts = 29; // temperature threshold
var r = new YRelay("192.168.0.20", "");
var t = new YTemperature("192.168.0.21", "myTemp");
var c = new YColorLedCluster("192.168.0.23", "");

buttonManager.on("buttonSingleOrDoubleClickOrHold",
  function (obj)
  { var button = buttonManager.getButton(obj.bdaddr);
    if (obj.isSingleClick)
      { console.log("Click on " + obj.bdaddr)
			  
       switch (currentState)
        { case ACTION_ON:  todo = ACTION_OFF; override =true; run(); break;
          case ACTION_OFF: todo = ACTION_ON;  override =true; run(); break;
        }
      }
  });
		
console.log("hello");        
setInterval( function() {try {run()} catch (e) {console.log(e)}}, 1000); 


