
(*
  -------------------------------------------------------------------------
  Yoctopuce screen saver. Shut down the computer after a given time and
  controls a desklamp with a Yocto-Relay and a Yocto-Volt. For more info
  see  www.yoctopuce.com/EN/article/how-to-control-a-desk-lamp-through-usb
  --------------------------------------------------------------------------
  This is the screen saver itself


*)

unit display;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,kernel,desklamp;

type
  TScreenForm = class(TForm)
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    counter :integer;
    monitorindex : integer;
    lastMousePosition :Tpoint;
    demomode:boolean;
    previewmode :boolean;
    procedure drawit();
    procedure die();
  public
    { Public declarations }
    procedure setScreenPosition(index:integer);
    procedure setPreviewMode(handle:hwnd);
    procedure demo();
  end;

 procedure createScreenSaverForms();
 procedure ShowScreenSaver();

var
  ScreenForm : TScreenForm;
  ScreenForms:  array of  TScreenForm;

implementation

procedure  TScreenForm.setPreviewMode(handle:hwnd);
 var
  rt:trect;
 begin
   onMouseMove:=nil;
   onKeyDown:=nil;
   left    := 0;
   top     := 0;
   GetWindowRect (handle, rt);
   ShowCursor(true);
   width   := rt.right-rt.left+1;
   height  := rt.bottom-rt.top+1;
   ParentWindow := handle;
   previewmode := true;
 end;


procedure TScreenForm.setScreenPosition(index:integer);
 begin
  name    := 'ScreenForm'+inttostr(index);
  left    := Screen.Monitors[index].left;
  top     := Screen.Monitors[index].top;
  width   := Screen.Monitors[index].width;
  height  := Screen.Monitors[index].height;
  WindowState := wsMaximized;
  demomode    :=false;

 end;

{$R *.DFM}

const
  barcount =100;
var
 dieInittated :boolean = false;




 

procedure TScreenForm.Timer1Timer(Sender: TObject);
 begin
  drawit();
 end;

procedure TScreenForm.drawit();
 var
  rayon,angle,s,c :double;
  limit,i,mx,my :integer;
begin
  dec(counter);
  rayon := (height * 4.5 ) / 10;
  limit := round(barcount * counter / timeout);
  mx := round(width / 2);
  my := round(height / 2);
  canvas.font.color := $800000;
  canvas.font.height :=round(height / 20)+1;
  canvas.Brush.color:=clblack;
  if (counter>=0) then
    begin
      for i:= 0 to barcount-1 do
      begin
        if  i<limit then canvas.pen.color:= $00FF00 else canvas.pen.color :=  $002000 ;
        angle:= (i * 6.2832) / barcount + 1.57;
        s:=sin(angle);
        c:=cos(angle);
        canvas.MoveTo(mx + round( rayon*c ),     my -  round( rayon*s ));
        canvas.LineTo(mx + round( rayon*c*0.95 ),my - round( rayon*s*0.95 ));
      end;
     // text :=' '+inttostr(counter)+' ';
     // canvas.textout(round(mx-canvas.textwidth(text)/2),round(my-canvas.textheight(text)/2),text);
     end
  else
  begin
   text :='Initiating shutdown...';

   canvas.textout(round(mx-canvas.textwidth(text)/2),round(my-canvas.textheight(text)/2),text);

  end;

  if (counter<0) and not(demomode) then
   begin
     PowerOffWindows(forceshutdown);
   end;
end;



procedure TScreenForm.FormShow(Sender: TObject);
begin
   getCursorPos(lastMousePosition);
   counter:=timeout;
   timer1.enabled:=true;
   lastMousePosition.X :=-1;
   lastMousePosition.Y :=-1;
   if not(previewmode) then ShowCursor(false);
   drawit();
end;



procedure createScreenSaverForms();
 var
  i :integer;
 begin
  setlength(ScreenForms,Screen.MonitorCount);
  for i:=0 to Screen.MonitorCount-1 do
    begin
      Application.CreateForm(TscreenForm, screenForms[i]);
      screenForms[i].setScreenPosition(i);
    end;
  SystemParametersInfo(SPI_SCREENSAVERRUNNING,1,@i,0);
 end;

procedure ShowScreenSaver();
 var
   i:integer;
 begin
  for i:=0 to Screen.MonitorCount-1 do
      screenForms[i].show();
 end;


procedure TScreenForm.die();
 var
  tm :double;
  t:TDeskLampControl;

 begin
  if dieInittated then exit;
  dieInittated:=true;
  if lampOffWhenStart  then
    if LampWasOn() then
     begin

       t:= TDeskLampControl.create(VlogicName,R1logicName,R2LogicName,true,nil);
       tm:=now();
       while not(t.isCompleted()) and (now()-tm< 2.0/86400) do
        application.processMessages();
       t.free();

     end;
  application.Terminate;
 end;

procedure TScreenForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if (lastMousePosition.X>=0) then
   if (((x - lastMousePosition.X) > 10) or ((y - lastMousePosition.Y) > 10)) then die();
    lastMousePosition:=point(x,y);
end;

procedure TScreenForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 die();
end;

procedure TScreenForm.demo();
 begin
  windowstate:= wsmaximized;
  show();
 end;

procedure TScreenForm.FormCreate(Sender: TObject);
begin
  demomode    := true;  // no shutdown when counter reach 0
  previewmode := false;  // in previwe mode, mouse cursor is not hidden
  monitorindex :=0;
end;

end.
