(*
  -------------------------------------------------------------------------
  Yoctopuce screen saver. Shut down the computer after a given time and
  controls a desklamp with a Yocto-Relay and a Yocto-Volt. For more info
  see  www.yoctopuce.com/EN/article/how-to-control-a-desk-lamp-through-usb
  --------------------------------------------------------------------------
  This is the screen saver configuration widow


*)
unit config;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,kernel, ExtCtrls,desklamp;

type
  Tconfigform = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    timeoutvalue: TEdit;
    Label2: TLabel;
    force: TCheckBox;
    Bevel1: TBevel;
    Memo1: TMemo;
    TestOffBtn: TButton;
    TestOnBtn: TButton;
    EditSleepTurnoff: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    EditVlogicName: TEdit;
    EditR1logicName: TEdit;
    EditR2LogicName: TEdit;
    EditShutdownTurnoff: TCheckBox;
    Label7: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TestOnBtnClick(Sender: TObject);
    procedure TestDone(status:boolean; msg:string);
    procedure TestOffBtnClick(Sender: TObject);
  private
    { Private declarations }
    ctrlThread : TDeskLampControl;
  public
    { Public declarations }
  end;

var
  configform: Tconfigform;

implementation

uses display;

{$R *.DFM}



procedure Tconfigform.Button1Click(Sender: TObject);
begin
 timeout:= strtoint(timeoutvalue.text);
 forceshutdown:= force.checked;

  VlogicName          := EditVlogicName.text;
  R1logicName         := EditR1logicName.text;
  R2logicName         := EditR2LogicName.text;
  lampOffWhenStart    := EditSleepTurnoff.checked;
  lampOffWhenShutdown := EditShutdownTurnoff.checked;



 if (timeout<30) then timeout:=30;
 saveConfig();
 Close();
end;

procedure Tconfigform.Button2Click(Sender: TObject);
begin
 Close();
end;

procedure Tconfigform.Button3Click(Sender: TObject);
begin
ScreenForm.demo();
end;

procedure Tconfigform.FormShow(Sender: TObject);
begin
  timeoutvalue.text := inttostr(timeout);
  force.checked:= forceshutdown;
  EditVlogicName.text:=VlogicName;
  EditR1logicName.text:=R1logicName;
  EditR2LogicName.text:=R2logicName;
  EditSleepTurnoff.checked:= lampOffWhenStart;
  EditShutdownTurnoff.checked:=lampOffWhenShutdown;

end;

procedure Tconfigform.TestOnBtnClick(Sender: TObject);


begin
  TestOnBtn.enabled    := false;
  TestOffBtn.enabled   := false;
  ctrlThread := TDeskLampControl.create(VlogicName,R1logicName,R2LogicName,true,TestDone);
end;

procedure Tconfigform.TestOffBtnClick(Sender: TObject);


begin
 TestOnBtn.enabled  := false;
 TestOffBtn.enabled := false;
 ctrlThread := TDeskLampControl.create(VlogicName,R1logicName,R2LogicName,false,TestDone);

end;

procedure Tconfigform.TestDone(status:boolean; msg:string);
begin
  ctrlThread.free;
  ctrlThread:=nil;
 if not(status) then messageDlg(string(msg), mtError	,[MBok],0);
  TestOnBtn.enabled  := true;
 TestOffBtn.enabled := true;
end;





end.
