/*********************************************************************
 *
 * $Id: YSdi12SnoopingRecord.java 58923 2024-01-12 10:12:54Z seb $
 *
 * - - - - - - - - - License information: - - - - - - - - -
 *
 *  Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
 *
 *  Yoctopuce Sarl (hereafter Licensor) grants to you a perpetual
 *  non-exclusive license to use, modify, copy and integrate this
 *  file into your software for the sole purpose of interfacing
 *  with Yoctopuce products.
 *
 *  You may reproduce and distribute copies of this file in
 *  source or object form, as long as the sole purpose of this
 *  code is to interface with Yoctopuce products. You must retain
 *  this notice in the distributed source file.
 *
 *  You should refer to Yoctopuce General Terms and Conditions
 *  for additional information regarding your rights and
 *  obligations.
 *
 *  THE SOFTWARE AND DOCUMENTATION ARE PROVIDED 'AS IS' WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 *  WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS
 *  FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
 *  EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA,
 *  COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR
 *  SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
 *  LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
 *  CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
 *  BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
 *  WARRANTY, OR OTHERWISE.
 *
 *********************************************************************/

package com.yoctopuce.YoctoAPI;

//--- (generated code: YSdi12SnoopingRecord return codes)
//--- (end of generated code: YSdi12SnoopingRecord return codes)
//--- (generated code: YSdi12SnoopingRecord class start)
/**
 * YSdi12SnoopingRecord Class: Intercepted SDI12 message description, returned by sdi12Port.snoopMessages method
 *
 *
 */
@SuppressWarnings({"UnusedDeclaration", "UnusedAssignment"})
public class YSdi12SnoopingRecord
{
//--- (end of generated code: YSdi12SnoopingRecord class start)
//--- (generated code: YSdi12SnoopingRecord definitions)
    protected int _tim = 0;
    protected int _pos = 0;
    protected int _dir = 0;
    protected String _msg;

    //--- (end of generated code: YSdi12SnoopingRecord definitions)

    YSdi12SnoopingRecord(String json_str) throws YAPI_Exception
    {
        try {
            YJSONObject json = new YJSONObject(json_str);
            json.parse();
            //--- (generated code: YSdi12SnoopingRecord attributes initialization)
        //--- (end of generated code: YSdi12SnoopingRecord attributes initialization)
            if (json.has("t")) {
                _tim = json.getInt("t");
            }
            if (json.has("p")) {
                _pos = json.getInt("p");
            }
            if (json.has("m")) {
                final String m = json.getString("m");
                _dir = (m.charAt(0) == '<' ? 1 : 0);
                _msg = m.substring(1);
            }
        } catch (Exception e) {
            throw new YAPI_Exception(YAPI.IO_ERROR, "invalid json struct for YSdi12SnoopingRecord");
        }

    }

    //--- (generated code: YSdi12SnoopingRecord implementation)

    /**
     * Returns the elapsed time, in ms, since the beginning of the preceding message.
     *
     * @return the elapsed time, in ms, since the beginning of the preceding message.
     */
    public int get_time()
    {
        return _tim;
    }

    /**
     * Returns the absolute position of the message end.
     *
     * @return the absolute position of the message end.
     */
    public int get_pos()
    {
        return _pos;
    }

    /**
     * Returns the message direction (RX=0, TX=1).
     *
     * @return the message direction (RX=0, TX=1).
     */
    public int get_direction()
    {
        return _dir;
    }

    /**
     * Returns the message content.
     *
     * @return the message content.
     */
    public String get_message()
    {
        return _msg;
    }

    //--- (end of generated code: YSdi12SnoopingRecord implementation)
}

