/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.NotificationHandler;
import com.yoctopuce.YoctoAPI.TCPNotificationHandler;
import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.WSNotificationHandler;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;

public class YHTTPHub
extends YGenericHub {
    public static final int YIO_DEFAULT_TCP_TIMEOUT = 20000;
    private static final int YIO_1_MINUTE_TCP_TIMEOUT = 60000;
    private static final int YIO_10_MINUTES_TCP_TIMEOUT = 600000;
    private final Object _callbackSession;
    private NotificationHandler _notificationHandler;
    private Thread _thread;
    private String _http_realm = "";
    private String _nounce = "";
    private int _nounce_count = 0;
    private String _ha1 = "";
    private String _opaque = "";
    private Random _randGen = new Random();
    private MessageDigest mdigest;
    private int _authRetryCount = 0;
    private boolean _writeProtected = false;
    private final Object _authLock = new Object();
    YGenericHub.HTTPParams _runtime_http_params = null;
    boolean _usePureHTTP = false;
    ArrayList<PortInfo> _portInfo = new ArrayList();
    private HubMode _hubMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needRetryWithAuth() {
        Object object = this._authLock;
        synchronized (object) {
            return this._runtime_http_params.getUser().length() != 0 && this._runtime_http_params.getPass().length() != 0 && this._authRetryCount++ <= 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authSucceded() {
        Object object = this._authLock;
        synchronized (object) {
            this._authRetryCount = 0;
        }
    }

    @Override
    public synchronized void addKnownURL(String url) {
        super.addKnownURL(url);
        YGenericHub.HTTPParams params = new YGenericHub.HTTPParams(url);
        if (params.hasAuthParam() && !this._URL_params.hasAuthParam()) {
            this._URL_params.updateAuth(params.getUser(), params.getPass());
            if (this._runtime_http_params != null) {
                this._runtime_http_params.updateAuth(params.getUser(), params.getPass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseWWWAuthenticate(String header) {
        Object object = this._authLock;
        synchronized (object) {
            String[] tags;
            int pos = header.toLowerCase().indexOf("\r\nwww-authenticate:");
            if (pos == -1) {
                return;
            }
            int eol = (header = header.substring(pos + 19)).indexOf(13);
            if (eol >= 0) {
                header = header.substring(0, eol);
            }
            this._http_realm = "";
            this._nounce = "";
            this._opaque = "";
            this._nounce_count = 0;
            if (!(header = header.trim()).startsWith("Digest ")) {
                return;
            }
            header = header.substring(7).trim();
            block13: for (String tag : tags = header.split(",")) {
                int eq = tag.indexOf("=");
                if (eq < 0) continue;
                String name = tag.substring(0, eq).trim();
                String value = tag.substring(eq + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                switch (name) {
                    case "realm": {
                        this._http_realm = value;
                        continue block13;
                    }
                    case "nonce": {
                        this._nounce = value;
                        continue block13;
                    }
                    case "opaque": {
                        this._opaque = value;
                    }
                }
            }
            String plaintext = this._runtime_http_params.getUser() + ":" + this._http_realm + ":" + this._runtime_http_params.getPass();
            this.mdigest.reset();
            this.mdigest.update(plaintext.getBytes(this._yctx._deviceCharset));
            byte[] digest = this.mdigest.digest();
            this._ha1 = YAPIContext._bytesToHexStr(digest, 0, digest.length).toLowerCase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAuthorization(String request) {
        Object object = this._authLock;
        synchronized (object) {
            if (this._runtime_http_params.getUser().length() == 0 || this._runtime_http_params.getPass().length() == 0) {
                return "";
            }
            ++this._nounce_count;
            int pos = request.indexOf(32);
            String method = request.substring(0, pos);
            int enduri = request.indexOf(32, pos + 1);
            if (enduri < 0) {
                enduri = request.length();
            }
            String uri = request.substring(pos + 1, enduri);
            String nc = String.format("%08x", this._nounce_count);
            String cnonce = String.format("%08x", this._randGen.nextInt());
            String plaintext = method + ":" + uri;
            this.mdigest.reset();
            this.mdigest.update(plaintext.getBytes(this._yctx._deviceCharset));
            byte[] digest = this.mdigest.digest();
            String ha2 = YAPIContext._bytesToHexStr(digest, 0, digest.length).toLowerCase();
            plaintext = this._ha1 + ":" + this._nounce + ":" + nc + ":" + cnonce + ":auth:" + ha2;
            this.mdigest.reset();
            this.mdigest.update(plaintext.getBytes());
            digest = this.mdigest.digest();
            String response = YAPIContext._bytesToHexStr(digest, 0, digest.length).toLowerCase();
            return String.format("Authorization: Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", qop=auth, nc=%s, cnonce=\"%s\", response=\"%s\", opaque=\"%s\"\r\n", this._runtime_http_params.getUser(), this._http_realm, this._nounce, uri, nc, cnonce, response, this._opaque);
        }
    }

    @Override
    public void requestStop() {
        NotificationHandler handler = this._notificationHandler;
        if (handler != null) {
            boolean requestsUnfinished = false;
            try {
                requestsUnfinished = handler.waitAndFreeAsyncTasks(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            if (requestsUnfinished) {
                this._yctx._Log(String.format("Stop hub %s before all async request has ended", this.getHost()));
            }
        }
    }

    @Override
    public String getConnectionUrl() {
        return this._runtime_http_params.getUrl(true, false, true);
    }

    YHTTPHub(YAPIContext yctx, YGenericHub.HTTPParams httpParams, boolean reportConnnectionLost, Object session) throws YAPI_Exception {
        super(yctx, httpParams, reportConnnectionLost);
        this._callbackSession = session;
        try {
            this.mdigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new YAPI_Exception(-3, "No MD5 provider");
        }
    }

    void yhubUseBestProto() throws YAPI_Exception {
        String cur_proto = this._URL_params.getProto();
        this._runtime_http_params = null;
        this._hubMode = HubMode.SECURE;
        if (this._portInfo.isEmpty()) {
            this._runtime_http_params = new YGenericHub.HTTPParams(this._URL_params);
        } else {
            if (this._usePureHTTP) {
                if (cur_proto.equals("ws") || cur_proto.equals("wss")) {
                    throw new YAPI_Exception(-3, "Websocket protocol is not supported by VirtualHub-4web.");
                }
                for (PortInfo portInfo : this._portInfo) {
                    if (!portInfo.proto.startsWith("http")) continue;
                    this._yctx._Log(String.format("Hub %s will use %s proto on port %d\n", this._URL_params.getHost(), portInfo.proto, portInfo.port));
                    this._runtime_http_params = new YGenericHub.HTTPParams(this._URL_params, portInfo.proto, portInfo.port);
                    break;
                }
            } else {
                int best_port = 0;
                String best_proto = "ws";
                if (this._portInfo.get((int)0).proto.equals("http") || this._portInfo.get((int)0).proto.equals("ws")) {
                    this._hubMode = HubMode.LEGACY;
                }
                for (PortInfo portInfo : this._portInfo) {
                    if (this._hubMode == HubMode.SECURE && (portInfo.proto.equals("http") || portInfo.proto.equals("ws"))) {
                        this._hubMode = HubMode.MIXED;
                    }
                    if (cur_proto.equals("auto") && best_port == 0 && (portInfo.proto.startsWith("http") || portInfo.proto.startsWith("ws"))) {
                        best_proto = portInfo.proto;
                        best_port = portInfo.port;
                    }
                    if (!cur_proto.equals("secure") || best_port != 0 || !portInfo.proto.equals("https") && !portInfo.proto.equals("wss")) continue;
                    best_proto = portInfo.proto;
                    best_port = portInfo.port;
                }
                if (best_port != 0) {
                    this._yctx._Log(String.format("Hub %s will use %s proto on port %d\n", this._URL_params.getHost(), best_proto, best_port));
                    this._runtime_http_params = new YGenericHub.HTTPParams(this._URL_params, best_proto, best_port);
                }
            }
            if (this._runtime_http_params == null) {
                this._runtime_http_params = new YGenericHub.HTTPParams(this._URL_params);
            }
        }
    }

    @Override
    synchronized void startNotifications() throws YAPI_Exception {
        block13: {
            if (!this.isEnabled()) {
                return;
            }
            if (this._notificationHandler != null) {
                throw new YAPI_Exception(-2, "notification already started");
            }
            this._usePureHTTP = false;
            this._portInfo.clear();
            if (this._URL_params.testInfoJson()) {
                boolean https_req = this._URL_params.useSecureSocket();
                if (this._URL_params.getPort() == 4443 || this._URL_params.useSecureSocket()) {
                    https_req = true;
                }
                String url = String.format("%s://%s:%d%s/info.json", https_req ? "https" : "http", this._URL_params.getHost(), this._URL_params.getPort(), this._URL_params.getSubDomain());
                try {
                    byte[] raw = this._yctx.BasicHTTPRequest(url, this._networkTimeoutMs, 0);
                    String json_str = new String(raw, this._yctx._deviceCharset);
                    YJSONObject json = new YJSONObject(json_str);
                    try {
                        json.parse();
                    }
                    catch (Exception e) {
                        throw new YAPI_Exception(-8, "Invalid info.json file", e);
                    }
                    if (json.has("serialNumber")) {
                        this.updateHubSerial(json.getString("serialNumber"));
                    }
                    if (json.has("protocol") && json.getString("protocol").equals("HTTP/1.1")) {
                        this._usePureHTTP = true;
                    }
                    if (!json.has("port")) break block13;
                    YJSONArray ports = json.getYJSONArray("port");
                    int i = 0;
                    while (i < ports.length()) {
                        String proto_port = ports.getString(i++);
                        String[] split = proto_port.split(":");
                        String proto = split[0];
                        int port = Integer.parseInt(split[1]);
                        if (port != 0) {
                            this._portInfo.add(new PortInfo(proto, port));
                            continue;
                        }
                        break;
                    }
                }
                catch (YAPI_Exception ex) {
                    if (ex.errorType == -15 || ex.errorType == -20) {
                        throw ex;
                    }
                    if (!this._URL_params.useSecureSocket()) break block13;
                    throw ex;
                }
            }
        }
        this.yhubUseBestProto();
        this._notificationHandler = this._runtime_http_params.useWebSocket() ? new WSNotificationHandler(this, this._callbackSession) : new TCPNotificationHandler(this);
        this._thread = new Thread((Runnable)this._notificationHandler, this._notificationHandler.getThreadLabel());
        this._thread.start();
    }

    @Override
    synchronized void stopNotifications() {
        if (this._notificationHandler != null) {
            try {
                boolean requestsUnfinished = this._notificationHandler.waitAndFreeAsyncTasks(5000L);
                if (requestsUnfinished) {
                    this._yctx._Log(String.format("Stop hub %s before all async request has ended", this.getHost()));
                }
                this._thread.interrupt();
                this._thread.join(10000L);
            }
            catch (InterruptedException e) {
                this._thread = null;
            }
            this._notificationHandler = null;
        }
        this.removeAllDevices();
    }

    @Override
    void release() {
    }

    @Override
    String getRootUrl() {
        return this._runtime_http_params.getUrl();
    }

    @Override
    boolean isSameHub(String url, Object request, Object response, Object session) {
        boolean sameHub = super.isSameHub(url, request, response, session);
        YGenericHub.HTTPParams params = new YGenericHub.HTTPParams(url);
        if (!sameHub && this._runtime_http_params != null) {
            String paramsUrl = params.getUrl(false, false, false);
            sameHub = paramsUrl.equals(this._runtime_http_params.getUrl(false, false, false));
        }
        return sameHub && (this._callbackSession == null || this._callbackSession.equals(session));
    }

    @Override
    synchronized void updateDeviceList(boolean forceupdate) throws YAPI_Exception, InterruptedException {
        String json_data;
        if (!this.isEnabled()) {
            return;
        }
        long now = YAPI.GetTickCount();
        if (forceupdate) {
            this._devListExpires = 0L;
        }
        if (this._devListExpires > now) {
            return;
        }
        if (this._notificationHandler == null || !this._notificationHandler.isConnected()) {
            this._lastErrorMessage = "hub " + this._runtime_http_params.getUrl() + " is not reachable";
            this._lastErrorType = -7;
            if (this._reportConnnectionLost) {
                throw new YAPI_Exception(this._lastErrorType, this._lastErrorMessage);
            }
            this.removeAllDevices();
            return;
        }
        try {
            json_data = new String(this._notificationHandler.hubRequestSync("GET /api.json", null, this._networkTimeoutMs), Charset.forName("ISO_8859_1"));
        }
        catch (YAPI_Exception ex) {
            this._lastErrorMessage = ex.getLocalizedMessage();
            this._lastErrorType = ex.errorType;
            if (this._reportConnnectionLost && this.isEnabled()) {
                throw ex;
            }
            this.removeAllDevices();
            return;
        }
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        try {
            YJSONObject loadval = new YJSONObject(json_data);
            loadval.parse();
            if (!loadval.has("services") || !loadval.getYJSONObject("services").has("whitePages")) {
                throw new YAPI_Exception(-2, "Device " + this._URL_params.getHost() + " is not a hub");
            }
            String serial = loadval.getYJSONObject("module").getString("serialNumber");
            this.updateHubSerial(serial);
            YJSONArray whitePages_json = loadval.getYJSONObject("services").getYJSONArray("whitePages");
            YJSONObject yellowPages_json = loadval.getYJSONObject("services").getYJSONObject("yellowPages");
            if (loadval.has("network")) {
                String adminpass = loadval.getYJSONObject("network").getString("adminPassword");
                this._writeProtected = adminpass.length() > 0;
            }
            Set<String> keys = yellowPages_json.getKeys();
            for (String classname : keys) {
                YJSONArray yprecs_json = yellowPages_json.getYJSONArray(classname);
                ArrayList<YPEntry> yprecs_arr = new ArrayList<YPEntry>(yprecs_json.length());
                for (int i = 0; i < yprecs_json.length(); ++i) {
                    YPEntry yprec = new YPEntry(yprecs_json.getYJSONObject(i));
                    yprecs_arr.add(yprec);
                }
                yellowPages.put(classname, yprecs_arr);
            }
            this._serialByYdx.clear();
            for (int i = 0; i < whitePages_json.length(); ++i) {
                YJSONObject jsonObject = whitePages_json.getYJSONObject(i);
                WPEntry devinfo = new WPEntry(jsonObject);
                int index = jsonObject.getInt("index");
                this._serialByYdx.put(index, devinfo.getSerialNumber());
                whitePages.add(devinfo);
            }
        }
        catch (Exception e) {
            this._lastErrorMessage = "Request failed, could not parse API result for " + this._URL_params.getHost();
            this._lastErrorType = -8;
            throw new YAPI_Exception(this._lastErrorType, this._lastErrorMessage, e);
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
        now = YAPI.GetTickCount();
        this._devListExpires = this._isNotifWorking ? now + this._yctx._deviceListValidityMs : now + 500L;
    }

    @Override
    ArrayList<String> firmwareUpdate(String serial, YFirmwareFile firmware, byte[] settings, YGenericHub.UpdateProgress progress) throws YAPI_Exception, InterruptedException {
        boolean use_self_flash = false;
        Object baseurl = "";
        boolean need_reboot = true;
        if (this._hubSerialNumber.startsWith("VIRTHUB")) {
            use_self_flash = false;
        } else if (serial.equals(this._hubSerialNumber)) {
            use_self_flash = true;
        } else {
            try {
                this._notificationHandler.hubRequestSync("GET /bySerial/" + serial + "/flash.json?a=state", null, this._networkTimeoutMs);
                baseurl = "/bySerial/" + serial;
                use_self_flash = true;
            }
            catch (YAPI_Exception yAPI_Exception) {
                // empty catch block
            }
        }
        progress.firmware_progress(5, "Enter in bootloader");
        ArrayList<String> bootloaders = this.getBootloaders();
        boolean is_shield = serial.startsWith("YHUBSHL1");
        for (String bl : bootloaders) {
            if (bl.equals(serial)) {
                need_reboot = false;
                continue;
            }
            if (!is_shield || !bl.startsWith("YHUBSHL1")) continue;
            throw new YAPI_Exception(-8, "Only one YoctoHub-Shield is allowed in update mode");
        }
        if (!use_self_flash && need_reboot && bootloaders.size() >= 4) {
            throw new YAPI_Exception(-8, "Too many devices in update mode");
        }
        byte[] bytes = this._notificationHandler.hubRequestSync("GET " + (String)baseurl + "/flash.json?a=state", null, this._networkTimeoutMs);
        String uploadstate = new String(bytes);
        try {
            YJSONObject uploadres = new YJSONObject(uploadstate);
            uploadres.parse();
            String state = uploadres.getString("state");
            if (state.equals("uploading") || state.equals("flashing")) {
                throw new YAPI_Exception(-8, "Cannot start firmware update: busy (" + state + ")");
            }
        }
        catch (Exception ex) {
            throw new YAPI_Exception(-8, "invalid json response :" + ex.getLocalizedMessage());
        }
        progress.firmware_progress(10, "Send firmware file");
        byte[] head_body = YDevice.formatHTTPUpload("firmware", firmware.getData());
        this._notificationHandler.hubRequestSync("POST " + (String)baseurl + "/upload.html", head_body, 0);
        bytes = this._notificationHandler.hubRequestSync("GET " + (String)baseurl + "/flash.json?a=state", null, 600000);
        String uploadresstr = new String(bytes);
        try {
            YJSONObject uploadres = new YJSONObject(uploadresstr);
            uploadres.parse();
            if (!uploadres.getString("state").equals("valid")) {
                throw new YAPI_Exception(-8, "Upload of firmware failed: invalid firmware(" + uploadres.getString("state") + ")");
            }
            if (uploadres.getInt("progress") != 100) {
                throw new YAPI_Exception(-8, "Upload of firmware failed: incomplete upload");
            }
        }
        catch (Exception ex) {
            throw new YAPI_Exception(-8, "invalid json response :" + ex.getLocalizedMessage());
        }
        if (use_self_flash) {
            byte[] startupConf;
            try {
                String json = new String(settings);
                YJSONObject jsonObject = new YJSONObject(json);
                jsonObject.parse();
                YJSONObject settingsOnly = jsonObject.getYJSONObject("api");
                settingsOnly.remove("services");
                String startupConfStr = new String(settingsOnly.toJSON());
                startupConf = startupConfStr.getBytes(this._yctx._deviceCharset);
            }
            catch (Exception ex) {
                startupConf = new byte[]{};
            }
            progress.firmware_progress(20, "Upload startupConf.json");
            head_body = YDevice.formatHTTPUpload("startupConf.json", startupConf);
            this._notificationHandler.hubRequestSync("POST " + (String)baseurl + "/upload.html", head_body, 600000);
            progress.firmware_progress(20, "Upload firmwareConf");
            head_body = YDevice.formatHTTPUpload("firmwareConf", startupConf);
            this._notificationHandler.hubRequestSync("POST " + (String)baseurl + "/upload.html", head_body, 600000);
        }
        if (!use_self_flash) {
            if (need_reboot) {
                this._notificationHandler.hubRequestSync("GET /bySerial/" + serial + "/api/module/rebootCountdown?rebootCountdown=-2", null, this._networkTimeoutMs);
            }
            long timeout = YAPI.GetTickCount() + 20000L;
            boolean found = false;
            progress.firmware_progress(40, "Wait for device to be in bootloader");
            do {
                ArrayList<String> list = this.getBootloaders();
                for (String bl : list) {
                    if (!bl.equals(serial)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Thread.sleep(100L);
            } while (!found && YAPI.GetTickCount() < timeout);
            progress.firmware_progress(45, "Flash firmware");
            byte[] res = this._notificationHandler.hubRequestSync("GET /flash.json?a=flash&s=" + serial, null, 600000);
            try {
                String jsonstr = new String(res);
                YJSONObject flashres = new YJSONObject(jsonstr);
                flashres.parse();
                YJSONArray list = flashres.getYJSONArray("logs");
                ArrayList<String> logs = new ArrayList<String>(list.length());
                for (int i = 0; i < list.length(); ++i) {
                    logs.add(list.getString(i));
                }
                return logs;
            }
            catch (Exception ex) {
                throw new YAPI_Exception(-8, "invalid response");
            }
        }
        progress.firmware_progress(40, "Flash firmware");
        this._notificationHandler.hubRequestSync("GET " + (String)baseurl + "/api/module/rebootCountdown?rebootCountdown=-1003", null, this._networkTimeoutMs);
        Thread.sleep(7000L);
        return null;
    }

    @Override
    synchronized void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception, InterruptedException {
        if (this._notificationHandler == null || !this._notificationHandler.isConnected()) {
            throw new YAPI_Exception(-7, "hub " + this._URL_params.getUrl() + " is not reachable");
        }
        if (this._writeProtected && !this._notificationHandler.hasRwAccess()) {
            throw new YAPI_Exception(-12, "Access denied: admin credentials required");
        }
        this._notificationHandler.devRequestAsync(device, req_first_line, req_head_and_body, asyncResult, asyncContext);
    }

    @Override
    synchronized byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception, InterruptedException {
        if (this._notificationHandler == null || !this._notificationHandler.isConnected()) {
            throw new YAPI_Exception(-7, "hub " + this._URL_params.getUrl() + " is not reachable");
        }
        int tcpTimeout = this._networkTimeoutMs;
        if (req_first_line.contains("/@YCB")) {
            throw new YAPI_Exception(-3, "Preloading of URL is only supported for HTTP callback.");
        }
        if (req_first_line.contains("/testcb.txt") || req_first_line.contains("/logger.json") || req_first_line.contains("/rxmsg.json") || req_first_line.contains("/rxdata.bin") || req_first_line.contains("/at.txt") || req_first_line.contains("/files.json")) {
            tcpTimeout = 60000;
        } else if (req_first_line.contains("/flash.json") || req_first_line.contains("/upload.html")) {
            tcpTimeout = 600000;
        }
        return this._notificationHandler.devRequestSync(device, req_first_line, req_head_and_body, tcpTimeout, progress, context);
    }

    String getHost() {
        return this._runtime_http_params.getHost();
    }

    public int getPort() {
        return this._runtime_http_params.getPort();
    }

    @Override
    public synchronized ArrayList<String> getBootloaders() throws YAPI_Exception, InterruptedException {
        ArrayList<String> res = new ArrayList<String>();
        byte[] raw_data = this._notificationHandler.hubRequestSync("GET /flash.json?a=list", null, this._networkTimeoutMs);
        String jsonstr = new String(raw_data);
        try {
            YJSONObject flashres = new YJSONObject(jsonstr);
            flashres.parse();
            YJSONArray list = flashres.getYJSONArray("list");
            for (int i = 0; i < list.length(); ++i) {
                res.add(list.getString(i));
            }
        }
        catch (Exception ex) {
            throw new YAPI_Exception(-8, "Unable to retrieve bootloader list");
        }
        return res;
    }

    @Override
    public int ping(int mstimeout) throws YAPI_Exception {
        this.startNotifications();
        try {
            this._notificationHandler.hubRequestSync("GET /api/module/firmwareRelease.json", null, mstimeout);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.stopNotifications();
        }
        return 0;
    }

    @Override
    boolean isCallbackMode() {
        return this._callbackSession != null;
    }

    @Override
    boolean isReadOnly() {
        return this._writeProtected && !this._notificationHandler.hasRwAccess();
    }

    @Override
    public boolean isOnline() {
        return this._notificationHandler != null && this._notificationHandler.isConnected();
    }

    public Socket OpenConnectedSocket(InetAddress addr, int port, int mstimeout) throws YAPI_Exception {
        Socket socket;
        InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
        if (this._runtime_http_params.useSecureSocket()) {
            try {
                int sslFlags = 0;
                if (this._hubMode == HubMode.MIXED || this._hubMode == HubMode.LEGACY) {
                    sslFlags = 7;
                }
                socket = this._yctx.CreateSSLSocket(sslFlags);
                socket.connect(sockaddr, mstimeout);
            }
            catch (IOException e) {
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
        }
        socket = new Socket();
        try {
            socket.connect(sockaddr, mstimeout);
        }
        catch (IOException e) {
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
        return socket;
    }

    public String getBaseUrl(boolean withProto, boolean withUserPass, boolean withEndSlash) {
        return this._runtime_http_params.getUrl(withProto, withUserPass, withEndSlash);
    }

    static enum HubMode {
        LEGACY,
        MIXED,
        SECURE,
        PROTO_UNKNOWN;

    }

    static class PortInfo {
        String proto;
        int port;

        public PortInfo(String proto, int port) {
            this.proto = proto;
            this.port = port;
        }
    }
}

