/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.NotificationHandler;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import com.yoctopuce.YoctoAPI.yHTTPRequest;
import java.util.HashMap;
import java.util.Locale;

class TCPNotificationHandler
extends NotificationHandler {
    private volatile boolean _connected = false;
    private volatile boolean _connecting = true;
    private HashMap<YDevice, yHTTPRequest> _httpReqByDev = new HashMap();

    TCPNotificationHandler(YHTTPHub hub) {
        super(hub);
    }

    @Override
    String getThreadLabel() {
        return "TCPNotHandler_" + this._hub._runtime_http_params.toString();
    }

    @Override
    public void run() {
        yHTTPRequest yreq = new yHTTPRequest(this._hub, "Notification of " + this._hub.getRootUrl());
        while (!Thread.currentThread().isInterrupted()) {
            if (this._error_delay > 0) {
                try {
                    Thread.sleep(this._error_delay);
                }
                catch (InterruptedException ex) {
                    this._connected = false;
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                yreq._requestReserve();
                String notUrl = this._notifyPos < 0L ? "GET /not.byn" : String.format(Locale.US, "GET /not.byn?abs=%d", this._notifyPos);
                yreq._requestStart(notUrl, null, 0L, null, null);
                this._connected = true;
                this._connecting = false;
                Object fifo = "";
                do {
                    int pos;
                    try {
                        this._hub.testLogPull();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                        throw new YAPI_Exception(e.getLocalizedMessage());
                    }
                    yreq._requestProcesss();
                    byte[] partial = yreq.getPartialResult();
                    if (partial != null) {
                        fifo = (String)fifo + new String(partial);
                    }
                    while ((pos = ((String)fifo).indexOf("\n")) >= 0) {
                        String line = ((String)fifo).substring(0, pos + 1);
                        if (line.indexOf(27) == -1) {
                            this.handleNetNotification(line);
                        }
                        fifo = ((String)fifo).substring(pos + 1);
                        if (pos >= 0) continue;
                    }
                    this._error_delay = 0;
                } while (!Thread.currentThread().isInterrupted());
                yreq._requestStop();
                yreq._requestRelease();
            }
            catch (YAPI_Exception ex) {
                this._connected = false;
                yreq._requestStop();
                yreq._requestRelease();
                ++this._notifRetryCount;
                this._hub._isNotifWorking = false;
                this._error_delay = 100 << (this._notifRetryCount > 4 ? 4 : this._notifRetryCount);
            }
        }
        yreq._requestStop();
        yreq._requestRelease();
    }

    @Override
    byte[] hubRequestSync(String req_first_line, byte[] req_head_and_body, int mstimeout) throws YAPI_Exception {
        yHTTPRequest req = new yHTTPRequest(this._hub, "request to " + this._hub.getHost());
        return req.RequestSync(req_first_line, req_head_and_body, mstimeout);
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body, int mstimeout, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception {
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this._hub, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        return req.RequestSync(req_first_line, req_head_and_body, mstimeout);
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this._hub, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        req.RequestAsync(req_first_line, req_head_and_body, asyncResult, asyncContext);
    }

    @Override
    boolean waitAndFreeAsyncTasks(long timeout) throws InterruptedException {
        for (yHTTPRequest req : this._httpReqByDev.values()) {
            req.WaitRequestEnd(timeout);
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this._sendPingNotification) {
            return this._lastPing + 6000L > System.currentTimeMillis();
        }
        return this._connecting || this._connected;
    }

    @Override
    public boolean hasRwAccess() {
        return this._hub._runtime_http_params.getUser().equals("admin");
    }
}

