/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YJSONContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class YJSONString
extends YJSONContent {
    private String _stringValue;

    YJSONString(String data, int start, int stop) {
        super(data, start, stop, YJSONContent.YJSONType.STRING);
    }

    YJSONString(String data) {
        super(data, 0, data.length(), YJSONContent.YJSONType.STRING);
    }

    YJSONString() {
        super(YJSONContent.YJSONType.STRING);
    }

    @Override
    int parse() throws Exception {
        StringBuilder value = new StringBuilder();
        int cur_pos = YJSONString.SkipGarbage(this._data, this._data_start, this._data_boundary);
        if (cur_pos >= this._data_boundary || this._data.charAt(cur_pos) != '\"') {
            throw new Exception(this.formatError("double quote was expected", cur_pos));
        }
        int str_start = ++cur_pos;
        YJSONContent.Tjstate state = YJSONContent.Tjstate.JWAITFORSTRINGVALUE;
        while (cur_pos < this._data_boundary) {
            char sti = this._data.charAt(cur_pos);
            switch (state) {
                case JWAITFORSTRINGVALUE: {
                    if (sti == '\\') {
                        value.append(this._data.substring(str_start, cur_pos));
                        str_start = cur_pos;
                        state = YJSONContent.Tjstate.JWAITFORSTRINGVALUE_ESC;
                        break;
                    }
                    if (sti == '\"') {
                        value.append(this._data.substring(str_start, cur_pos));
                        this._stringValue = value.toString();
                        this._data_len = cur_pos + 1 - this._data_start;
                        return this._data_len;
                    }
                    if (sti >= ' ') break;
                    throw new Exception(this.formatError("invalid char: was expecting string value", cur_pos));
                }
                case JWAITFORSTRINGVALUE_ESC: {
                    value.append(sti);
                    state = YJSONContent.Tjstate.JWAITFORSTRINGVALUE;
                    str_start = cur_pos + 1;
                    break;
                }
                default: {
                    throw new Exception(this.formatError("invalid state for YJSONObject", cur_pos));
                }
            }
            ++cur_pos;
        }
        throw new Exception(this.formatError("unexpected end of data", cur_pos));
    }

    @Override
    byte[] toJSON() {
        byte[] stringValueBytes = this._stringValue.getBytes();
        ByteArrayOutputStream res = new ByteArrayOutputStream(stringValueBytes.length * 2);
        try {
            res.write(34);
            int len = stringValueBytes.length;
            block12: for (int i = 0; i < len; ++i) {
                char c = (char)stringValueBytes[i];
                switch (c) {
                    case '\"': {
                        res.write("\\\"".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '\\': {
                        res.write("\\\\".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '/': {
                        res.write("\\/".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '\b': {
                        res.write("\\b".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '\f': {
                        res.write("\\f".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '\n': {
                        res.write("\\n".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '\r': {
                        res.write("\\r".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    case '\t': {
                        res.write("\\t".getBytes("ISO-8859-1"));
                        continue block12;
                    }
                    default: {
                        res.write(c);
                    }
                }
            }
            res.write(34);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toByteArray();
    }

    String getString() {
        return this._stringValue;
    }

    public String toString() {
        return this._stringValue;
    }

    void setContent(String value) {
        this._stringValue = value;
    }
}

