/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YHub;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YPEntry;
import com.yoctopuce.YoctoAPI.YUSBHub;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class YAPI {
    public static final String INVALID_STRING = "!INVALID!";
    public static final double INVALID_DOUBLE = -1.79769313486231E308;
    static final double MAX_DOUBLE = Double.MAX_VALUE;
    static final double MIN_DOUBLE = Double.MIN_VALUE;
    public static final int INVALID_INT = Integer.MIN_VALUE;
    public static final long INVALID_LONG = -9223372036854775807L;
    public static final int INVALID_UINT = -1;
    public static final String YOCTO_API_VERSION_STR = "2.1";
    public static final String YOCTO_API_BUILD_STR = "66624";
    public static final int YOCTO_VENDORID = 9440;
    public static final int YOCTO_DEVID_FACTORYBOOT = 1;
    public static final int YOCTO_DEVID_BOOTLOADER = 2;
    static final int HASH_BUF_SIZE = 28;
    public static final int YOCTO_DEFAULT_PORT = 4444;
    public static final int YOCTO_DEFAULT_HTTPS_PORT = 4443;
    public static final int SUCCESS = 0;
    public static final int NOT_INITIALIZED = -1;
    public static final int INVALID_ARGUMENT = -2;
    public static final int NOT_SUPPORTED = -3;
    public static final int DEVICE_NOT_FOUND = -4;
    public static final int VERSION_MISMATCH = -5;
    public static final int DEVICE_BUSY = -6;
    public static final int TIMEOUT = -7;
    public static final int IO_ERROR = -8;
    public static final int NO_MORE_DATA = -9;
    public static final int EXHAUSTED = -10;
    public static final int DOUBLE_ACCES = -11;
    public static final int UNAUTHORIZED = -12;
    public static final int RTC_NOT_READY = -13;
    public static final int FILE_NOT_FOUND = -14;
    public static final int SSL_ERROR = -15;
    public static final int RFID_SOFT_ERROR = -16;
    public static final int RFID_HARD_ERROR = -17;
    public static final int BUFFER_TOO_SMALL = -18;
    public static final int DNS_ERROR = -19;
    public static final int SSL_UNK_CERT = -20;
    public static final int NO_TRUSTED_CA_CHECK = 1;
    public static final int NO_EXPIRATION_CHECK = 2;
    public static final int NO_HOSTNAME_CHECK = 4;
    public static final int LEGACY = 8;
    static final String DefaultEncoding = "ISO-8859-1";
    static final int YOCTO_CALIB_TYPE_OFS = 30;
    public static final int YOCTO_MANUFACTURER_LEN = 20;
    public static final int YOCTO_SERIAL_LEN = 20;
    public static final int YOCTO_BASE_SERIAL_LEN = 8;
    public static final int YOCTO_PRODUCTNAME_LEN = 28;
    public static final int YOCTO_FIRMWARE_LEN = 22;
    public static final int YOCTO_LOGICAL_LEN = 20;
    public static final int YOCTO_FUNCTION_LEN = 20;
    static final int YOCTO_PUBVAL_SIZE = 6;
    static final int YOCTO_PUBVAL_LEN = 16;
    static final int YOCTO_PASS_LEN = 20;
    static final int YOCTO_REALM_LEN = 20;
    public static final int DETECT_NONE = 0;
    public static final int DETECT_USB = 1;
    public static final int DETECT_NET = 2;
    public static final int RESEND_MISSING_PKT = 4;
    public static final int DETECT_ALL = 3;
    static final HashMap<String, YPEntry.BaseClass> _BaseType = new HashMap();
    private static HashMap<Long, YAPIContext> _MultipleYAPI;
    private static YAPIContext _SingleYAPI;

    public static synchronized void SetThreadSpecificMode() throws YAPI_Exception {
        if (_SingleYAPI != null) {
            throw new YAPI_Exception(-2, "SetSingleThreadMode must be called before start using the Yoctopuce API");
        }
        _MultipleYAPI = new HashMap();
    }

    static double ystr2float(String val) {
        double res;
        try {
            res = Double.parseDouble(val);
        }
        catch (NumberFormatException ignore) {
            res = 0.0;
        }
        return res;
    }

    static synchronized YAPIContext GetYCtx(boolean instanciateNew) {
        if (_MultipleYAPI != null) {
            YAPIContext context = _MultipleYAPI.get(Thread.currentThread().getId());
            if (context == null && instanciateNew) {
                context = new YAPIContext();
                _MultipleYAPI.put(Thread.currentThread().getId(), context);
            }
            return context;
        }
        if (_SingleYAPI == null && instanciateNew) {
            _SingleYAPI = new YAPIContext();
        }
        return _SingleYAPI;
    }

    static String Base64Encode(byte[] data, int ofs, int len) {
        StringBuilder res = new StringBuilder(len * 3 / 2);
        while (len > 0) {
            byte[] tmp_buff = new byte[]{-1, -1, -1, -1};
            int i = data[ofs++] & 0xFF;
            tmp_buff[0] = (byte)((i & 0xFC) >> 2);
            tmp_buff[1] = (byte)((i & 3) << 4);
            if (--len > 0) {
                i = data[ofs++];
                tmp_buff[1] = (byte)(tmp_buff[1] | (i & 0xF0) >> 4);
                tmp_buff[2] = (byte)((i & 0xF) << 2);
                if (--len > 0) {
                    i = data[ofs++];
                    --len;
                    tmp_buff[2] = (byte)(tmp_buff[2] | (i & 0xC0) >> 6);
                    tmp_buff[3] = (byte)(i & 0x3F);
                }
            }
            for (i = 0; i < 4; ++i) {
                int j = tmp_buff[i] & 0xFF;
                if (j <= 25) {
                    res.append((char)(65 + j));
                    continue;
                }
                if (j <= 51) {
                    res.append((char)(97 + j - 26));
                    continue;
                }
                if (j <= 61) {
                    res.append((char)(48 + j - 52));
                    continue;
                }
                if (j == 62) {
                    res.append('+');
                    continue;
                }
                if (j == 63) {
                    res.append('/');
                    continue;
                }
                res.append('=');
            }
        }
        return res.toString();
    }

    static byte[] Base64Decode(String source) {
        ByteArrayOutputStream res = new ByteArrayOutputStream(source.length() * 3 / 4);
        boolean ofs = false;
        int i = 0;
        int sourceLen = source.length();
        int byteNum = 0;
        int acc = 0;
        while (i < sourceLen) {
            int val;
            char c;
            if ((c = source.charAt(i++)) >= 'A' && c <= 'Z') {
                val = c - 65;
            } else if (c >= 'a' && c <= 'z') {
                val = c - 97 + 26;
            } else if (c >= '0' && c <= '9') {
                val = c - 48 + 52;
            } else if (c == '+' || c == '-') {
                val = 62;
            } else {
                if (c != '/' && c != '_') continue;
                val = 63;
            }
            if (byteNum == 0) {
                acc = val << 2 & 0xFF;
                ++byteNum;
                continue;
            }
            if (byteNum == 1) {
                res.write((acc |= (val & 0xFF) >> 4) & 0xFF);
                acc = val << 4 & 0xFF;
                ++byteNum;
                continue;
            }
            if (byteNum == 2) {
                res.write((acc |= (val & 0xFF) >> 2) & 0xFF);
                acc = val << 6 & 0xFF;
                ++byteNum;
                continue;
            }
            res.write((acc |= val & 0x3F) & 0xFF);
            acc = 0;
            byteNum = 0;
        }
        if (byteNum > 0) {
            res.write(acc & 0xFF);
        }
        return res.toByteArray();
    }

    public static void SetUSBPacketAckMs(int pktAckDelay) {
        YAPIContext yctx = YAPI.GetYCtx(true);
        yctx.SetUSBPacketAckMs(pktAckDelay);
    }

    public static String GetAPIVersion() {
        return "2.1.6624" + YUSBHub.getAPIVersion();
    }

    public static int InitAPI(int mode) throws YAPI_Exception {
        YAPIContext yctx = YAPI.GetYCtx(true);
        return yctx.InitAPI(mode);
    }

    public static void FreeAPI() {
        if (_MultipleYAPI != null) {
            YAPIContext yctx = _MultipleYAPI.get(Thread.currentThread().getId());
            if (yctx != null) {
                yctx.FreeAPI();
            }
            _MultipleYAPI.remove(Thread.currentThread().getId());
        } else {
            YAPIContext yctx = _SingleYAPI;
            if (yctx != null) {
                yctx.FreeAPI();
            }
            _SingleYAPI = null;
        }
    }

    public static int RegisterHub(String url) throws YAPI_Exception {
        return YAPI.GetYCtx(true).RegisterHub(url);
    }

    public static int RegisterHub(String url, InputStream request, OutputStream response) throws YAPI_Exception {
        return YAPI.GetYCtx(true).RegisterHub(url, request, response);
    }

    public static int PreregisterHubWebSocketCallback(Object session) throws YAPI_Exception {
        return YAPI.GetYCtx(true).PreregisterHubWebSocketCallback(session, null, null);
    }

    public static int PreregisterHubWebSocketCallback(Object session, String user, String pass) throws YAPI_Exception {
        return YAPI.GetYCtx(true).PreregisterHubWebSocketCallback(session, user, pass);
    }

    public static void UnregisterHubWebSocketCallback(Object session) {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            return;
        }
        yCtx.UnregisterHubWebSocketCallback(session);
    }

    public static void EnableUSBHost(Object osContext) throws YAPI_Exception {
        YAPI.GetYCtx(true).EnableUSBHost(osContext);
    }

    public static int PreregisterHub(String url) throws YAPI_Exception {
        return YAPI.GetYCtx(true).PreregisterHub(url);
    }

    public static void UnregisterHub(String url) {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            return;
        }
        yCtx.UnregisterHub(url);
    }

    public static int TestHub(String url, int mstimeout) throws YAPI_Exception {
        return YAPI.GetYCtx(true).TestHub(url, mstimeout);
    }

    public static int UpdateDeviceList() throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.UpdateDeviceList();
    }

    public static int HandleEvents() throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.HandleEvents();
    }

    public static int Sleep(long ms_duration) throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.Sleep(ms_duration);
    }

    public static int TriggerHubDiscovery() throws YAPI_Exception {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            throw new YAPI_Exception(-1, "API not initialized");
        }
        return yCtx.TriggerHubDiscovery();
    }

    public static long GetTickCount() {
        return System.currentTimeMillis();
    }

    public static boolean CheckLogicalName(String name) {
        return name != null && (name.equals("") || name.length() <= 19 && name.matches("^[A-Za-z0-9_-]*$"));
    }

    public static void RegisterDeviceArrivalCallback(DeviceArrivalCallback arrivalCallback) {
        YAPI.GetYCtx(true).RegisterDeviceArrivalCallback(arrivalCallback);
    }

    public static void RegisterDeviceChangeCallback(DeviceChangeCallback changeCallback) {
        YAPI.GetYCtx(true).RegisterDeviceChangeCallback(changeCallback);
    }

    public static void RegisterDeviceRemovalCallback(DeviceRemovalCallback removalCallback) {
        YAPI.GetYCtx(true).RegisterDeviceRemovalCallback(removalCallback);
    }

    public static void RegisterHubDiscoveryCallback(HubDiscoveryCallback hubDiscoveryCallback) {
        YAPIContext yCtx = YAPI.GetYCtx(false);
        if (yCtx == null) {
            return;
        }
        yCtx.RegisterHubDiscoveryCallback(hubDiscoveryCallback);
    }

    public static void RegisterLogFunction(LogCallback logfun) {
        YAPI.GetYCtx(true).RegisterLogFunction(logfun);
    }

    public void SetHTTPCallbackCacheDir(String directory) throws YAPI_Exception {
        YAPI.GetYCtx(true).SetHTTPCallbackCacheDir(directory);
    }

    public void ClearHTTPCallbackCacheDir(boolean removeFiles) {
        YAPI.GetYCtx(true).ClearHTTPCallbackCacheDir(removeFiles);
    }

    public static void SetDeviceListValidity(int deviceListValidity) {
        YAPI.GetYCtx(true).SetDeviceListValidity(deviceListValidity);
    }

    public static int GetDeviceListValidity() {
        return YAPI.GetYCtx(true).GetDeviceListValidity();
    }

    public static String GetYAPISharedLibraryPath() {
        return YAPI.GetYCtx(true).GetYAPISharedLibraryPath();
    }

    public static String AddUdevRule(boolean force) {
        return YAPI.GetYCtx(true).AddUdevRule(force);
    }

    public static String DownloadHostCertificate(String url, long mstimeout) {
        return YAPI.GetYCtx(true).DownloadHostCertificate(url, mstimeout);
    }

    public static String AddTrustedCertificates(String certificate) {
        return YAPI.GetYCtx(true).AddTrustedCertificates(certificate);
    }

    public static String SetTrustedCertificatesList(String certificatePath) {
        return YAPI.GetYCtx(true).SetTrustedCertificatesList(certificatePath);
    }

    public static String SetNetworkSecurityOptions(int opts) {
        return YAPI.GetYCtx(true).SetNetworkSecurityOptions(opts);
    }

    public static void SetNetworkTimeout(int networkMsTimeout) {
        YAPI.GetYCtx(true).SetNetworkTimeout(networkMsTimeout);
    }

    public static int GetNetworkTimeout() {
        return YAPI.GetYCtx(true).GetNetworkTimeout();
    }

    public static void SetCacheValidity(long cacheValidityMs) {
        YAPI.GetYCtx(true).SetCacheValidity(cacheValidityMs);
    }

    public static long GetCacheValidity() {
        return YAPI.GetYCtx(true).GetCacheValidity();
    }

    public static YHub nextHubInUseInternal(int hubref) {
        return YAPI.GetYCtx(true).nextHubInUseInternal(hubref);
    }

    public static YHub getYHubObj(int hubref) {
        return YAPI.GetYCtx(true).getYHubObj(hubref);
    }

    static {
        _BaseType.put("Function", YPEntry.BaseClass.Function);
        _BaseType.put("Sensor", YPEntry.BaseClass.Sensor);
        _MultipleYAPI = null;
        _SingleYAPI = null;
    }

    public static interface HubDiscoveryCallback {
        public void yHubDiscoveryCallback(String var1, String var2);
    }

    public static interface CalibrationHandlerCallback {
        public double yCalibrationHandler(double var1, int var3, ArrayList<Integer> var4, ArrayList<Double> var5, ArrayList<Double> var6);
    }

    public static interface LogCallback {
        public void yLog(String var1);
    }

    public static interface DeviceChangeCallback {
        public void yDeviceChange(YModule var1);
    }

    public static interface DeviceRemovalCallback {
        public void yDeviceRemoval(YModule var1);
    }

    public static interface DeviceArrivalCallback {
        public void yDeviceArrival(YModule var1);
    }
}

