/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YSdi12Port;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class YSdi12SensorInfo {
    protected YSdi12Port _sdi12Port;
    protected boolean _isValid;
    protected String _addr;
    protected String _proto;
    protected String _mfg;
    protected String _model;
    protected String _ver;
    protected String _sn;
    protected ArrayList<ArrayList<String>> _valuesDesc = new ArrayList();

    YSdi12SensorInfo(YSdi12Port sdi12Port, String json_str) throws YAPI_Exception {
        this._sdi12Port = sdi12Port;
        this._parseInfoStr(json_str);
    }

    public void _throw(int errcode, String msg) throws YAPI_Exception {
        this._sdi12Port._throw(errcode, msg);
    }

    public boolean isValid() {
        return this._isValid;
    }

    public String get_sensorAddress() {
        return this._addr;
    }

    public String get_sensorProtocol() {
        return this._proto;
    }

    public String get_sensorVendor() {
        return this._mfg;
    }

    public String get_sensorModel() {
        return this._model;
    }

    public String get_sensorVersion() {
        return this._ver;
    }

    public String get_sensorSerial() {
        return this._sn;
    }

    public int get_measureCount() {
        return this._valuesDesc.size();
    }

    public String get_measureCommand(int measureIndex) throws YAPI_Exception {
        if (measureIndex >= this._valuesDesc.size()) {
            throw new YAPI_Exception(-2, "Invalid measure index");
        }
        return this._valuesDesc.get(measureIndex).get(0);
    }

    public int get_measurePosition(int measureIndex) throws YAPI_Exception {
        if (measureIndex >= this._valuesDesc.size()) {
            throw new YAPI_Exception(-2, "Invalid measure index");
        }
        return YAPIContext._atoi(this._valuesDesc.get(measureIndex).get(2));
    }

    public String get_measureSymbol(int measureIndex) throws YAPI_Exception {
        if (measureIndex >= this._valuesDesc.size()) {
            throw new YAPI_Exception(-2, "Invalid measure index");
        }
        return this._valuesDesc.get(measureIndex).get(3);
    }

    public String get_measureUnit(int measureIndex) throws YAPI_Exception {
        if (measureIndex >= this._valuesDesc.size()) {
            throw new YAPI_Exception(-2, "Invalid measure index");
        }
        return this._valuesDesc.get(measureIndex).get(4);
    }

    public String get_measureDescription(int measureIndex) throws YAPI_Exception {
        if (measureIndex >= this._valuesDesc.size()) {
            throw new YAPI_Exception(-2, "Invalid measure index");
        }
        return this._valuesDesc.get(measureIndex).get(5);
    }

    public ArrayList<ArrayList<String>> get_typeMeasure() {
        return this._valuesDesc;
    }

    public void _parseInfoStr(String infoStr) throws YAPI_Exception {
        if (infoStr.length() > 1) {
            if (infoStr.substring(0, 2).equals("ER")) {
                String errmsg;
                this._addr = errmsg = infoStr.substring(2, 2 + infoStr.length() - 2);
                this._proto = errmsg;
                this._mfg = errmsg;
                this._model = errmsg;
                this._ver = errmsg;
                this._sn = errmsg;
                this._isValid = false;
            } else {
                this._addr = infoStr.substring(0, 1);
                this._proto = infoStr.substring(1, 3);
                this._mfg = infoStr.substring(3, 11);
                this._model = infoStr.substring(11, 17);
                this._ver = infoStr.substring(17, 20);
                this._sn = infoStr.substring(20, 20 + infoStr.length() - 20);
                this._isValid = true;
            }
        }
    }

    public void _queryValueInfo() throws YAPI_Exception {
        ArrayList val = new ArrayList();
        ArrayList<Object> data = new ArrayList();
        ArrayList<Object> listVal = new ArrayList<Object>();
        int size = 4;
        for (int k = 0; k < 10; ++k) {
            String value;
            int nbVal;
            String infoNbVal = this._sdi12Port.querySdi12(this._addr, String.format(Locale.US, "IM%d", k), 5000);
            if (infoNbVal.length() <= 1 || (nbVal = YAPIContext._atoi(value = infoNbVal.substring(4, 4 + infoNbVal.length() - 4))) == 0) continue;
            val.clear();
            for (int i = 0; i < nbVal; ++i) {
                String cmd = String.format(Locale.US, "IM%d_00%d", k, i + 1);
                String infoVal = this._sdi12Port.querySdi12(this._addr, cmd, 5000);
                data = new ArrayList<String>(Arrays.asList(infoVal.split(";")));
                data = new ArrayList<String>(Arrays.asList(((String)data.get(0)).split(",")));
                listVal.clear();
                listVal.add(String.format(Locale.US, "M%d", k));
                listVal.add(Integer.toString(i + 1));
                int j = 0;
                while (data.size() < size) {
                    data.add("");
                }
                while (j < data.size()) {
                    listVal.add(data.get(j));
                    ++j;
                }
                val.add(new ArrayList(listVal));
            }
        }
        this._valuesDesc = val;
    }
}

