/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import java.util.ArrayList;

public class YTilt
extends YSensor {
    public static final int BANDWIDTH_INVALID = -1;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final int AXIS_INVALID = -1;
    protected int _bandwidth = -1;
    protected int _axis = -1;
    protected UpdateCallback _valueCallbackTilt = null;
    protected TimedReportCallback _timedReportCallbackTilt = null;

    protected YTilt(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "Tilt";
    }

    protected YTilt(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("bandwidth")) {
            this._bandwidth = json_val.getInt("bandwidth");
        }
        if (json_val.has("axis")) {
            this._axis = json_val.getInt("axis");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_bandwidth() throws YAPI_Exception {
        int res;
        YTilt yTilt = this;
        synchronized (yTilt) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._bandwidth;
        }
        return res;
    }

    public int getBandwidth() throws YAPI_Exception {
        return this.get_bandwidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_bandwidth(int newval) throws YAPI_Exception {
        YTilt yTilt = this;
        synchronized (yTilt) {
            String rest_val = Integer.toString(newval);
            this._setAttr("bandwidth", rest_val);
        }
        return 0;
    }

    public int setBandwidth(int newval) throws YAPI_Exception {
        return this.set_bandwidth(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_axis() throws YAPI_Exception {
        int res;
        YTilt yTilt = this;
        synchronized (yTilt) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._axis;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YTilt FindTilt(String func) {
        YTilt obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YTilt)YFunction._FindFromCache("Tilt", func);
            if (obj == null) {
                obj = new YTilt(func);
                YFunction._AddToCache("Tilt", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YTilt FindTiltInContext(YAPIContext yctx, String func) {
        YTilt obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YTilt)YFunction._FindFromCacheInContext(yctx, "Tilt", func);
            if (obj == null) {
                obj = new YTilt(yctx, func);
                YFunction._AddToCache("Tilt", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackTilt = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackTilt != null) {
            this._valueCallbackTilt.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        YTilt sensor = this;
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(sensor, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(sensor, false);
        }
        this._timedReportCallbackTilt = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackTilt != null) {
            this._timedReportCallbackTilt.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public int calibrateToZero() throws YAPI_Exception {
        ArrayList<Double> rawVals = new ArrayList<Double>();
        ArrayList<Double> refVals = new ArrayList<Double>();
        double currentRawVal = this.get_currentRawValue();
        rawVals.clear();
        refVals.clear();
        rawVals.add(currentRawVal);
        refVals.add(0.0);
        return this.calibrateFromPoints(rawVals, refVals);
    }

    public int restoreZeroCalibration() throws YAPI_Exception {
        return this._setAttr("calibrationParam", "0");
    }

    public YTilt nextTilt() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YTilt.FindTiltInContext(this._yapi, next_hwid);
    }

    public static YTilt FirstTilt() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Tilt");
        if (next_hwid == null) {
            return null;
        }
        return YTilt.FindTiltInContext(yctx, next_hwid);
    }

    public static YTilt FirstTiltInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Tilt");
        if (next_hwid == null) {
            return null;
        }
        return YTilt.FindTiltInContext(yctx, next_hwid);
    }

    public static interface UpdateCallback {
        public void yNewValue(YTilt var1, String var2);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YTilt var1, YMeasure var2);
    }
}

