/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSdi12SensorInfo;
import com.yoctopuce.YoctoAPI.YSdi12SnoopingRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class YSdi12Port
extends YFunction {
    public static final int RXCOUNT_INVALID = -1;
    public static final int TXCOUNT_INVALID = -1;
    public static final int ERRCOUNT_INVALID = -1;
    public static final int RXMSGCOUNT_INVALID = -1;
    public static final int TXMSGCOUNT_INVALID = -1;
    public static final String LASTMSG_INVALID = "!INVALID!";
    public static final String CURRENTJOB_INVALID = "!INVALID!";
    public static final String STARTUPJOB_INVALID = "!INVALID!";
    public static final int JOBMAXTASK_INVALID = -1;
    public static final int JOBMAXSIZE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    public static final String PROTOCOL_INVALID = "!INVALID!";
    public static final int VOLTAGELEVEL_OFF = 0;
    public static final int VOLTAGELEVEL_TTL3V = 1;
    public static final int VOLTAGELEVEL_TTL3VR = 2;
    public static final int VOLTAGELEVEL_TTL5V = 3;
    public static final int VOLTAGELEVEL_TTL5VR = 4;
    public static final int VOLTAGELEVEL_RS232 = 5;
    public static final int VOLTAGELEVEL_RS485 = 6;
    public static final int VOLTAGELEVEL_TTL1V8 = 7;
    public static final int VOLTAGELEVEL_SDI12 = 8;
    public static final int VOLTAGELEVEL_INVALID = -1;
    public static final String SERIALMODE_INVALID = "!INVALID!";
    protected int _rxCount = -1;
    protected int _txCount = -1;
    protected int _errCount = -1;
    protected int _rxMsgCount = -1;
    protected int _txMsgCount = -1;
    protected String _lastMsg = "!INVALID!";
    protected String _currentJob = "!INVALID!";
    protected String _startupJob = "!INVALID!";
    protected int _jobMaxTask = -1;
    protected int _jobMaxSize = -1;
    protected String _command = "!INVALID!";
    protected String _protocol = "!INVALID!";
    protected int _voltageLevel = -1;
    protected String _serialMode = "!INVALID!";
    protected UpdateCallback _valueCallbackSdi12Port = null;
    protected int _rxptr = 0;
    protected byte[] _rxbuff = new byte[0];
    protected int _rxbuffptr = 0;
    protected int _eventPos = 0;

    protected YSdi12Port(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "Sdi12Port";
    }

    protected YSdi12Port(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("rxCount")) {
            this._rxCount = json_val.getInt("rxCount");
        }
        if (json_val.has("txCount")) {
            this._txCount = json_val.getInt("txCount");
        }
        if (json_val.has("errCount")) {
            this._errCount = json_val.getInt("errCount");
        }
        if (json_val.has("rxMsgCount")) {
            this._rxMsgCount = json_val.getInt("rxMsgCount");
        }
        if (json_val.has("txMsgCount")) {
            this._txMsgCount = json_val.getInt("txMsgCount");
        }
        if (json_val.has("lastMsg")) {
            this._lastMsg = json_val.getString("lastMsg");
        }
        if (json_val.has("currentJob")) {
            this._currentJob = json_val.getString("currentJob");
        }
        if (json_val.has("startupJob")) {
            this._startupJob = json_val.getString("startupJob");
        }
        if (json_val.has("jobMaxTask")) {
            this._jobMaxTask = json_val.getInt("jobMaxTask");
        }
        if (json_val.has("jobMaxSize")) {
            this._jobMaxSize = json_val.getInt("jobMaxSize");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        if (json_val.has("protocol")) {
            this._protocol = json_val.getString("protocol");
        }
        if (json_val.has("voltageLevel")) {
            this._voltageLevel = json_val.getInt("voltageLevel");
        }
        if (json_val.has("serialMode")) {
            this._serialMode = json_val.getString("serialMode");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_rxCount() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._rxCount;
        }
        return res;
    }

    public int getRxCount() throws YAPI_Exception {
        return this.get_rxCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_txCount() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._txCount;
        }
        return res;
    }

    public int getTxCount() throws YAPI_Exception {
        return this.get_txCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_errCount() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._errCount;
        }
        return res;
    }

    public int getErrCount() throws YAPI_Exception {
        return this.get_errCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_rxMsgCount() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._rxMsgCount;
        }
        return res;
    }

    public int getRxMsgCount() throws YAPI_Exception {
        return this.get_rxMsgCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_txMsgCount() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._txMsgCount;
        }
        return res;
    }

    public int getTxMsgCount() throws YAPI_Exception {
        return this.get_txMsgCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_lastMsg() throws YAPI_Exception {
        String res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._lastMsg;
        }
        return res;
    }

    public String getLastMsg() throws YAPI_Exception {
        return this.get_lastMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_currentJob() throws YAPI_Exception {
        String res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._currentJob;
        }
        return res;
    }

    public String getCurrentJob() throws YAPI_Exception {
        return this.get_currentJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_currentJob(String newval) throws YAPI_Exception {
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            String rest_val = newval;
            this._setAttr("currentJob", rest_val);
        }
        return 0;
    }

    public int setCurrentJob(String newval) throws YAPI_Exception {
        return this.set_currentJob(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_startupJob() throws YAPI_Exception {
        String res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._startupJob;
        }
        return res;
    }

    public String getStartupJob() throws YAPI_Exception {
        return this.get_startupJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_startupJob(String newval) throws YAPI_Exception {
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            String rest_val = newval;
            this._setAttr("startupJob", rest_val);
        }
        return 0;
    }

    public int setStartupJob(String newval) throws YAPI_Exception {
        return this.set_startupJob(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_jobMaxTask() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._jobMaxTask;
        }
        return res;
    }

    public int getJobMaxTask() throws YAPI_Exception {
        return this.get_jobMaxTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_jobMaxSize() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._jobMaxSize;
        }
        return res;
    }

    public int getJobMaxSize() throws YAPI_Exception {
        return this.get_jobMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_protocol() throws YAPI_Exception {
        String res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._protocol;
        }
        return res;
    }

    public String getProtocol() throws YAPI_Exception {
        return this.get_protocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_protocol(String newval) throws YAPI_Exception {
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            String rest_val = newval;
            this._setAttr("protocol", rest_val);
        }
        return 0;
    }

    public int setProtocol(String newval) throws YAPI_Exception {
        return this.set_protocol(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_voltageLevel() throws YAPI_Exception {
        int res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._voltageLevel;
        }
        return res;
    }

    public int getVoltageLevel() throws YAPI_Exception {
        return this.get_voltageLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_voltageLevel(int newval) throws YAPI_Exception {
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            String rest_val = Integer.toString(newval);
            this._setAttr("voltageLevel", rest_val);
        }
        return 0;
    }

    public int setVoltageLevel(int newval) throws YAPI_Exception {
        return this.set_voltageLevel(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_serialMode() throws YAPI_Exception {
        String res;
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._serialMode;
        }
        return res;
    }

    public String getSerialMode() throws YAPI_Exception {
        return this.get_serialMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_serialMode(String newval) throws YAPI_Exception {
        YSdi12Port ySdi12Port = this;
        synchronized (ySdi12Port) {
            String rest_val = newval;
            this._setAttr("serialMode", rest_val);
        }
        return 0;
    }

    public int setSerialMode(String newval) throws YAPI_Exception {
        return this.set_serialMode(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YSdi12Port FindSdi12Port(String func) {
        YSdi12Port obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YSdi12Port)YFunction._FindFromCache("Sdi12Port", func);
            if (obj == null) {
                obj = new YSdi12Port(func);
                YFunction._AddToCache("Sdi12Port", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YSdi12Port FindSdi12PortInContext(YAPIContext yctx, String func) {
        YSdi12Port obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YSdi12Port)YFunction._FindFromCacheInContext(yctx, "Sdi12Port", func);
            if (obj == null) {
                obj = new YSdi12Port(yctx, func);
                YFunction._AddToCache("Sdi12Port", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackSdi12Port = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackSdi12Port != null) {
            this._valueCallbackSdi12Port.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int sendCommand(String text) throws YAPI_Exception {
        return this.set_command(text);
    }

    public String readLine() throws YAPI_Exception {
        byte[] msgbin = new byte[]{};
        ArrayList<Object> msgarr = new ArrayList();
        String url = String.format(Locale.US, "rxmsg.json?pos=%d&len=1&maxw=1", this._rxptr);
        msgbin = this._download(url);
        msgarr = this._json_get_array(msgbin);
        int msglen = msgarr.size();
        if (msglen == 0) {
            return "";
        }
        this._rxptr = this._decode_json_int((byte[])msgarr.get(--msglen));
        if (msglen == 0) {
            return "";
        }
        String res = this._json_get_string((byte[])msgarr.get(0));
        return res;
    }

    public ArrayList<String> readMessages(String pattern, int maxWait) throws YAPI_Exception {
        byte[] msgbin = new byte[]{};
        ArrayList<Object> msgarr = new ArrayList();
        ArrayList<String> res = new ArrayList<String>();
        String url = String.format(Locale.US, "rxmsg.json?pos=%d&maxw=%d&pat=%s", this._rxptr, maxWait, pattern);
        msgbin = this._download(url);
        msgarr = this._json_get_array(msgbin);
        int msglen = msgarr.size();
        if (msglen == 0) {
            return res;
        }
        this._rxptr = this._decode_json_int((byte[])msgarr.get(--msglen));
        for (int idx = 0; idx < msglen; ++idx) {
            res.add(this._json_get_string((byte[])msgarr.get(idx)));
        }
        return res;
    }

    public int read_seek(int absPos) {
        this._rxptr = absPos;
        return 0;
    }

    public int read_tell() {
        return this._rxptr;
    }

    public int read_avail() throws YAPI_Exception {
        byte[] databin = new byte[]{};
        databin = this._download(String.format(Locale.US, "rxcnt.bin?pos=%d", this._rxptr));
        String availPosStr = new String(databin, this._yapi._deviceCharset);
        int atPos = availPosStr.indexOf("@");
        int res = YAPIContext._atoi(availPosStr.substring(0, atPos));
        return res;
    }

    public int end_tell() throws YAPI_Exception {
        byte[] databin = new byte[]{};
        databin = this._download(String.format(Locale.US, "rxcnt.bin?pos=%d", this._rxptr));
        String availPosStr = new String(databin, this._yapi._deviceCharset);
        int atPos = availPosStr.indexOf("@");
        int res = YAPIContext._atoi(availPosStr.substring(atPos + 1, atPos + 1 + availPosStr.length() - atPos - 1));
        return res;
    }

    public String queryLine(String query, int maxWait) throws YAPI_Exception {
        String url;
        byte[] msgbin = new byte[]{};
        ArrayList<Object> msgarr = new ArrayList();
        if (query.length() <= 80) {
            url = String.format(Locale.US, "rxmsg.json?len=1&maxw=%d&cmd=!%s", maxWait, this._escapeAttr(query));
        } else {
            int prevpos = this.end_tell();
            this._upload("txdata", (query + "\r\n").getBytes(this._yapi._deviceCharset));
            url = String.format(Locale.US, "rxmsg.json?len=1&maxw=%d&pos=%d", maxWait, prevpos);
        }
        msgbin = this._download(url);
        msgarr = this._json_get_array(msgbin);
        int msglen = msgarr.size();
        if (msglen == 0) {
            return "";
        }
        this._rxptr = this._decode_json_int((byte[])msgarr.get(--msglen));
        if (msglen == 0) {
            return "";
        }
        String res = this._json_get_string((byte[])msgarr.get(0));
        return res;
    }

    public String queryHex(String hexString, int maxWait) throws YAPI_Exception {
        String url;
        byte[] msgbin = new byte[]{};
        ArrayList<Object> msgarr = new ArrayList();
        if (hexString.length() <= 80) {
            url = String.format(Locale.US, "rxmsg.json?len=1&maxw=%d&cmd=$%s", maxWait, hexString);
        } else {
            int prevpos = this.end_tell();
            this._upload("txdata", YAPIContext._hexStrToBin(hexString));
            url = String.format(Locale.US, "rxmsg.json?len=1&maxw=%d&pos=%d", maxWait, prevpos);
        }
        msgbin = this._download(url);
        msgarr = this._json_get_array(msgbin);
        int msglen = msgarr.size();
        if (msglen == 0) {
            return "";
        }
        this._rxptr = this._decode_json_int((byte[])msgarr.get(--msglen));
        if (msglen == 0) {
            return "";
        }
        String res = this._json_get_string((byte[])msgarr.get(0));
        return res;
    }

    public int uploadJob(String jobfile, String jsonDef) throws YAPI_Exception {
        this._upload(jobfile, jsonDef.getBytes(this._yapi._deviceCharset));
        return 0;
    }

    public int selectJob(String jobfile) throws YAPI_Exception {
        return this.set_currentJob(jobfile);
    }

    public int reset() throws YAPI_Exception {
        this._eventPos = 0;
        this._rxptr = 0;
        this._rxbuffptr = 0;
        this._rxbuff = new byte[0];
        return this.sendCommand("Z");
    }

    public int writeByte(int code) throws YAPI_Exception {
        return this.sendCommand(String.format(Locale.US, "$%02X", code));
    }

    public int writeStr(String text) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        buff = text.getBytes(this._yapi._deviceCharset);
        int bufflen = buff.length;
        if (bufflen < 100) {
            int ch = 32;
            int idx = 0;
            while (idx < bufflen && ch != 0) {
                ch = buff[idx] & 0xFF;
                if (ch >= 32 && ch < 127) {
                    ++idx;
                    continue;
                }
                ch = 0;
            }
            if (idx >= bufflen) {
                return this.sendCommand(String.format(Locale.US, "+%s", text));
            }
        }
        return this._upload("txdata", buff);
    }

    public int writeBin(byte[] buff) throws YAPI_Exception {
        return this._upload("txdata", buff);
    }

    public int writeArray(ArrayList<Integer> byteList) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        int bufflen = byteList.size();
        buff = new byte[bufflen];
        for (int idx = 0; idx < bufflen; ++idx) {
            int hexb = byteList.get(idx);
            buff[idx] = (byte)(hexb & 0xFF);
        }
        int res = this._upload("txdata", buff);
        return res;
    }

    public int writeHex(String hexString) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        int bufflen = hexString.length();
        if (bufflen < 100) {
            return this.sendCommand(String.format(Locale.US, "$%s", hexString));
        }
        buff = new byte[bufflen >>= 1];
        for (int idx = 0; idx < bufflen; ++idx) {
            int hexb = Integer.valueOf(hexString.substring(2 * idx, 2 * idx + 2), 16);
            buff[idx] = (byte)(hexb & 0xFF);
        }
        int res = this._upload("txdata", buff);
        return res;
    }

    public int writeLine(String text) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        buff = String.format(Locale.US, "%s\r\n", text).getBytes(this._yapi._deviceCharset);
        int bufflen = buff.length - 2;
        if (bufflen < 100) {
            int ch = 32;
            int idx = 0;
            while (idx < bufflen && ch != 0) {
                ch = buff[idx] & 0xFF;
                if (ch >= 32 && ch < 127) {
                    ++idx;
                    continue;
                }
                ch = 0;
            }
            if (idx >= bufflen) {
                return this.sendCommand(String.format(Locale.US, "!%s", text));
            }
        }
        return this._upload("txdata", buff);
    }

    public int readByte() throws YAPI_Exception {
        byte[] buff = new byte[]{};
        int bufflen = this._rxbuff.length;
        if (this._rxptr >= this._rxbuffptr && this._rxptr < this._rxbuffptr + bufflen) {
            int res = this._rxbuff[this._rxptr - this._rxbuffptr] & 0xFF;
            ++this._rxptr;
            return res;
        }
        int currpos = this._rxptr;
        int reqlen = 1024;
        buff = this.readBin(reqlen);
        bufflen = buff.length;
        if (this._rxptr == currpos + bufflen) {
            int res = buff[0] & 0xFF;
            this._rxptr = currpos + 1;
            this._rxbuffptr = currpos;
            this._rxbuff = buff;
            return res;
        }
        this._rxptr = currpos;
        reqlen = 16;
        buff = this.readBin(reqlen);
        bufflen = buff.length;
        if (this._rxptr == currpos + bufflen) {
            int res = buff[0] & 0xFF;
            this._rxptr = currpos + 1;
            this._rxbuffptr = currpos;
            this._rxbuff = buff;
            return res;
        }
        this._rxptr = currpos;
        buff = this._download(String.format(Locale.US, "rxdata.bin?pos=%d&len=1", this._rxptr));
        int endpos = 0;
        int mult = 1;
        for (bufflen = buff.length - 1; bufflen > 0 && (buff[bufflen] & 0xFF) != 64; --bufflen) {
            endpos += mult * ((buff[bufflen] & 0xFF) - 48);
            mult *= 10;
        }
        this._rxptr = endpos;
        if (bufflen == 0) {
            return -9;
        }
        int res = buff[0] & 0xFF;
        return res;
    }

    public String readStr(int nChars) throws YAPI_Exception {
        int bufflen;
        byte[] buff = new byte[]{};
        if (nChars > 65535) {
            nChars = 65535;
        }
        buff = this._download(String.format(Locale.US, "rxdata.bin?pos=%d&len=%d", this._rxptr, nChars));
        int endpos = 0;
        int mult = 1;
        for (bufflen = buff.length - 1; bufflen > 0 && (buff[bufflen] & 0xFF) != 64; --bufflen) {
            endpos += mult * ((buff[bufflen] & 0xFF) - 48);
            mult *= 10;
        }
        this._rxptr = endpos;
        String res = new String(buff, this._yapi._deviceCharset).substring(0, bufflen);
        return res;
    }

    public byte[] readBin(int nChars) throws YAPI_Exception {
        int bufflen;
        byte[] buff = new byte[]{};
        byte[] res = new byte[]{};
        if (nChars > 65535) {
            nChars = 65535;
        }
        buff = this._download(String.format(Locale.US, "rxdata.bin?pos=%d&len=%d", this._rxptr, nChars));
        int endpos = 0;
        int mult = 1;
        for (bufflen = buff.length - 1; bufflen > 0 && (buff[bufflen] & 0xFF) != 64; --bufflen) {
            endpos += mult * ((buff[bufflen] & 0xFF) - 48);
            mult *= 10;
        }
        this._rxptr = endpos;
        res = new byte[bufflen];
        for (int idx = 0; idx < bufflen; ++idx) {
            res[idx] = (byte)(buff[idx] & 0xFF & 0xFF);
        }
        return res;
    }

    public ArrayList<Integer> readArray(int nChars) throws YAPI_Exception {
        int bufflen;
        byte[] buff = new byte[]{};
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (nChars > 65535) {
            nChars = 65535;
        }
        buff = this._download(String.format(Locale.US, "rxdata.bin?pos=%d&len=%d", this._rxptr, nChars));
        int endpos = 0;
        int mult = 1;
        for (bufflen = buff.length - 1; bufflen > 0 && (buff[bufflen] & 0xFF) != 64; --bufflen) {
            endpos += mult * ((buff[bufflen] & 0xFF) - 48);
            mult *= 10;
        }
        this._rxptr = endpos;
        res.clear();
        for (int idx = 0; idx < bufflen; ++idx) {
            int b = buff[idx] & 0xFF;
            res.add(b);
        }
        return res;
    }

    public String readHex(int nBytes) throws YAPI_Exception {
        int bufflen;
        byte[] buff = new byte[]{};
        if (nBytes > 65535) {
            nBytes = 65535;
        }
        buff = this._download(String.format(Locale.US, "rxdata.bin?pos=%d&len=%d", this._rxptr, nBytes));
        int endpos = 0;
        int mult = 1;
        for (bufflen = buff.length - 1; bufflen > 0 && (buff[bufflen] & 0xFF) != 64; --bufflen) {
            endpos += mult * ((buff[bufflen] & 0xFF) - 48);
            mult *= 10;
        }
        this._rxptr = endpos;
        String res = "";
        int ofs = 0;
        while (ofs + 3 < bufflen) {
            res = String.format(Locale.US, "%s%02X%02X%02X%02X", res, buff[ofs] & 0xFF, buff[ofs + 1] & 0xFF, buff[ofs + 2] & 0xFF, buff[ofs + 3] & 0xFF);
            ofs += 4;
        }
        while (ofs < bufflen) {
            res = String.format(Locale.US, "%s%02X", res, buff[ofs] & 0xFF);
            ++ofs;
        }
        return res;
    }

    public String querySdi12(String sensorAddr, String cmd, int maxWait) throws YAPI_Exception {
        byte[] msgbin = new byte[]{};
        ArrayList<Object> msgarr = new ArrayList();
        String cmdChar = "";
        String pattern = sensorAddr;
        if (cmd.length() > 0) {
            cmdChar = cmd.substring(0, 1);
        }
        pattern = sensorAddr.equals("?") ? ".*" : (cmdChar.equals("M") || cmdChar.equals("D") ? String.format(Locale.US, "%s:.*", sensorAddr) : String.format(Locale.US, "%s.*", sensorAddr));
        pattern = this._escapeAttr(pattern);
        String fullCmd = this._escapeAttr(String.format(Locale.US, "+%s%s!", sensorAddr, cmd));
        String url = String.format(Locale.US, "rxmsg.json?len=1&maxw=%d&cmd=%s&pat=%s", maxWait, fullCmd, pattern);
        msgbin = this._download(url);
        if (msgbin.length < 2) {
            return "";
        }
        msgarr = this._json_get_array(msgbin);
        int msglen = msgarr.size();
        if (msglen == 0) {
            return "";
        }
        this._rxptr = this._decode_json_int((byte[])msgarr.get(--msglen));
        if (msglen == 0) {
            return "";
        }
        String res = this._json_get_string((byte[])msgarr.get(0));
        return res;
    }

    public YSdi12SensorInfo discoverSingleSensor() throws YAPI_Exception {
        String resStr = this.querySdi12("?", "", 5000);
        if (resStr.equals("")) {
            return new YSdi12SensorInfo(this, "ERSensor Not Found");
        }
        return this.getSensorInformation(resStr);
    }

    public ArrayList<YSdi12SensorInfo> discoverAllSensors() throws YAPI_Exception {
        String res;
        int i;
        ArrayList<YSdi12SensorInfo> sensors = new ArrayList<YSdi12SensorInfo>();
        ArrayList<String> idSens = new ArrayList<String>();
        idSens.clear();
        for (i = 0; i < 10; ++i) {
            res = this.querySdi12(Integer.toString(i), "!", 500);
            if (res.length() < 1) continue;
            idSens.add(res);
        }
        String lettreMin = "abcdefghijklmnopqrstuvwxyz";
        String lettreMaj = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        for (i = 0; i < 26; ++i) {
            res = this.querySdi12(lettreMin.substring(i, i + 1), "!", 500);
            if (res.length() < 1) continue;
            idSens.add(res);
        }
        while (i < 26) {
            res = this.querySdi12(lettreMaj.substring(i, i + 1), "!", 500);
            if (res.length() >= 1) {
                idSens.add(res);
            }
            ++i;
        }
        sensors.clear();
        for (i = 0; i < idSens.size(); ++i) {
            sensors.add(this.getSensorInformation((String)idSens.get(i)));
        }
        return sensors;
    }

    public ArrayList<Double> readSensor(String sensorAddr, String measCmd, int maxWait) throws YAPI_Exception {
        ArrayList<Double> res = new ArrayList<Double>();
        ArrayList<Object> tab = new ArrayList();
        ArrayList<Object> split = new ArrayList();
        String resStr = this.querySdi12(sensorAddr, measCmd, maxWait);
        tab = new ArrayList<String>(Arrays.asList(resStr.split(",")));
        split = new ArrayList<String>(Arrays.asList(((String)tab.get(0)).split(":")));
        if (split.size() < 2) {
            return res;
        }
        double valdouble = YAPI.ystr2float((String)split.get(1));
        res.add(valdouble);
        for (int i = 1; i < tab.size(); ++i) {
            valdouble = YAPI.ystr2float((String)tab.get(i));
            res.add(valdouble);
        }
        return res;
    }

    public YSdi12SensorInfo changeAddress(String oldAddress, String newAddress) throws YAPI_Exception {
        this.querySdi12(oldAddress, "A" + newAddress, 1000);
        YSdi12SensorInfo addr = this.getSensorInformation(newAddress);
        return addr;
    }

    public YSdi12SensorInfo getSensorInformation(String sensorAddr) throws YAPI_Exception {
        String res = this.querySdi12(sensorAddr, "I", 1000);
        if (res.equals("")) {
            return new YSdi12SensorInfo(this, "ERSensor Not Found");
        }
        YSdi12SensorInfo sensor = new YSdi12SensorInfo(this, res);
        sensor._queryValueInfo();
        return sensor;
    }

    public ArrayList<Double> readConcurrentMeasurements(String sensorAddr) throws YAPI_Exception {
        ArrayList<Double> res = new ArrayList();
        res = this.readSensor(sensorAddr, "D", 1000);
        return res;
    }

    public int requestConcurrentMeasurements(String sensorAddr) throws YAPI_Exception {
        String wait = this.querySdi12(sensorAddr, "C", 1000);
        wait = wait.substring(1, 4);
        int timewait = YAPIContext._atoi(wait) * 1000;
        return timewait;
    }

    public ArrayList<YSdi12SnoopingRecord> snoopMessagesEx(int maxWait, int maxMsg) throws YAPI_Exception {
        byte[] msgbin = new byte[]{};
        ArrayList<Object> msgarr = new ArrayList();
        ArrayList<YSdi12SnoopingRecord> res = new ArrayList<YSdi12SnoopingRecord>();
        String url = String.format(Locale.US, "rxmsg.json?pos=%d&maxw=%d&t=0&len=%d", this._rxptr, maxWait, maxMsg);
        msgbin = this._download(url);
        msgarr = this._json_get_array(msgbin);
        int msglen = msgarr.size();
        if (msglen == 0) {
            return res;
        }
        this._rxptr = this._decode_json_int((byte[])msgarr.get(--msglen));
        for (int idx = 0; idx < msglen; ++idx) {
            res.add(new YSdi12SnoopingRecord(new String((byte[])msgarr.get(idx), this._yapi._deviceCharset)));
        }
        return res;
    }

    public ArrayList<YSdi12SnoopingRecord> snoopMessages(int maxWait) throws YAPI_Exception {
        return this.snoopMessagesEx(maxWait, 255);
    }

    public YSdi12Port nextSdi12Port() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YSdi12Port.FindSdi12PortInContext(this._yapi, next_hwid);
    }

    public static YSdi12Port FirstSdi12Port() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Sdi12Port");
        if (next_hwid == null) {
            return null;
        }
        return YSdi12Port.FindSdi12PortInContext(yctx, next_hwid);
    }

    public static YSdi12Port FirstSdi12PortInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Sdi12Port");
        if (next_hwid == null) {
            return null;
        }
        return YSdi12Port.FindSdi12PortInContext(yctx, next_hwid);
    }

    public static interface UpdateCallback {
        public void yNewValue(YSdi12Port var1, String var2);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YSdi12Port var1, YMeasure var2);
    }
}

